// CAMERAS /////////////////////////////////////////////////////

#declare num0 = camera {  
  location  <0.0, -100.0, 200.0>
  //direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.0, 300.887, 0.0>
}

#declare num1 = camera {  
  location  <221.489, -303.075, 297.886>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-11.599, 136.887, -48.967>
}

#declare num2 = camera { 
  location  <297.977, 25.863, 833.059>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-17.901, 161.746, -7.070>
}

#declare best = camera { // Long shot looking down neck. Straight camera.
  location  <0, 630.001, 0>
  direction <0.0,     0.0,  2.2>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0, -197.7, 0>
}

#declare num3 = camera { // Long shot looking down neck
  location  <88.219, 600.655, 154.697>
  //location  <88.219, 663.655, 154.697>
  //direction <0.0,     0.0,  2.4880>
  direction <0.0,     0.0,  2.2880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-118.303, -95.738, -178.863>
}

#declare num4 = camera {  //Standars player's position (left handed) :)
  location  <-113.431, 58.225, 400.764>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.596, 30.446, -0.211>
}

#declare num5 = camera { 
  location  <-6.429, 43.266, 20.828>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-5.463, 35.868, 11.123>
}

#declare num6 = camera { 
  location  <0.0, 68.1, 300.0>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <-1.0,     0.0,  0.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.0, 68.0, 0.0>
  //rotate <0,0,90>
}

// GROUND AND SKY AND FOG ////////////////////////////////////////////////
#declare Ground =
  sphere {
    <0, 0, 0>, 1
    texture { pigment{Pink}
              finish{ ambient 0.4 }
            }
  }

#declare Sky = 
  sphere {
    <0, 0, 0>, 1 // 500 units above the ground
    texture { Blue_Sky 
              finish {
                  ambient 1.0 
              }
            scale 0.008
            }// Blue_Sky, etc 
    clipped_by{ plane{<0,1,0>, -0.05  } }
    no_shadow

    scale 1000000
    translate <0.,0.,-1000000>
    translate <0.,0.,20000>
  }

// LIGHTS //////////////////////////////////////////////////////////////
#declare Light1 = object {   // Light source Light5
  light_source {
    <100.346, 200.029, 100.035>
    color  red 1.000 green 1.000 blue 1.000
  }
}

#declare Light2 = object {   // Light source Light4
  light_source {
    <453.534, 398.412, 176.035>
    color  red 1.000 green 1.000 blue 1.000
  }
}

#declare Light3 = object {   // Light source Light6
  light_source {
    <405.429, -259.609, 176.035>
    color  red 1.000 green 1.000 blue 1.000
  }
}

#declare Light4 = object {   // Light source Light001
  light_source {
    <479.617, -273.342, -219.400>
    color  red 1.000 green 1.000 blue 1.000
  }
}

#declare Light5 = object {   // Light source Light002
  light_source {
    <463.178, 0.000, -182.833>
    color  red 1.000 green 1.000 blue 1.000
  }
}

#declare Light6 = object {   // Light source Light006
  light_source {
    <400.0, 500.0, 400.0>
    color White
    //color  red 1.0 green 0.0 blue 0.0
  }
}
#declare Light7 = object {   // Light source Light002
  light_source {
    <550.0, 300.0, 350.0>
    color White
    //color  red 0.0 green 1.0 blue 0.100
  }
}

#declare Light8 = object {   // Light source Light002
  light_source {
    <700.0, 200.0, 100.0>
    color  White
    //color  red 0.0 green 0.0 blue 1.0
  }
}

//object { Light1 }
//object { Light2 }
//object { Light3 }
//object { Light4 }
//object { Light5 }
object { Light6 }
object { Light7 }
object { Light8 }


// TEXTURES /////////////////////////////////////////////////////
//  $MRY$: 'Tan_Wood'
//  $MRY$: 'Silver_Texture'
//  $MRY$: 'Yellow_Pine'

#declare cordCol = color red 0.5 green 0.5 blue 0.0 filter 0.3
#declare cord_tex =  texture{
   pigment{cordCol}
   finish{Dull}
}
#declare GuitarRed = color red 0.7 green 0.0 blue 0.0 filter 0.3
#declare RedFinish = finish {
   diffuse   0.50
   phong   0.60
   phong_size  20.00
   specular  0.2000
   //metallic
   reflection  0.35
}
#declare BodyWood = texture { Yellow_Pine rotate< 88, 0, 0> } 
#declare RedStain = texture {
   pigment { color GuitarRed }
   finish { RedFinish }
}
#declare RedFade = texture { 
   pigment { onion
      color_map {
         [0.0 color GuitarRed filter 1.0]
         [0.3 color GuitarRed filter 1.0]
         [1.0 color GuitarRed ]
         } 
      scale <1.,1.,1000>
      }
   finish { RedFinish }
   }

// *******  HARDWARE TEXTURES  *******
//  $MRY$: 'Glass2'
//  $MRY$: 'Bronze_Texture'
//  $MRY$: 'Yellow_Pine'

#declare Bone_Texture = texture 
{
   pigment {White}
   finish {reflection 0.1}
   }

#declare ShinyBlack = texture {
// Used By most hardware
// Bridge
// Support
// State Plate  (Plate under switch)
// Pickup2
   pigment { color red  0.2 green  0.2 blue  0.2 }
   finish {
      ambient   0.20
      diffuse   0.50
      brilliance   1.00
      phong   0.60
      phong_size  20.00
      specular  0.4000
      roughness  0.0001
      metallic
      reflection  0.200
   }
}

// *******  NECK TEXTURES *******
//  $MRY$: 'Chrome_Texture'
//  $MRY$: 'DMFWood2'
//  $MRY$: 'Tan_Wood'
//  $MRY$: 'White_Marble'

// Miscellaneous defintions created by Moray.
#declare BezFlatness = 0.01
#declare BezUStep    = 3
#declare BezVStep    = 3

///////////////////////////////////////////////////////////////////
//  AMPLIFIER FROM HERE ON

///////////////////////////////////////////////////////////////////
//  Texture include file for CABINET.MDL scene.
#declare AmpTex = texture {
  pigment { color rgb < 0.1,  0.1,  0.1> }
  normal { bumps 0.4 scale 0.3}
  //finish { Dull }
}

///////////////////////////////////////////////////////////////////
//  Texture include file for AMPSWTCH.MDL scene.
#declare BlackP = texture {
  pigment { color rgb < 0.051,  0.051,  0.051> }
  finish {
    ambient   0.20
    diffuse   0.50
    brilliance   1.00
    phong   0.60
    phong_size  20.00
    reflection  0.200
  }
}
#declare RedGlass = texture {
  pigment { color rgbf < 1.000,  0.000,  0.000,  0.5> }
  finish {
    ambient   0.20
    diffuse   0.50
    brilliance   1.00
    phong   0.60
    phong_size  20.00
  }
}

///////////////////////////////////////////////////////////////////
//  Texture include file for AMPKNOBS.MDL scene.
//  $MRY$: 'ShinyBrown'
#declare ShinyBrown = texture {
  pigment { color DarkBrown }
  finish {
    ambient   0.20
    diffuse   0.70
    brilliance   1.00
    phong   0.60
    phong_size  20.00
    specular  0.2000
    roughness  0.0001
    metallic
  }
}

///////////////////////////////////////////////////////////////////
//  Texture include file for SPEAEKRS.MDL scene.
// *******  T E X T U R E S  *******
#declare MattBlack = texture {
  pigment { color rgb < 0.000,  0.000,  0.000> }
  finish { Dull }
}
#declare ShinyBlack = texture {
  pigment { color rgb < 0.1,  0.1,  0.1> }
  finish { Shiny }
}
#declare MeshTex = texture {
  pigment { color rgbf < 0.75,  0.75,  0.75,  0.9> }
  normal { bumps 0.9 scale 0.3}
  finish {phong 0.3}
}
