// ********  O B J E C T S *******
#declare FretCutter = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <6.000000, 7.000000, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, 1.700000>
}

#declare Fret = quartic {
           // Torus MinRadius=   0.175   MajRadius=  70.175 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -9849.122,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -9849.122,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  9849.000, 0.000,  24250699.198 >
  rotate <-90.000000, -90.000000, -0.000000>
}

#declare TheBrassNut = quartic { 
           // Torus MinRadius=   0.400   MajRadius=  70.400 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -9912.640,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -9912.640,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  9912.000, 0.000,  24561938.117 >
  texture { Bone_Texture }
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 85.000000, -65.000000>
}

#declare Low12Bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.784665, 26.170666, 2.656006>
  translate <-0.096624, 54.900000, 3.641657>
}

#declare Low12 = union {
  object { Fret translate <0.000000, 31.100000, -65.000000> } // Fret13 
  object { Fret translate <0.000000, 34.900000, -65.000000> } // Fret14 
  object { Fret translate <0.000000, 39.100000, -65.000000> } // Fret15 
  object { Fret translate <0.000000, 42.700000, -65.000000> } // Fret16 
  object { Fret translate <0.000000, 46.500000, -65.000000> } // Fret17 
  object { Fret translate <0.000000, 50.500000, -65.000000> } // Fret18 
  object { Fret translate <0.000000, 54.700000, -65.000000> } // Fret19 
  object { Fret translate <0.000000, 59.100000, -65.000000> } // Fret20 
  object { Fret translate <0.000000, 63.700000, -65.000000> } // Fret21 
  object { Fret translate <0.000000, 68.500000, -65.000000> } // Fret22 
  object { Fret translate <0.000000, 73.500000, -65.000000> } // Fret23 
  object { Fret translate <0.000000, 78.700000, -65.000000> } // Fret24 
  object { TheBrassNut }
  bounded_by { Low12Bound }
}


#declare High12Bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.714893, 15.986666, 2.384771>
  translate <-0.091143, 13.750000, 3.572297>
}

#declare High12 = union {
  object { Fret translate <0.000000, 2.000000, -65.000000> } //Fret2
  object { Fret translate <0.000000, 4.000000, -65.000000> } //Fret3
  object { Fret translate <0.000000, 6.000000, -65.000000> } //Fret4
  object { Fret translate <0.000000, 8.000000, -65.000000> } //Fret5
  object { Fret translate <0.000000, 10.200000, -65.000000> } //Fret6
  object { Fret translate <0.000000, 12.500000, -65.000000> } //Fret7
  object { Fret translate <0.000000, 15.100000, -65.000000> } //Fret8
  object { Fret translate <0.000000, 17.900000, -65.000000> } //Fret9
  object { Fret translate <0.000000, 20.900000, -65.000000> } //Fret10
  object { Fret translate <0.000000, 24.100000, -65.000000> } //Fret11
  object { Fret translate <0.000000, 27.500000, -65.000000> } //Fret12
  bounded_by { High12Bound }
}


#declare AllFrets = union {
  object { Low12 }
  object { High12 }
}

#declare CutFrets = intersection {
  object { FretCutter }
  object { AllFrets }
  texture { Silver_Texture }
}

#declare FretBoardCutter = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <6.000000, 6.000000, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, 5.000000>
}

#declare Board1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <70.099998, 70.099998, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, -65.000000>
}

#declare InnerBoard = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <69.300003, 69.300003, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, -65.000000>
}

#declare FretBoard = difference {
  object { Board1 }
  object { InnerBoard }
}

#declare CutFretBoard = intersection {
  object { FretBoardCutter }
  object { FretBoard }
  texture { DMFWood2 rotate <88,2,2> }
}
////////////////////////////
#declare Bound003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <8.130559, 48.588905, 4.000000>
  translate <0.000000, 42.500000, 2.000000>
}

#declare FretsNBoard = union {
  object { CutFrets }
  object { CutFretBoard }
  bounded_by { Bound003 }
}
////////////////////////////

#declare Bound002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <6.517418, 47.897171, 3.188136>
  translate <0.177583, 42.500000, 1.569632>
}

#declare NeckBack = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <6.000000, 6.000000, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, 5.000000>
}

#declare NeckCutter = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <69.300003, 69.300003, 85.000000>
  rotate <-90.000000, -90.000000, -0.000000>
  translate <0.000000, 0.000000, -65.000000>
}

#declare BackNeck = intersection {
  object { NeckBack }
  object { NeckCutter }
  texture {
    Tan_Wood
  }
  bounded_by { Bound002 }
}

#declare Neck = union {
  object { FretsNBoard }
  object { BackNeck }
  translate <0.000000, 0.000000, 3.000000>
}

#declare Bound005 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <3.613213, 30.707970, 0.969591>
  translate <-0.191603, 41.144442, 7.649695>
}

/////////////// FRET SPOTS //////////////////////////////////////////
#declare FretSpot = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 1.000000>
}

#declare FretSpot12a = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 1.000000>
  rotate <-0.000000, -2.000000, -0.000000>
  translate <-2.817776, 32.913152, 7.150000>
}

#declare FretSpot12b = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.500000, 0.500000, 1.000000>
  rotate <-0.000000, 2.000000, -0.000000>
  translate <2.434569, 32.913152, 7.150000>
}

#declare FretSpots12 = union {
  object { FretSpot12a }
  object { FretSpot12b }
}


#declare FretSpots = union {
  object {FretSpot translate <0.000000, 70.899967, 7.150000> } //FretSpot3
  object {FretSpot translate <0.000000, 61.290558, 7.150000> } //FretSpot5
  object {FretSpot translate <0.000000, 52.504207, 7.150000> } //FretSpot7
  object {FretSpot translate <0.000000, 44.522560, 7.150000> } //FretSpot9
  object {FretSpot translate <0.000000, 22.370564, 7.150000> } //FretSpot15
  object {FretSpot translate <0.000000, 16.547506, 7.150000> } //FretSpot17
  object {FretSpot translate <0.000000, 11.388918, 7.150000> } //FretSpot19
  object {FretSpots12 }
  texture { Bone_Texture }
  bounded_by { Bound005 }
}

#declare TheFretBoard = union {
  object { Neck }
  object { FretSpots }
  scale <2.000000, 2.000000, 2.000000>
  translate <0.000000, 104.000000, -13.000000>
}
