// OUTLET.INC - Wall Outlet in TOYS.POV
//
// By Neil Clark
//
#declare outlet = intersection
  {
   object { Disk_Z  scale <1.25,1.25,0.5>  pigment { color White }}
   object { box { <-2,-1.125,-1>, <2,1.125,1> } pigment { color White }}
  }

#declare hole = intersection
  {
   object { Disk_Z  scale <1.25,1.25,0.5> }
   object { box { <-2,-1.125,-1>, <2,1.125,1> }}
   pigment { color rgbf <1,1,1,1> }
   scale <1,1,3>
  }

#declare wall_plate = difference {
   object {
     box { < -1, -1, 0 >, < 1, 1, 0.5> }
     scale <2.5, 4, 1>
     texture { pigment { color White }}
    }
   object {
     Cone_Z
     scale < 0.4, 0.4, 1 >
     translate <0,0,-0.3>
     texture { pigment { color White }}
    }
}

#declare ground_plug = difference {
  object {
    Disk_Z
    scale <0.25,0.25,1>
    translate <0,0,0.5>
    pigment { color rgbf <1,1,1,1> }
    }
  object { box { <-1,-1,-1>,<1,-0.125,1> }}
}

#declare plug = difference {
  object {
    outlet
    scale <0.96,0.96,1>
    translate <0,0,0.5>
    texture { pigment { color White }}
    }
  object {
    box { <-0.55,-0.4,-2>, <-0.3,0.5,2> }
    translate <0,0,0.5>
    texture { pigment { color White }}
    }
  object {
    box { <0.3,-0.4,-2>, <0.55,0.5,2> }
    translate <0,0,0.5>
    texture { pigment { color White }}
    }
  object { ground_plug translate <0,-0.85,-0.5> }
}

#declare Wall_Outlet = union {
  difference {
    object { wall_plate translate <0,3,0> }
    object { hole translate <0,4.5,0> }
    object { hole translate <0,1.5,0> }
   }
  object { plug translate <0,4.5,0> }
  object { plug translate <0,1.5,0> }
}

