// TOYS.POV - - by Neil Clark
//
// January 5, 1995
//
// Very LARGE scene file(s) that renders some of my 'TOYS'
// on a parkay wooden floor with a toy chest and toys all around.
//
// This image requires a HUGE swap file and took 11 hours - 32 minutes
// to render at 800x600, +a option on an HP-9000 machine.
//
// For the Internet January 'TOYS' contest.
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

// user defined include files & object shapes

// Red Indy Race Car
#include "indy.inc"      // car body composite of 3 ellipsoids and tail section
#include "dunlop.inc"    // tire, wheel, rim, spokes, and hubcap definitions
#include "4views.inc"    // inc file for 4 different views
#include "carpos.inc"    // parts positions

// Tinker Toy House
#include "ttoy.inc"
#include "ttoy2.inc"

// Bi Plane Airplane
#include "biplane.inc"

// Lego Shapes
#include "legos.inc"

// Charlie the Can
#include "charlie.inc"

// Wooden Toy Box
#include "toybox.inc"

// Wall Picture
#include "rainier.inc"

// Train Set
#include "d:\temp\choochoo.inc"

// Parkay Floor Tiles
#include "parkay.inc"

// Wall Baseboards
#include "base.inc"

// Wall Outlet
#include "outlet.inc"

// Camera
camera
  {
   location   <7, 5, -16>       // good iso front
   direction  <0, 0, 1.0>
   up         <0, 1, 0>
   right      <1.3333, 0, 0 >
   look_at    <4, 7, -2>
  }

// Lights
light_source { <130, 60, -150> color White }
light_source {
    <3, 33, -4> color White
    area_light <7, 0, 0>, <0, 8, 0>, 3, 3
    adaptive 0
    jitter
    spotlight
    point_at <10, 0, -1>
    tightness 0
    radius 0
    falloff 55
}

// Build the race car
#declare Red_Indy = union {
  object { car_body translate <0, 0, 0> }
  object { rr_wheel rotate <0.0, 0.0, trot>
        translate <0, -0.35, -2.0> translate <rtposr, 0.0, 0.0> }
  object { rf_wheel rotate <0.0, 0.0, trot>
        translate <0, -0.35, -2.0> translate <rtposf, 0.0, 0.0> }
  object { lr_wheel rotate <0.0, 0.0, trot>
        translate <0, -0.35, 2.0> translate <rtposr, 0.0, 0.0> }
  object { lf_wheel rotate <0.0, 0.0, trot>
        translate <0, -0.35, 2.0> translate <rtposf, 0.0, 0.0> }
  object { axle translate <2.5, -0.35, -1.6> } // rf
  object { axle translate <-2, -0.35, -1.6> } // rr
  object { axle translate <2.5, -0.35, 1.6> } // lf
  object { axle translate <-2, -0.35, 1.6> } //lr
}

// Red Indy Race Car
object {
  Red_Indy
  scale <0.6,0.6,0.6>
  rotate <0,-25,0>
  translate <3.5,-0.4,2.5>
  }

// Tinker Toy House
object { TTOY_HOUSE
  scale <0.55,0.55,0.55>
  rotate <0,-55,0>
  translate <-6, -0.62, 1>
  }

// Bi-Plane Airplane
object {
 BiPlane
 scale <0.01, 0.01, 0.01>
 rotate <0,0,-23>
 rotate <0,-45,0>
 translate <6,0.6,8>
}

// Legos on Floor
#declare Legos = union {
  // single lego dot
  object { Single_White translate <-3,-1,-5> }
  object { Square_Blue translate <-4,-1,-9> }
  // Two lego dots
  object { Two_Yellow translate <-5, -1,-4> }
  object { Two_Blue rotate <-90,-20,0> translate <-1,-1,-4>}
  // Four lego dots
  object { Four_Red translate <2,0,-4> }
  object { Four_Red translate <2,1,-2> }
  object { Four_Red rotate <0, 45, 0> translate <-7.1,-1,-7> }
  // 6 lego dots
  object { Six_Red translate <-1,-1,-2> }
  object { Six_Yellow rotate <0, 60, 0> translate <-3,-1,-7> }
  // 12 lego dots
  object { Twelve_Red translate <-7,-1,-2> }
  object { Twelve_Red translate <-2,0,-2> }
  object { Twelve_Red rotate <0,90,0> translate <2,-1,-2> }
 }

object {
  Legos
  rotate <0,-35,0>
  scale <0.3,0.3,0.3>
  translate <11,-0.7,7>
}

object
 {
  Charlie
  rotate <10, 0, 0>
  rotate <0, 35, 0>
  translate <-1.5,0.7,10>
 }

// Toy Box
object {
 toy_box
 rotate <0,-10,0>
 scale <0.3, 0.5, 0.4>
 translate <4,5.5,25>
}

// Wall Picture

object
 {
  Rainier
  scale <0.25, 0.25, 0.25>
  rotate <0,-90,0>
  translate <-15.1,17,12>
 }

// Train Set

object
 {
  Train
  scale <0.02, 0.02, 0.02>
  rotate <0,140,0>
  translate <18,0.23,19>
 }

// Left Wall
object {
  box { <-17,-4,0>, <-16,96,100>
    texture {
      pigment {
        image_map {
         gif "f:\3dplus\textures\wood2.gif"
         interpolate 2
         }
        rotate <90,180,0>
        scale <3,2,3>
      }
    }
  }
}

// Back Wall
#declare Back_Wall = object {
  box { <-21,-4,48>, <100,96,49>
    texture {
      pigment {
        image_map {
         gif "f:\3dplus\textures\wood2.gif"
         interpolate 2
         }
        rotate <90,0,0>
        scale <3.1,2,3.1>
       }
     }
   }
 }

// Hole in the back wall...
difference {
  object { Back_Wall }
  object { box { <10,19,47>,<25,38,50> }}
  texture {
    pigment {
      image_map {
      gif "f:\3dplus\textures\wood2.gif"
      interpolate 2
     }
    rotate <90,0,0>
    scale <3.1,3.1,3.1>
   }
  }
}

#declare Frame_Texture = texture { DMFLightOak scale <8,3,1> }

// Window Frame
object { box { <8,17,47.25>,<27,19,48> } texture { Frame_Texture }}
object { box { <8,38,47.25>,<27,40,48> } texture { Frame_Texture }}
object { box { <8,19,47.25>,<10,38,48> } texture { Frame_Texture rotate <0,0,90> }}
object { box { <25,19,47.25>,<27,38,48> } texture {Frame_Texture rotate <0,0,90> }}

// Center styles
object { box { <17.125,19,48.5>,<17.875,38,49.5> } texture { Frame_Texture rotate <0,0,90>}}
object { box { <10,28.125,48.5>,<25,28.875,49.5> } texture { Frame_Texture }}

// Wood Parkay Floor
#declare Tile_Row = union {
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <-43.5,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <-29,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <-14.5,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <0,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <14.5,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <29,-1,0> }
  object { Tile scale <0.5,0.5,0.5> rotate <90,0,0> translate <43.5,-1,0> }
}

// Place the floor
object { Tile_Row translate <-5,0,-14.5> }
object { Tile_Row translate <-5,0,0> }
object { Tile_Row translate <-5,0,14.5> }
object { Tile_Row translate <-5,0,29> }
object { Tile_Row translate <-5,0,43.5> }
object { Tile_Row translate <-5,0,58> }

// Corner Trim
object {
   Disk_Y
   scale <1,80,0>
   translate <-16,0,47>
   texture { DMFLightOak scale <4.4,2,1> }
}

// Wall Baseboards
object { Box_Side rotate <0,-90,0> scale <1,2,20> translate <-15, 3.2, 5> }
object { Box_Side rotate <0,0,0> scale <20,2,1> translate <-15, 3.2, 46> }

// Place the Wall Outlet
object { Wall_Outlet
 scale <0.4, 0.4, 0.4>
 rotate <0, -90, 0>
 translate <-15.9, 3.5, 9>
 pigment { color White }
 }

// Sky and clouds out the window...
#declare Sky_Top = 100
#declare Colors1 = color_map
   {
   [0.0 0.1 color rgb <2/3, 2/3, 1> color rgb <2/3, 2/3, 1>]
   [1.0 color White]
   }

#declare Colors2 = color_map
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [1.0 color White]
   }

#declare Colors3 = color_map
   {
   [0.0 0.1 color SkyBlue color SkyBlue]
   [0.70 color rgb <4/5, 4/5, 5/6>]
   [1.0 color White]
   }

#declare Storm = color_map
   {
   [0.0 0.1 color Clear color Clear]
   [0.70 color rgbf <4/5, 4/5, 5/6, 1/2>]
   [1.0 color White]
   }

#declare NClouds = texture
   {
   pigment
      {
      bozo
      turbulence 0.4
      octaves 3
      lambda 7
      color_map { Colors3 }
      }
   finish { ambient 1 diffuse 0 }
   scale 1/6
   }

// Cloud Sphere
sphere
   {
   <0, 0, 0>, 1
   texture { NClouds }
   scale <Sky_Top * 10, Sky_Top, Sky_Top * 10>
   }

