// Persistence of Vision Raytracer 2.2
// ----------------------------------------------------------------------
// #include Version of Red Tricycle
// Copyright (c) 1995 Samuel J. Goldstein, all rights reserved!
// ----------------------------------------------------------------------

#declare BikeMetal = texture {
    pigment { Gray70 }
    finish {
        ambient 0.1
        diffuse 0.7
        brilliance 6.0
        reflection 0.6
        phong 0.8
        phong_size 120
    }
}
#declare BikeMetalDark = texture {
    pigment { Gray20 }
    finish {
        ambient 0.1
        diffuse 0.7
        brilliance 6.0
        reflection 0.6
        phong 0.8
        phong_size 120
    }
}


#declare GripTexture = texture {
	finish {specular 0.1 roughness 0.5}
	pigment { granite
		color_map {
			[0.0, 0.6 color DarkSlateGray color Gray50]
			[0.6, 0.65 color Gray50 color Gray30]
			[0.65, 1.0 color Gray30 color Silver]
			}
		}
	}

#declare RubberTexture = texture {pigment {Gray30}}

#declare TricycleRed= texture {
	finish {Phong_Glossy}
	pigment {Red}		
}

#declare Reflector = texture {
	pigment {Goldenrod}
	finish {ambient 1.0
		roughness 15
		diffuse 0.1
		}
	}
#declare ribbon1 = union {
	triangle {<0,0,0>,<0,0,2>,<8,5,0>}
	triangle {<0,0,2>,<8,5,0>,<8,5,2>}
	triangle {<8,5,0>,<8,5,2>,<16,18,0>}
	triangle {<8,5,2>,<16,18,0>,<16,18,2>}
	triangle {<16,18,0>,<16,18,2>,<18,31,0>}
	triangle {<16,18,2>,<18,31,0>,<18,31,2>}
	triangle {<18,31,0>,<18,31,2>,<18,47,0>}
	triangle {<18,31,2>,<18,47,0>,<18,47,2>}
	triangle {<18,47,0>,<18,47,2>,<23,69,0>}
	triangle {<18,47,2>,<23,69,0>,<23,69,2>}
	triangle {<23,69,0>,<23,69,2>,<20,85,0>}
	triangle {<23,69,2>,<20,85,0>,<20,85,2>}
	rotate <180,0,0>
}

#declare ribbon2 = union {
	triangle {<0,0,0>,<0,0,2>,<9,12,0>}
	triangle {<0,0,2>,<9,12,0>,<9,12,2>}
	triangle {<9,12,0>,<9,12,2>,<13,23,1>}
	triangle {<9,12,2>,<13,23,1>,<13,23,3>}
	triangle {<13,23,1>,<13,23,3>,<10,35,2>}
	triangle {<13,23,3>,<10,35,2>,<10,35,4>}
	triangle {<10,35,2>,<10,35,4>,<10,50,2>}
	triangle {<10,35,4>,<10,50,2>,<10,50,4>}
	triangle {<10,50,2>,<10,50,4>,<11,60,2>}
	triangle {<10,50,4>,<11,60,2>,<11,60,4>}
	triangle {<11,60,2>,<11,60,4>,<14,67,2>}
	triangle {<11,60,4>,<14,67,2>,<14,67,4>}
	triangle {<14,67,2>,<14,67,4>,<16,82,2>}
	triangle {<14,67,4>,<16,82,2>,<16,82,4>}
	rotate <180,0,0>
}

#declare ribbon3 = union {
	triangle {<0,0,0>,<0,0,2>,<6,11,2>}
	triangle {<0,0,2>,<6,11,2>,<6,11,4>}
	triangle {<6,11,2>,<6,11,4>,<10,25,4>}
	triangle {<6,11,4>,<10,25,4>,<10,25,6>}
	triangle {<10,25,4>,<10,25,6>,<14,35,7>}
	triangle {<10,25,6>,<14,35,7>,<14,35,9>}
	triangle {<14,35,7>,<14,35,9>,<12,52,8>}
	triangle {<14,35,9>,<12,52,8>,<12,52,10>}
	triangle {<12,52,8>,<12,52,10>,<15,65,10>}
	triangle {<12,52,10>,<15,65,10>,<15,65,12>}
	triangle {<15,65,10>,<15,65,12>,<12,80,13>}
	triangle {<15,65,12>,<12,80,13>,<12,80,15>}
	rotate <180,0,0>
}

#declare ribbon4 = union {
	triangle {<0,0,0>,<0,0,2>,<5,12,-2>}
	triangle {<0,0,2>,<5,12,-2>,<5,12,0>}
	triangle {<5,12,-2>,<5,12,0>,<5,30,-4>}
	triangle {<5,12,0>,<5,30,-4>,<5,30,-2>}
	triangle {<5,30,-4>,<5,30,-2>,<7,43,-5>}
	triangle {<5,30,-2>,<7,43,-5>,<7,43,-3>}
	triangle {<7,43,-5>,<7,43,-3>,<6,56,-6>}
	triangle {<7,43,-3>,<6,56,-6>,<6,56,-4>}
	triangle {<6,56,-6>,<6,56,-4>,<8,65,-6>}
	triangle {<6,56,-4>,<8,65,-6>,<8,65,-4>}
	triangle {<8,65,-6>,<8,65,-4>,<7,75,-6>}
	triangle {<8,65,-4>,<7,75,-6>,<7,75,-4>}
	rotate <180,0,0>
}



#declare pedal=
	merge {
		difference {
			box {<-5,-2,0>,<5,2,16>}
			box {<-4,-3,1>,<4,3,15>}
			texture {BikeMetal}
			}
		sphere {<0,0,0>,1.5 scale <1,1,0.75>
			 translate <0,0,0> texture {BikeMetal}}

		sphere {<0,0,0>,1.5 scale <1,1,0.75>
			 translate <0,0,16> texture {BikeMetal}}
		cylinder {<0,0,0>,<0,0,19>,1 texture {BikeMetal}}
		box {<-5.5,-0.75,1>,<-5.0,0.75,15> texture {Reflector}}
		box {<5,-0.75,1>,<5.5,0.75,15> texture {Reflector}}
		translate <0,0,-19>
		}

#declare bellhalf = difference {
	merge {
		intersection {
			sphere {<0,0,0>,9 scale <1,0.5,1>}
			plane {-y,0}
		}
		cylinder{<0,-1.6,0>,<0,0,0>,9}
		texture {BikeMetal}		
	}
	cylinder {<0,-3,0>,<0,0,0>,8 texture {pigment{Black} finish{Dull}}}
}

#declare ringer = union {
	cylinder {<0,0,0>,<11,0.5,0>,0.65}
	cylinder {<12,0.5,-0.05>,<12,0.5,0.1>,2}
}

#declare bell = union {
	object {bellhalf rotate <180,0,0> translate <0,10,0>}
	object {bellhalf translate <0,15,0>}
	cylinder {<0,5,0>,<0,17,0>,3}
	difference {
		cylinder {<-3,0,0>,<3,0,0>,5}
		cylinder {<0,2,-6>,<0,2,6>,2}
		cylinder {<0,-2,-6>,<0,-2,6>,2}
		box {<-2,-2,-6>,<2,2,6>}
	}
	sphere {<0,0,0>,2 scale <1,0.75,1> translate <0,19.5,0>}
	object {ringer rotate <0,-25,0> translate <0,11,0>}
	texture{BikeMetalDark}	
}

#declare crank =
	merge {
		cylinder { <0,0,-0.5>,<0,0,0.5>,3 texture {BikeMetal}}
		cylinder { <25,0,-0.5>,<25,0,1.5>,4 texture {BikeMetal}}
		cone {<0,0,0.5>,2,<25,0,3>,3 scale <1,1,0.5>
			 texture {BikeMetal}}
		translate <-25,0,0>
		}

#declare pedals =
	union {
		object {pedal rotate <0,0,20> translate <-17.67,17.67,-14>}
		object {pedal rotate <180,0,0> translate <17.67,-17.67,14>}
		object {crank rotate <0,0,-45> translate <0,0,-14>}
		object {crank rotate <180,0,135> translate <0,0,14>}
		cylinder {<0,0,-14>,<0,0,14>,2 texture {BikeMetal}}
		sphere {<0,0,0>,2 scale <1,1,7.25> texture {BikeMetal}}
	}

#declare spoke = cone {<0,0,0>,10,<0,34,0>,6
			scale <1,1,0.5> texture {TricycleRed}}

#declare wheel =
	union {
		torus {40,5 sturm scale <1,0.75,1>
		       rotate <90,0,0> texture {RubberTexture}}
		difference {
			cylinder {<0,0,-2>,<0,0,2>,37}
			cylinder {<0,0,-3>,<0,0,3>,34}
			texture {BikeMetal}
			}
		cylinder {<0,0,-4>,<0,0,4>,10 texture {BikeMetal}}
		object {spoke rotate <0,0,30>}
		object {spoke rotate <0,0,150>}
		object {spoke rotate <0,0,270>}
		
	}

#declare grip =
	union {
		cylinder {<0,0,0>,<-8,0,0>,5 texture {BikeMetal}}
		cylinder {<-8,0,0>,<-25,0,0>,6 texture {GripTexture}}
		sphere {<0,0,0>,5 scale <0.5,1,1>
			translate <-25,0,0> texture {GripTexture}}
		sphere {<0,0,0>,14 scale <0.143,1,1>
			translate <-8,0,0> texture {GripTexture}}
		sphere {<0,0,0>,7 scale <0.25,1,1>
			translate <-23.25,-1,0> texture {GripTexture}}
		object {ribbon1 scale <0.5,1,1> rotate <0,180,0>
			rotate <0,0,-30> translate <-23,0,0>
			texture {pigment {Red}}}
		object {ribbon2 scale <0.5,1,1> rotate <0,180,0>
			rotate <0,0,-30> translate <-23,0,0>
			texture {pigment {Blue}}}
		object {ribbon3 scale <0.5,1,1> rotate <0,180,0>
			rotate <0,0,-30> translate <-23,0,0>
			texture {pigment {White}}}
		object {ribbon4 scale <0.5,1,1> rotate <0,180,0>
			rotate <0,0,-30> translate <-23,0,0>
			texture {pigment {Blue}}}
		scale <2,1,1>
	}

#declare handlebar =
	merge {
		cylinder {<0,0,0>,<-20,0,0>,5}
		intersection {
			torus {22.5,5 sturm rotate <90,0,0>}
			plane {-x,0 rotate <0,0,-60>}
			plane {x,0}
			translate <-20,22.5,0>
		}
		cylinder {<-39.486,11.25,0>,<-54.486,37.231,0>,5}
		intersection {
			torus {12.5,5 sturm rotate <90,0,0>}
			plane {-x,0 rotate <0,0,30>}
			plane {x,0 rotate <0,0,-60>}
			translate <-65.311,30.981,0>
			}
		object {grip rotate <0,0,30>
			translate <-71.561,41.8063,0>}
	texture {BikeMetal}
	rotate <0,90,0>
	scale <.75,.75,.75>
	}

#declare fork =
	union { 
		cone {<0,-2,0>,5,<10,60,2>,8 scale <1,1,0.5>
		 translate <0,0,-10> texture {TricycleRed}}
		cone {<0,-2,0>,5,<10,60,-2>,8 scale <1,1,0.5> 
		 translate <0,0,10> texture {TricycleRed}}
		sphere {<0,0,0>,8 scale <1,0.5,0.5> rotate <0,0,-9.4>
		 translate <10,60,-8> texture {TricycleRed}}
		sphere {<0,0,0>,8 scale <1,0.5,0.5> rotate <0,0,-9.4>
		 translate <10,60,8> texture {TricycleRed}}
		difference {
			merge {
				cylinder {<0,0,0>,<0,7,0>,9}
				sphere {<0,0,0>,9 scale <1,0.11,1>
					translate <0,7,0>}
			}
			cylinder {<-10,-2,0>,<10,-2,0>,5}
			rotate <0,0,-9.4>
			translate <10,57,0>
			texture {TricycleRed}
		}
		cylinder {<10,63,0>,<10,90,0>,5 texture {BikeMetal}}
		sphere {<10,90,0>,7 texture {BikeMetal}}
		object {handlebar rotate <0,0,5> translate <10,90,0>}
		object {handlebar rotate <0,0,5> scale <1,1,-1>
			 translate <10,90,0>}
		object {bell rotate <0,90,0> translate <10,90,-13>}
		object {pedals}
		object {wheel}
	}

#declare seat =
	intersection {
		merge {
			torus {8.25,1.25 sturm rotate <0,0,10>
				 translate <0,1.43,0>}
			cylinder {<0,-1,0>,<0,1.5,0>,8}
			intersection {
				sphere {<0,0,0>,0.5 scale <27,5,13>
				 	translate <-3,0,0>}
				plane {x,7}
				}
			}
		plane {-y,-0.5}
	scale <2,4,2>
	texture {RubberTexture}
	}


#declare rear_carriage =
	union {
		box {<-15,-11,-40>,<15,-2,40> texture {TricycleRed}}
		cylinder {<0,-11,-50>,<0,-11,50>,3 texture {BikeMetal}}
		object {wheel rotate <0,0,30>
			 scale <0.5,0.5,0.8> translate <0,-11,-47>}
		object {wheel rotate <0,0,-5>
			scale <0.5,0.5,0.8> translate <0,-11,47>}
		intersection {
			torus {40,5 sturm rotate <0,0,-65>}
			plane {-y,2}
			texture {TricycleRed}
		}
		cylinder {<-19,38,0>,<-14,68,0>,5.5
			texture {TricycleRed}}
		object {seat translate <-14,65,0>}

		cylinder {<-90,85,0>,<-19,36,0>,5.5
			texture {TricycleRed}}

		cylinder {<-90,75.25,0>,<-90,90,0>,7 texture {TricycleRed}}
		intersection {
			cylinder {<-90,75,0>,<-90,90,0>,7.1}
			cylinder {<-98,82,0>,<-90,82,0>,5 scale <1,1,0.8>} 			texture {Brass_Texture}
		}

	}


#declare tricycle =
	 union {
		object {fork}
		object {rear_carriage translate <100,-10,0>}
		}

#declare turntrike =
	union {object {fork rotate <0,-30,0>}
		object {rear_carriage translate <98.66,-10,5>}
		}

