//A TinkerToy hilbert curve by Bob Wind 1-26-95 rwind@genesee.freenet.org
//The toy structure was generated using the
//POVray and Polyray Preprocessor (PPP) version 2.5 program
//which was written by my brother John Wind
//PPP is now available on ftp.povray.org/pub/povray/incoming/utilities
//in the file named PPP25A.zip
//This is an adaptation of the HILBERT.PPP sample file included with PPP
//to demonstrate its recursive capabilities.
//I added the toy shapes and colors and conditionals to get the right
//rotations for the spools. The rest of the scene is my own creation.

#include "colors.inc"
#include "textures.inc"
#include "glasses.inc"
#declare amb=.3

camera {
  location < 32, 32, -53 >
  direction < 0, 0, 2 >
  look_at < 8, 9, -2.5 >
}

light_source { <-15, 70, -58.75> color red .4 green .4 blue .4 }
light_source { <51.25, 50, -38.75> color red .7 green .7 blue .7 }

background { color Gray }

#declare spool= 
difference {
  cylinder { <0, 0, -.3>, <0, 0, .3>,   0.6 } 
  cylinder { <0, 0, -.31>, <0, 0, .31>,   0.1 } 
  cylinder { <.3, 0, 0>, <1, 0, 0>,   0.1 } 
  cylinder { <-.3, 0, 0>, <-1, 0, 0>,   0.1 } 
  cylinder { <0, .3, 0>, <0, 1, 0>,   0.1 } 
  cylinder { <0, -.3, 0>, <0, -1, 0>,   0.1 } 
  cylinder { <.21, .21, 0>, <1, 1, 0>,   0.1 } 
  cylinder { <-.21, .21, 0>, <-1, 1, 0>,   0.1 } 
  cylinder { <-.21, -.21, 0>, <-1, -1, 0>,   0.1 } 
  cylinder { <.21, -.21, 0>, <1, -1, 0>,   0.1 } 
  cone { <0, 0, -.35>,   1.2, <0, 0, .35>,   0.5  inverse }  
  cone { <0, 0, .35>,   1.2, <0, 0, -.35>,   0.5  inverse }  
  intersection {
    cone { <0, 0, -.35>,   0.9, <0, 0, .05>,   0.5  inverse }  
    cone { <0, 0, .35>,   0.9, <0, 0, -.05>,   0.5  inverse }  
  }
}

#declare stick= 
difference {
  cylinder { <0, 0, -1.05>, <0, 0, 1.05>,   0.1 } 
  box { <0.02, -.2, -1.1>, <0.02, .2, -.7> } 
  box { <0.02, -.2, .7>, <0.02, .2, 1.1> } 
}

object {
  #include "tthilbrt.inc"
  translate <-8.75, 18.1, -8.75>
  rotate <0, 15, 0>
}

// Table
difference {
  union {
    union {
      cone { <0, -.25, 12>, 25, <0, 0, 12>, 24.75 }
      cylinder { <0, -.5, 12>, <0, -.25 12>, 25 }
//PinkAlabaster from POVRAY 2.2 textures but added reflection
      texture { 
        pigment {
          bozo
          turbulence 0.25
          color_map { 
            [0,  1 color red 0.9 green 0.75 blue 0.75
                   color red 0.6 green 0.6  blue 0.6 ]
          }
          scale 0.4
        }
        finish {
          ambient 0.25
        }
      }
      texture {
        pigment {
          granite
          color_map {
            [0,   0.9 color DustyRose filter 1 color DustyRose filter 0.5]
            [0.9, 1   color DarkSlateGray     color DarkSlateGray]
          }
          scale 2       // Twice as large as unit shape
        }
        finish {
          specular 1   
          roughness 0.0001
          phong 0.25     
          phong_size 75
          brilliance 4
          reflection .1
        }
      }
    }
    union {
      cone { <0, -.675, 12>, 25.25, <0, -.55, 12>, 25.125 }
      cylinder { <0, -1.1, 12>, <0, -.675, 12>, 25.25 }
      cylinder { <0, -2.4, 12>, <0, -1.1, 12>, 24.75 }
      cone { <0, -2.5, 12>, 24.65, <0, -2.4, 12>, 24.75 }
      cone { <0, -2.6, 12>, 24.75, <0, -2.5, 12>, 24.65 }
      cylinder { <0, -2.9, 12>, <0, -2.6, 12>, 24.75 }
      cone { <0, -3, 12>, 24.65, <0, -2.9, 12>, 24.75 }
      cylinder { <0, -30, 12>, <0, -1.1, 12>, 4 }
      texture { 
        pigment {
          wood
          turbulence 0.2
          color_map { 
            [0.0, 0.8  color red 0.666 green 0.312 blue 0.2
                       color red 0.666 green 0.312 blue 0.2]
            [0.8, 1.01 color red 0.6 green 0.266 blue 0.133
                       color red 0.4 green 0.133 blue 0.066]
          }
        }
        finish { ambient .5 }
        rotate<0, 90, 0>
        scale <.5, .5, .5>
      }
    }
  }
  box { <-100, -100, 12>, <100, 100, 100> }
}

//Wall
box { <-45, -100, 13.5>, 
      <100, 100, 19.5>
  texture {
    pigment { MediumBlue }
    finish { ambient .5 }
    scale <4, 4, 1>
  }
}

//Wood trim
difference {
  box { <-45, -30, 13>, <100, -28, 15> }
  cylinder { <-45, -30, 13>, <100, -30, 13>, .25 }
  texture { 
    pigment {
      wood
      turbulence 0.2
      color_map { 
        [0.0, 0.8  color red 0.666 green 0.312 blue 0.2
                   color red 0.666 green 0.312 blue 0.2]
        [0.8, 1.01 color red 0.6 green 0.266 blue 0.133
                   color red 0.4 green 0.133 blue 0.066]
      }
    }
    finish { ambient .5 }
    rotate<0, 90, 0>
    scale <.5, .5, .5>
  }
}

//Floor
box { <-1000, -100, -1000>, 
      <1000, -30, 1000>
      pigment { Tan }
      finish { ambient .5 }
}

//Loose spools
union {  
  object { spool
    rotate <90, 0, 0>
    translate <13, .3, 2>
  }
  object { spool
    rotate <90, 0, 0>
    translate <16, .3, 0>
  }
  object { spool
    rotate <90, 0, 0>
    translate <17, .3, 5>
  }
  texture { 
    pigment { 
      wood
      turbulence 0.4
      color_map 
       {[0.0, 0.85  color red 0.93 green 0.71 blue 0.532
                    color red 0.98 green 0.81 blue 0.6]
        [0.85, 1.01 color red 0.91 green 0.67 blue 0.47
                    color red 0.91 green 0.67 blue 0.47]
       }
    }
    finish { ambient .5 }
  }
}

//Loose sticks
object { stick
  rotate <0, 0, -80>
  rotate <0, 45, 0>
  translate <13, .3, -4>
  texture {
    pigment { ForestGreen } 
    finish { ambient .5 }
  }
}

object { stick
  rotate <0, 0, -45>
  rotate <0, 80, 0>
  translate <15, .3, -4.5>
  texture {
    pigment { Red } 
    finish { ambient .5 }
  }
}

object { stick
  rotate <0, 0, -50>
  rotate <0, -25, 0>
  translate <18, .3, 2>
  texture {
    pigment { Orange } 
    finish { ambient .5 }
  }
}

object { stick
  rotate <0, 0, -10>
  rotate <0, -35, 0>
  translate <16, .3, 2>
  texture {
    pigment { Yellow } 
    finish { ambient .5 }
  }
}

//Glasses
object { glasses
  scale <3, 3, 3>
  rotate <177.5, 35, 0>
  translate <20, 1, 6>
}

//Picture
union {
  box { <0, 0, -.5>, 
        <1, 1, 0>
    texture {
      pigment {
        image_map {
          gif "man_640.gif"
          interpolate 2
        }
      }
      finish { ambient .5 }
    }
    scale <24, 18, 1>
  }
  union {
    box { <-.2, -.2, -.6>, <.2, 18.2, 0> }
    box { <-.2, -.2, -.6>, <24.2, .2, 0> }
    box { <23.8, -.2, -.6>, <24.2, 18.2, 0> }
    box { <-.2, 17.8, -.6>, <24.2, 18.2, 0> }
    texture { Chrome_Metal }
  }
  rotate <-1.5, 0, 0>
  translate <0, 6, 13.5>
}

