#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

camera {
  location <50, -120,-200>
  look_at <0,-150,0>
}

light_source {<0,200,0> color White}
light_source {<0,200,450> color White}

#declare Silver_Cup =
difference {
 difference {
  object {sphere {<0,0,0>, 1 }}
  object {box {<-1,0,-1>,<1,1,1>}}
}
 object {sphere {<0,0,0>, .8}}
 texture {Chrome_Texture pigment {color Silver}}
 finish {specular .4 ambient 0 reflection .8}
 rotate <0,0,0>
}
#declare Arm =
difference {
  object {torus {10,1}}
  object {box {<0,-4,-14>,<12,4,14>}}
  object {box {<-12,-2,0>,<0,2,12>}}
}

#declare Balance =
union {
  object {Arm scale <2,2,6> rotate <180,0,90>}
  object {Arm scale <2,2,6> rotate <90,0,90>}
  object {Arm scale <2,2,6> rotate <0,0,90>}
  object {Arm scale <2,2,6> rotate <-90,0,90>}
  object {Silver_Cup scale <16,6,6> translate <-60,5,0>}
  object {Silver_Cup scale <16,6,6> translate <60,5,0>}
  object {Silver_Cup scale <16,6,6> translate <0,5,60>}
  object {Silver_Cup scale <16,6,6> translate <0,5,-60>}
}

#declare Pin_Balance =
union {
  object {Arm scale <2,2,6> rotate <180,0,90>}
  object {Arm scale <2,2,6> rotate <90,0,90>}
  object {Arm scale <2,2,6> rotate <0,0,90>}
  object {Arm scale <2,2,6> rotate <-90,0,90>}
  object {cone {<60,0,0>,1,<60,20,0>,0 texture {Chrome_Texture pigment {color Gold}} finish {Shiny}}}
  object {cone {<-60,0,0>,1,<-60,20,0>,0 texture {Chrome_Texture pigment {color Gold}} finish {Shiny}}}
  object {cone {<0,0,60>,1,<0,20,60>,0 texture {Chrome_Texture pigment {color Gold}} finish {Shiny}}}
  object {cone {<0,0,-60>,1,<0,20,-60>,0 texture {Chrome_Texture pigment {color Gold}} finish {Shiny}}}
}
#declare My_Mirror =
union {
  object {torus {2,.1 pigment {color Silver} finish {Phong_Shiny}} scale <1,.2,1>}
  object {disc {<0,0,0>, y, 2 pigment {color Silver} finish {Mirror}}}
}
#declare Foo =
union {
  object {Pin_Balance}
  object {Balance rotate <0,35,0> scale <.5,.5,.5> translate <60,28,0> }
  object {Balance rotate <0,75,0> scale <.5,.5,.5> translate <-60,28,0>}
  object {Balance rotate <0,45,0>  scale <.5,.5,.5> translate <0,28,60>}
  object {Balance  scale <.5,.5,.5> translate <0,28,-60>}
  rotate <0,45,0>
}
#declare All =
union {
  object {Pin_Balance}
  object {Foo rotate <0,35,0> scale <.5,.5,.5> translate <60,24,0> }
  object {Foo rotate <0,75,0> scale <.5,.5,.5> translate <-60,24,0>}
  object {Foo rotate <0,45,0>  scale <.5,.5,.5> translate <0,24,60>}
  object {Foo scale <.5,.5,.5> translate <0,24,-60>}
  rotate <0,45,0>
}

#declare Ball =
union {
  sphere {<0,0,0>, 10 pigment {color White} finish {Shiny}}
  intersection {
    sphere {<0,0,0>, 10.00001}
    union {
      cylinder {<0,2,0>, <0,4,0>, 12 }
      cylinder {<0,-2,0>, <0,-4,0>, 12}
    }
    pigment {color Red}
  }
  intersection {
    sphere {<0,0,0>, 10.00001}
    cylinder {<0,1.5,0>, <0,-1.5,0>, 12 }
    pigment {color Yellow}
  }
  finish {Shiny}
}
#declare Thingy =
union {
  object {Ball rotate <0,0,40> translate <0,-185,0>}
  object {cone {<0,-130,0>,5,<0,-195,0>,0 texture {Chrome_Texture pigment {color Gold} finish {ambient .2 diffuse .6 reflection .5}}}}
  object {Foo scale <1.5,1.5,1.5> translate <0,-100,0>}
} 
object {Thingy translate <0,0,100> pigment {Pine_Wood scale <5,5,5>}}
plane {y,-195 pigment {checker color Silver color OldGold scale <100,100,100>} finish {diffuse .23 reflection 1 ambient 0}}
plane {x,145 pigment {White_Marble scale <25,25,25>} finish {Phong_Glossy}}
plane {x,-145 pigment {White_Marble scale <25,25,25>} finish {Phong_Glossy}}
plane {-y,-200 pigment {Bright_Blue_Sky scale <150,150,150>} finish {Luminous}}


