//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 3 lights, 7 textures and 27 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/16/1995    (16.07.1995)
//

//
//  This is MORAY's default standard include file for POV.
//  called MRYDEFLT.INC
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
camera {  //  Camera Camera01
  location  <6.940, -55.400, 15.000>
  direction <0.0,     0.0,  1.0465>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -20.800, 8.000>
}

// *******  L I G H T S *******
light_source { // AreaL001
  <-37.881, -49.303, 15.665>
  color  rgb<0.714, 0.714, 0.714>
  area_light <0.000, -1.000, 0.000>, <1.000, 0.000, 0.000>, 3, 3
  adaptive 5
  jitter
}

light_source { // AreaL2
  <4.536, -50.125, 30.535>
  color  rgb<0.682, 0.682, 0.682>
  area_light <0.000, -1.000, 0.000>, <1.000, 0.000, 0.000>, 3, 3
  adaptive 5
  jitter
}

light_source { // AreaL3
  <39.360, -50.946, 15.665>
  color  rgb<0.647, 0.647, 0.647>
  area_light <0.000, -1.000, 0.000>, <1.000, 0.000, 0.000>, 3, 3
  adaptive 5
  jitter
}


//
// ********  T E X T U R E S  *******
//

#include "ROOM.INC"

// ********  O B J E C T S *******
#declare floor3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Brick_txt
    scale <0.150000, 0.150000, 0.150000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-1.099483, -1.000000, 0.422802>
  }
  scale <50.000000, 2.000000, 49.999996>
  rotate <-180.000000, 0.000000, -90.000000>
  translate <47.277828, -13.858194, 47.244446>
}

#declare floor2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Brick_txt
    scale <0.150000, 0.150000, 0.150000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-1.099483, -1.000000, 0.422802>
  }
  scale <50.000000, 2.000000, 49.999996>
  rotate <-180.000000, 0.000000, -90.000000>
  translate <-47.317497, -15.298732, 47.244446>
}

#declare floor1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Brick_txt
    scale <0.150000, 0.150000, 0.150000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-1.099483, -1.000000, 0.422802>
  }
  scale <50.000000, 2.000000, 49.999996>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <-1.174495, 34.039470, 47.244446>
}

#declare floor4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Brick_txt
    scale <0.150000, 0.150000, 0.150000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-1.099483, -1.000000, 0.422802>
  }
  scale <50.000000, 2.000000, 49.999996>
  rotate <-180.000000, 0.000000, 0.000000>
  translate <1.229972, -62.902268, 46.867120>
}

union {
  object { floor3 }
  object { floor2 }
  object { floor1 }
  object { floor4 }
}

box {   // floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Floor_txt
    scale <0.150000, 0.150000, 0.150000>
    rotate <-90.000000, 0.000000, 0.000000>
    translate <-0.907063, -1.000000, 1.022305>
  }
  scale <50.000000, 1.000000, 50.000000>
  rotate <-270.000000, 0.000000, 0.000000>
  translate <0.666237, -10.714104, -0.836431>
}

#declare step = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <17.168704, 25.283627, 1.456611>
}

#declare step1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <18.168704, 25.283627, 2.456611>
}

#declare step2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <19.168704, 25.283627, 3.456611>
}

#declare step3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <20.168704, 25.283627, 4.456611>
}

#declare step4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <21.168704, 25.283627, 5.456611>
}

#declare step5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <22.168704, 25.283627, 6.456611>
}

#declare step6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <23.168704, 25.283627, 7.456611>
}

#declare step7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <24.168704, 25.283627, 8.456611>
}

#declare step8 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <25.168704, 25.283627, 9.456611>
}

#declare step9 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <26.168704, 25.283627, 10.456611>
}

#declare step10 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <28.710842, 6.461265, 1.000000>
  translate <27.168704, 25.283627, 11.456611>
}

union {   // steps
  object { step }
  object { step1 }
  object { step2 }
  object { step3 }
  object { step4 }
  object { step5 }
  object { step6 }
  object { step7 }
  object { step8 }
  object { step9 }
  object { step10 }
  texture {
    Stone9
    finish {
      brilliance   0.00
      phong   0.00
      phong_size   0.00
    }
  }
  translate <14.995729, 0.000000, 0.000000>
}
#declare rail = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 7.500000>
  translate <3.772925, 19.624871, 1.380307>
}

#declare rail1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 7.500000>
  translate <14.846192, 19.624871, 12.331231>
}

#declare rail2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 7.500000>
  translate <26.063375, 19.408822, 12.418624>
}

#declare rail3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 7.500000>
  translate <37.229268, 19.624871, 12.418624>
}

#declare rail4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 31.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <45.195063, 19.624871, 20.043028>
}

#declare rail5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.300000, 0.300000, 20.000000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <0.288442, 19.624871, 5.966854>
}

union {
  object { rail }
  object { rail1 }
  object { rail2 }
  object { rail3 }
  object { rail4 }
  object { rail5 }
}

#declare door_frame1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFLightOak
  }
  scale <8.200000, 1.000000, 17.000000>
  translate <35.021701, 31.640755, 30.846727>
}

#declare door_frame = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFLightOak
  }
  scale <7.300000, 1.200000, 16.000000>
  translate <35.021701, 31.640755, 30.846727>
}

#declare frame = difference {
  object { door_frame1 }
  object { door_frame }
  translate <0.000000, 0.000000, -1.297455>
}

#declare door_frame2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Rosewood
    scale <0.100000, 0.100000, 0.100000>
    translate <0.000000, 5.282558, -1.131977>
  }
  scale <7.300000, 0.800000, 16.000000>
  translate <35.021701, 31.640755, 29.549271>
}

#declare knob = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    matte_grey
  }
  scale <0.250000, 0.250000, 1.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <30.302277, 29.880929, 29.482156>
}

#declare knob1 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_grey
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <30.273960, 29.366081, 29.546107>
}

#declare handle = union {
  object { knob }
  object { knob1 }
  translate <-1.081213, 0.000000, -5.406064>
}

union {   // entry
  object { frame }
  object { door_frame2 }
  object { handle }
}

//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 0 lights, 16 textures and 70 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/16/1995    (16.07.1995)
//


//
// ********  T E X T U R E S  *******
//

#include "MAIN.INC"

// ********  O B J E C T S *******
#declare Bound00001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.721118, 3.304995, 3.221118>
  translate <1.693713, -17.571675, 6.424249>
}

#declare Sphere001 = object { 
  sphere {<0,0,0>,1}
}

#declare Sphere002 = object { 
  sphere {<0,0,0>,1}
  translate <0.000000, 0.000000, 5.000000>
}

#declare Cylndr001 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <1.000000, 1.000000, 5.000000>
}

#declare Transfer_tube = union {
  object { Sphere001 }
  object { Sphere002 }
  object { Cylndr001 }
  texture {
    Stone2
  }
  scale <3.000000, 3.000000, 3.000000>
  rotate <0.000000, 90.000000, 0.000000>
  translate <-5.806287, -17.487799, 6.424249>
}

#declare Cylndr002 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_black
  }
  scale <2.400000, 2.400000, 2.400000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.638381, -20.655551, 6.405671>
}

difference {
  object { Transfer_tube }
  object { Cylndr002 }
  bounded_by { Bound00001 }
  translate <-0.044806, 0.000000, 0.000000>
}

#declare Bound00002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.645333, 0.245333, 1.645333>
  translate <1.624195, -19.736203, 6.362881>
}

#declare Torus001 = torus { 
  1.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Stone12
  }
  scale <0.800000, 0.800000, 0.800000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.624195, -19.736203, 6.362881>
}

#declare Sphere003 = object { 
  sphere {<0,0,0>,1}
  texture {
    Stone1
  }
  scale <1.200000, 0.150000, 1.200000>
  translate <1.637385, -19.752972, 6.386962>
}

#declare Nut_a = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut = intersection {
  object { Nut_a }
  object { Nut_a1 }
  translate <0.114964, -0.170000, 1.065714>
}

#declare Nut_a2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut1 = intersection {
  object { Nut_a2 }
  object { Nut_a3 }
  translate <-0.692836, -0.170000, 0.221494>
}

#declare Nut_a4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut2 = intersection {
  object { Nut_a4 }
  object { Nut_a5 }
  translate <0.921554, -0.170000, 0.213583>
}

#declare Nut_a6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut3 = intersection {
  object { Nut_a6 }
  object { Nut_a7 }
  translate <0.107025, -0.170000, -0.624928>
}

#declare Nut_a8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut4 = intersection {
  object { Nut_a8 }
  object { Nut_a9 }
  rotate <0.000000, -17.878336, 0.000000>
  translate <1.405462, -0.170000, -0.499066>
}

#declare Nut_a10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut5 = intersection {
  object { Nut_a10 }
  object { Nut_a11 }
  rotate <0.000000, -21.672380, 0.000000>
  translate <1.799868, -0.170000, 0.609107>
}

#declare Nut_a12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut6 = intersection {
  object { Nut_a12 }
  object { Nut_a13 }
  rotate <0.000000, -21.672380, 0.000000>
  translate <3.200024, -0.170000, -0.458808>
}

#declare Nut_a14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare Nut_a15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Polished_Chrome2
  }
  scale <0.100000, 0.050000, 0.100000>
  rotate <0.000000, -45.000000, 0.000000>
  translate <1.521806, -19.657701, 6.165797>
}

#declare lugnut7 = intersection {
  object { Nut_a14 }
  object { Nut_a15 }
  rotate <0.000000, -17.878336, 0.000000>
  translate <2.797239, -0.170000, 0.545118>
}

#declare GrpObj002 = union {
  object { lugnut }
  object { lugnut1 }
  object { lugnut2 }
  object { lugnut3 }
  object { lugnut4 }
  object { lugnut5 }
  object { lugnut6 }
  object { lugnut7 }
}
union {   // hatch
  object { Torus001 }
  object { Sphere003 }
  object { GrpObj002 }
  bounded_by { Bound00002 }
  scale <1.500000, 1.000000, 1.500000>
  translate <-0.792519, 0.000000, -3.138375>
}
#declare Bound00005 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <5.337003, 0.668348, 3.218722>
  translate <2.161251, -17.386373, 12.202084>
}

#declare post = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_white
  }
  scale <0.250000, 0.250000, 6.200930>
  translate <-2.807495, -17.444959, 9.101619>
}

#declare post1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_white
  }
  scale <0.250000, 0.250000, 6.200930>
  translate <7.129996, -17.488930, 9.101619>
}

#declare sign = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Maintxt
    scale <2.000000, 2.000000, 1.000000>
    rotate <-270.000000, 0.000000, 0.000000>
    translate <-1.001402, -1.000000, -0.983400>
  }
  scale <4.726568, 0.550090, 1.552328>
  translate <2.206970, -17.386373, 13.636753>
}

union {   // signage
  object { post }
  object { post1 }
  object { sign }
  bounded_by { Bound00005 }
  scale <0.900000, 1.000000, 1.000000>
  translate <-2.800000, 0.000000, 0.000000>
}
#declare Bound00003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.139943, 3.714525, 2.128459>
  translate <-2.252832, -17.542391, 2.245307>
}

#declare left_stand = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone22
  }
  scale <1.050419, 3.466963, 2.038934>
  translate <-2.252832, -17.621171, 2.245307>
}

#declare standcit1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.600000, 0.600000, 7.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.169117, -21.167391, 2.909017>
}

#declare standcit2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.600000, 0.600000, 7.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.169117, -21.167391, 1.177459>
}

difference {
  object { left_stand }
  object { standcit1 }
  object { standcit2 }
  texture {
    Stone22
  }
  bounded_by { Bound00003 }
  translate <-1.300231, 0.000000, 0.056532>
}

#declare Bound00004 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.139943, 3.714525, 2.128459>
  translate <-2.252832, -17.542391, 2.245307>
}

#declare left_stand1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone22
  }
  scale <1.050419, 3.466963, 2.038934>
  translate <-2.252832, -17.621171, 2.245307>
}

#declare standcit3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.600000, 0.600000, 7.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.169117, -21.167391, 2.909017>
}

#declare standcit4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.600000, 0.600000, 7.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-2.169117, -21.167391, 1.177459>
}

difference {
  object { left_stand1 }
  object { standcit3 }
  object { standcit4 }
  texture {
    Stone22
  }
  bounded_by { Bound00004 }
  translate <9.288447, 0.000000, 0.113274>
}

#declare Bound00006 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.051176, 3.400673, 3.400673>
  translate <11.214643, -17.482000, 6.400371>
}

#declare spitroll1 = torus { 
  0.950, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Stone2
  }
  scale <2.000000, 2.000000, 1.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <10.974501, -17.482000, 6.400371>
}

#declare spitroll = torus { 
  1.550, 0.450  // Major, minor radius
  rotate -x*90
  texture {
    Stone2
  }
  scale <1.000000, 1.000000, 0.500000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <10.489141, -17.482087, 6.400371>
}

#declare spitroll2 = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    Stone2
  }
  scale <3.000000, 3.000000, 1.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <11.482860, -17.481829, 6.400371>
}

#declare spitroll3 = torus { 
  0.400, 0.200  // Major, minor radius
  rotate -x*90
  texture {
    Stone2
  }
  scale <5.500000, 5.500000, 1.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <11.965146, -17.482000, 6.400371>
}

union {
  object { spitroll1 }
  object { spitroll }
  object { spitroll2 }
  object { spitroll3 }
  bounded_by { Bound00006 }
  translate <1.000000, 0.000000, 0.000000>
}

#declare Bound00007 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <8.137470, 1.896982, 8.679183>
  translate <-0.003209, 0.842937, 5.208836>
}

#declare power = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    powtxt
    scale <2.000000, 2.000000, 1.000000>
    rotate <90.000000, 0.000000, 0.000000>
    translate <-0.992322, 0.394052, -1.010307>
  }
  scale <4.000000, 0.500000, 4.000000>
  translate <0.000000, 0.185874, 3.159851>
}

#declare powcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_grey
  }
  scale <2.000000, 1.000000, 5.000000>
  rotate <0.000000, -20.000000, 0.000000>
  translate <-4.311275, 0.185874, 2.181689>
}

#declare powcut1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_grey
  }
  scale <2.000000, 1.000000, 5.000000>
  rotate <0.000000, 20.000000, 0.000000>
  translate <4.304857, 0.185874, 2.152075>
}

#declare CSGObj001 = difference {
  object { power }
  object { powcut }
  object { powcut1 }
}

#declare pin = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    steely_blue
  }
  scale <0.500000, 0.500000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.000000, -0.500000, 0.000000>
}

#declare arm = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    steely_blue
  }
  scale <0.500000, 0.500000, 14.000000>
  translate <0.000000, 1.500000, 0.000000>
}

#declare top = object { 
  sphere {<0,0,0>,1}
  texture {
    steely_blue
  }
  scale <0.500000, 0.500000, 0.500000>
  translate <0.000000, 1.511665, 14.000000>
}

#declare rib = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    reflective_blue
  }
  translate <0.000000, 1.500000, 13.500000>
}

#declare rib1 = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    reflective_blue
  }
  translate <0.000000, 1.500000, 13.000000>
}

#declare rib2 = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    reflective_blue
  }
  translate <0.000000, 1.500000, 12.500000>
}

#declare rib3 = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    reflective_blue
  }
  translate <0.000000, 1.500000, 12.000000>
}

#declare lever = torus { 
  0.750, 0.250  // Major, minor radius
  rotate -x*90
  texture {
    reflective_blue
  }
  rotate <-90.000000, -90.000000, 0.000000>
  translate <0.725327, 1.500000, 11.043185>
}

#declare levcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_grey
  }
  scale <0.500000, 0.500000, 1.300000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <0.271583, 1.500000, 11.435783>
}

#declare levcut1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_grey
  }
  scale <0.500000, 0.500000, 1.300000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <0.759947, 1.500000, 11.540639>
}

#declare blever = difference {
  object { lever }
  object { levcut }
  object { levcut1 }
}

#declare pull = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    reflective_blue
  }
  scale <0.250000, 0.250000, 3.000000>
  translate <1.468615, 1.500000, 11.040066>
}

#declare pull1 = union {
  object { blever }
  object { pull }
  rotate <0.000000, 10.774739, 0.000000>
  translate <-1.892936, 0.000000, 0.482892>
}

#declare puller = union {
  object { pin }
  object { arm }
  object { top }
  object { rib }
  object { rib1 }
  object { rib2 }
  object { rib3 }
  object { pull1 }
  rotate <0.000000, 20.000000, 0.000000>
}

union {   // full_speed
  object { CSGObj001 }
  object { puller }
  bounded_by { Bound00007 }
  scale <0.250000, 0.250000, 0.250000>
  translate <6.383437, -21.308546, 5.281761>
}
object {   // bubble
  sphere {<0,0,0>,1}
  texture {
    bubble
  }
  scale <3.300000, 3.300000, 3.300000>
  translate <14.704662, -17.482000, 6.409020>
}

#declare pump_bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.072986, 1.072986, 2.546903>
  translate <1.250000, 0.000000, 1.882984>
}

#declare Left_tube = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    glass
  }
  scale <0.500000, 0.500000, 2.000000>
}

#declare Comp_base = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Red_Marble
    scale <0.500000, 0.500000, 0.500000>
  }
  scale <2.000000, 1.000000, 0.300000>
  translate <1.250000, 0.000000, -0.290933>
}

#declare Right_tube = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    glass
  }
  scale <0.500000, 0.500000, 2.000000>
  translate <2.500000, 0.000000, 0.000000>
}

#declare Piston = torus { 
  0.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    matte_grey
  }
  scale <0.500000, 0.500000, 0.300000>
  translate <0.000000, 0.000000, 1.500000>
}

#declare Piston1 = torus { 
  0.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    matte_grey
  }
  scale <0.500000, 0.500000, 0.300000>
  translate <2.500000, 0.000000, 0.500000>
}

#declare top1 = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    glass
  }
  scale <0.500000, 0.500000, 1.000000>
  translate <0.000000, 0.000000, 2.000000>
}

#declare top2 = disc { 
  <0.0, 0.0, 0.0>,
  <0.0, 0.0, 1.0>,
  1.0000
  texture {
    glass
  }
  scale <0.500000, 0.500000, 1.000000>
  translate <2.500000, 0.000000, 2.000000>
}

#declare rod = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 3.500000>
  translate <1.250000, 0.000000, 0.000000>
}

#declare rod1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 2.500000>
  translate <0.000000, 0.000000, 1.400000>
}

#declare rod2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 2.500000>
  translate <2.500000, 0.000000, 0.400000>
}

#declare crossbar = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Red_Marble
    scale <0.500000, 0.500000, 0.500000>
  }
  scale <1.600000, 0.100000, 0.300000>
  rotate <0.000000, 22.000000, 0.000000>
  translate <1.300000, 0.000000, 3.350000>
}

#declare crosscut = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.400000, 0.200000, 0.300000>
  rotate <-90.000000, -70.000000, 0.000000>
  translate <2.849659, -0.150000, 2.723735>
}

#declare crosscut1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.400000, 0.200000, 0.300000>
  rotate <-90.000000, -70.000000, 0.000000>
  translate <-0.244193, -0.150000, 3.981024>
}

#declare crosscut2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <1.000000, 0.200000, 0.300000>
  rotate <-90.000000, 22.000000, 0.000000>
  translate <0.852992, -0.150000, 3.844997>
}

#declare crosscut3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <1.000000, 0.200000, 0.300000>
  rotate <-90.000000, 22.000000, 0.000000>
  translate <1.959435, -0.150000, 3.399948>
}

#declare crosscut4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.500000, 0.200000, 0.300000>
  rotate <-90.000000, 22.000000, 0.000000>
  translate <1.900000, -0.150000, 2.800367>
}

#declare crosscut5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.500000, 0.200000, 0.300000>
  rotate <-90.000000, 22.000000, 0.000000>
  translate <0.626664, -0.150000, 3.301048>
}

#declare cross = difference {
  object { crossbar }
  object { crosscut }
  object { crosscut1 }
  object { crosscut2 }
  object { crosscut3 }
  object { crosscut4 }
  object { crosscut5 }
}

#declare pin1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.250000, -0.120000, 3.300000>
}

#declare pin2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <2.500000, -0.120000, 2.750000>
}

#declare pin3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_yellow
  }
  scale <0.100000, 0.100000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.000000, -0.120000, 3.750000>
}

union {   // compressor
  object { Left_tube }
  object { Comp_base }
  object { Right_tube }
  object { Piston }
  object { Piston1 }
  object { top1 }
  object { top2 }
  object { rod }
  object { rod1 }
  object { rod2 }
  object { cross }
  object { pin1 }
  object { pin2 }
  object { pin3 }
  bounded_by { pump_bound }
  translate <5.800000, -17.425506, 10.000000>
}
//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 5 lights, 2 textures and 75 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/16/1995    (16.07.1995)
//

// *******  L I G H T S *******
#declare lightbulb = light_source {
  <0.000, 0.010, -0.657>
  color rgb <0.2, 0.2, 0.2>
}


//
// ********  T E X T U R E S  *******
//

#include "LAMPS.INC"

// ********  O B J E C T S *******
declare lamp_bound = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.268763, 2.677995, 1.416775>
  translate <0.000000, -1.409232, -0.127435>
}

#declare shade = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  rotate <-180.000000, 0.000000, 0.000000>
}

#declare shade1 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.800000, 0.800000, 1.100000>
  rotate <-180.000000, 0.000000, 0.000000>
}

#declare shade_cut = difference {
  object { shade }
  object { shade1 }
}

#declare Shade_top = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_red
  }
  scale <0.200000, 0.200000, 0.200000>
}

#declare shade_rim = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_red
  }
  translate <0.000000, 0.000000, -0.987355>
}

#declare Wall_pipe = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_red
  }
  scale <0.700000, 0.700000, 0.700000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <0.000000, -0.751300, 0.009203>
}

#declare pipe_cut = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 0.735840, 0.440233>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <0.000000, -1.169319, -0.203301>
}

#declare pipe_cut1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 0.735840, 0.440233>
  translate <0.000000, -0.546019, -0.453336>
}

#declare upper_pipe = difference {
  object { Wall_pipe }
  object { pipe_cut }
  object { pipe_cut1 }
  translate <0.000000, 0.015590, 0.004872>
}

#declare Wall_pipe1 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_red
  }
  scale <0.700000, 0.700000, 0.700000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <0.000000, -0.751300, 0.009203>
}

#declare pipe_cut2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 0.735840, 0.440233>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <0.000000, -0.284875, 0.179403>
}

#declare pipe_cut3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 0.735840, 0.440233>
  translate <0.000000, -1.016515, 0.475893>
}

#declare upper_pipe1 = difference {
  object { Wall_pipe1 }
  object { pipe_cut2 }
  object { pipe_cut3 }
  translate <0.000000, -2.177576, -0.018311>
}

#declare Shade_top1 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_red
  }
  scale <0.200000, 0.200000, 0.200000>
  translate <0.000000, -3.655899, 0.020539>
}

#declare pipe_joiner = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_red
  }
  scale <0.070000, 0.070000, 1.570444>
  rotate <-45.000000, 0.000000, 0.000000>
  translate <0.000000, -2.387224, -0.552611>
}

#declare wall_plate = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_red
  }
  scale <1.000000, 0.150000, 1.061731>
}

#declare shade_rim1 = torus { 
  1.100, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_red
  }
  rotate <-90.000000, 0.000000, 0.000000>
}

#declare Plate = union {
  object { wall_plate }
  object { shade_rim1 }
  translate <0.000000, -3.868464, 0.020577>
}

#declare bulb = object { 
  sphere {<0,0,0>,1}
  texture {
    waxed_white
  }
  no_shadow
  scale <0.500000, 0.500000, 0.500000>
  translate <0.025336, 0.000000, -0.975447>
}

#declare Wall_lamp = union { //Wall_lamp
  object { shade_cut }
  object { Shade_top }
  object { shade_rim }
  object { upper_pipe }
  object { upper_pipe1 }
  object { Shade_top1 }
  object { lightbulb }
  object { pipe_joiner }
  object { Plate }
  object { bulb }
  texture {
    shiny_red
  }
  bounded_by { lamp_bound }
  scale <2.000000, 2.000000, 2.000000>
  rotate <0.0, 0.0, 0.0>
  translate <0., 0.0, 0.0>
}
object { Wall_lamp
  rotate <0.000000, 0.000000, -180.000000>
  translate <0.000000, 24.239112, 26.035731>
}
object { Wall_lamp
  rotate <0.000000, 0.000000, -90.000000>
  translate <-37.493959, -3.500000, 26.035731>
}
object { Wall_lamp
  rotate <0.000000, 0.000000, -90.000000>
  translate <-37.493959, 13.500000, 26.035731>
}
object { Wall_lamp
  rotate <0.000000, 0.000000, -180.000000>
  translate <-34.000000, 24.239112, 26.035731>
}
object { Wall_lamp
  rotate <0.000000, 0.000000, -180.000000>
  translate <-17.000000, 24.239112, 26.035731>
}

//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 0 lights, 7 textures and 148 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/16/1995    (16.07.1995)
//

//
// ********  T E X T U R E S  *******
//

#include "JAW.INC"

// ********  O B J E C T S *******
#declare Bind_whole = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <7.215488, 2.620832, 4.157108>
  translate <3.034004, -1.302283, -1.130036>
}

#declare Jaw1 = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    shiny_plum
  }
  scale <2.137557, 1.000000, 1.000000>
}

#declare Cube5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.520740, 2.394052, 0.864141>
  translate <2.899674, -0.000517, 0.000000>
}

#declare Cube6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <2.930503, 2.393879, 0.179821>
  translate <-1.464141, -0.046382, 0.486032>
}

#declare jaw1 = difference {
  object { Jaw1 }
  object { Cube5 }
  object { Cube6 }
  texture {
    shiny_plum
  }
  rotate <0.000000, -165.000000, -180.000000>
  translate <0.185874, -1.301115, -2.602230>
}

#declare Bind_arm = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <5.256509, 1.861454, 1.575466>
  translate <4.840994, -1.007285, 1.283544>
}

#declare upper_crossb1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.400000, 0.400000, 3.500000>
  rotate <0.000000, -90.000000, -90.000000>
  translate <0.095939, -2.757285, 0.219532>
}

#declare piston_Brack1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Grnt16
  }
  scale <2.000000, 0.200000, 1.000000>
  translate <7.981031, -1.131691, 1.008036>
}

#declare Upper_Pushro1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.200000, 0.200000, 8.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <9.986049, -1.150836, 2.247556>
}

#declare upper_Piston1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.500000, 0.500000, 4.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <9.986049, -1.150836, 2.247556>
}

#declare linkage1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.200000, 0.200000, 3.000000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <0.043606, -1.150836, 0.140811>
}

#declare lower_arm = union {
  object { upper_crossb1 }
  object { piston_Brack1 }
  object { Upper_Pushro1 }
  object { upper_Piston1 }
  object { linkage1 }
  bounded_by { Bind_arm }
  rotate <-180.000000, 0.000000, 0.000000>
  translate <0.084040, -2.292742, -2.360186>
}

#declare bind_upper = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <7.161514, 2.572690, 2.417551>
  translate <2.980327, -1.045668, 0.485796>
}

#declare Jaw = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    shiny_plum
  }
  scale <2.137557, 1.000000, 1.000000>
}

#declare Cube3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.520740, 2.394052, 0.864141>
  translate <2.899674, -0.000517, 0.000000>
}

#declare Cube4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <2.930503, 2.393879, 0.179821>
  translate <-1.464141, -0.046382, 0.486032>
}

#declare Upper_jaw = difference {
  object { Jaw }
  object { Cube3 }
  object { Cube4 }
  texture {
    shiny_plum
  }
  rotate <0.000000, 15.000000, 0.000000>
  translate <0.140252, -1.022305, 0.202820>
}

#declare Bind_teeth = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.974491, 1.921651, 0.969403>
  translate <-0.597855, -1.299052, -2.281420>
}

#declare tooth40 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_white
  }
  scale <1.000000, 1.050997, 0.490030>
  translate <0.464684, 5.736583, 0.560967>
}

#declare tooth41 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.057472, 6.144809, 1.060262>
}

#declare tooth42 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.854437, 6.150228, 1.060262>
}

#declare tooth43 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.056589, 5.373052, 1.060262>
}

#declare tooth44 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.858973, 5.378471, 1.060262>
}

#declare CSGObj9 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -12.774026>
  translate <0.202812, -1.967415, -2.464432>
}


#declare CSGObj10 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 5.729893>
  translate <0.020113, -2.010863, -2.707448>
}

#declare CSGObj11 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 11.336296>
  translate <-0.652535, -2.157201, -2.920087>
}

#declare CSGObj12 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -25.000000>
  translate <-2.921334, -4.113229, -3.178292>
}

#declare CSGObj13 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -12.774026>
  translate <-1.562054, -4.620045, -2.950464>
}

#declare CSGObj14 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 10.500000>
  translate <1.126323, -4.762668, -2.418867>
}

#declare CSGObj15 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -3.709044>
  translate <-0.368949, -4.855210, -2.707448>
}

#declare CSGObj16 = union {
  object { tooth40 }
  object { tooth41 }
  object { tooth42 }
  object { tooth43 }
  object { tooth44 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 29.641829>
  translate <-0.917955, -2.240508, -3.178292>
}

#declare upper_teeth = union {
  object { CSGObj9 }
  object { CSGObj10 }
  object { CSGObj11 }
  object { CSGObj12 }
  object { CSGObj13 }
  object { CSGObj14 }
  object { CSGObj15 }
  object { CSGObj16 }
  bounded_by { Bind_teeth }
  rotate <0.000000, -180.000000, -180.000000>
  translate <0.298293, -2.292599, -2.404322>
}
#declare upper_crossbar = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.400000, 0.400000, 3.500000>
  rotate <0.000000, -90.000000, -90.000000>
  translate <0.095939, -2.757285, 0.219532>
}

#declare piston_Bracket = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Grnt16
  }
  scale <1.900000, 0.200000, 1.000000>
  translate <7.903991, -1.131691, 0.853956>
}

#declare Upper_Pushrod = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.200000, 0.200000, 8.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <9.986049, -1.150836, 2.247556>
}

#declare upper_Piston = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.500000, 0.500000, 4.000000>
  rotate <0.000000, -90.000000, 0.000000>
  translate <9.986049, -1.150836, 2.247556>
}

#declare linkage = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.200000, 0.200000, 3.000000>
  rotate <0.000000, 45.000000, 0.000000>
  translate <0.043606, -1.150836, 0.140811>
}

#declare upper_arm = union {
  object { upper_crossbar }
  object { piston_Bracket }
  object { Upper_Pushrod }
  object { upper_Piston }
  object { linkage }
}

#declare upper = union {
  object { Upper_jaw }
  object { upper_teeth }
  object { upper_arm }
  bounded_by { bind_upper }
  translate <0.023315, -0.281147, 0.100113>
}
#declare bind_teethl = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <2.400193, 1.928032, 1.034990>
  translate <-1.017176, -1.299052, -2.340626>
}

#declare tooth = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_white
  }
  scale <1.000000, 1.050997, 0.490030>
  translate <0.464684, 5.736583, 0.560967>
}

#declare tooth2 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.057472, 6.144809, 1.060262>
}

#declare tooth3 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.854437, 6.150228, 1.060262>
}

#declare tooth4 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.056589, 5.373052, 1.060262>
}

#declare tooth5 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_white
  }
  scale <0.600000, 0.600000, 0.600000>
  translate <0.858973, 5.378471, 1.060262>
}

#declare CSGObj001 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -12.774026>
  translate <0.202812, -1.967415, -2.464432>
}

#declare CSGObj2 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 5.729893>
  translate <0.020113, -2.010863, -2.707448>
}


#declare CSGObj3 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 11.336296>
  translate <-0.652535, -2.157201, -2.920087>
}

#declare CSGObj4 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -25.000000>
  translate <-2.921334, -4.113229, -3.178292>
}

#declare CSGObj5 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -12.774026>
  translate <-1.562054, -4.620045, -2.950464>
}

#declare CSGObj6 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 10.500000>
  translate <1.126323, -4.762668, -2.418867>
}

#declare CSGObj7 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -3.709044>
  translate <-0.368949, -4.855210, -2.707448>
}


#declare CSGObj8 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 29.641829>
  translate <-0.917955, -2.240508, -3.178292>
}

#declare CSGObj17 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, 40.000000>
  translate <-1.408144, -2.473931, -3.237499>
}
#declare CSGObj18 = union {
  object { tooth }
  object { tooth2 }
  object { tooth3 }
  object { tooth4 }
  object { tooth5 }
  texture {
    shiny_white
  }
  scale <0.370000, 0.370000, 0.600000>
  rotate <0.000000, -15.000000, -35.000000>
  translate <-4.052587, -3.553013, -3.296706>
}

#declare lower_teeth = union {
  object { CSGObj001 }
  object { CSGObj2 }
  object { CSGObj3 }
  object { CSGObj4 }
  object { CSGObj5 }
  object { CSGObj6 }
  object { CSGObj7 }
  object { CSGObj8 }
  object { CSGObj17 }
  object { CSGObj18 }
  bounded_by { bind_teethl }
  translate <0.230167, 0.076722, 0.000000>
}
#declare bin_pass = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <4.100738, 2.200737, 1.556038>
  translate <4.422122, -1.207807, -1.122863>
}

#declare roller15 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <8.176234, -2.284992, -1.596149>
}

#declare roller14 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <7.676234, -2.284992, -1.596149>
}

#declare roller13 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <7.176234, -2.284992, -1.596149>
}

#declare roller12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <6.676234, -2.284992, -1.596149>
}

#declare roller11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <6.176234, -2.284992, -1.596149>
}

#declare roller10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.676234, -2.284992, -1.596149>
}

#declare roller9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <5.176234, -2.284992, -1.596149>
}

#declare roller8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <4.676234, -2.284992, -1.596149>
}

#declare roller7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <4.176234, -2.284992, -1.596149>
}

#declare roller6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <3.676234, -2.284992, -1.596149>
}

#declare roller5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <3.176234, -2.284992, -1.596149>
}

#declare roller4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <2.676234, -2.284992, -1.596149>
}

#declare roller3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <2.176234, -2.284992, -1.596149>
}

#declare roller2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.676234, -2.284992, -1.596149>
}

#declare roller1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.176234, -2.284992, -1.596149>
}

#declare roller = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.180000, 0.180000, 2.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <0.676234, -2.284992, -1.596149>
}

#declare rollers = union {
  object { roller15 }
  object { roller14 }
  object { roller13 }
  object { roller12 }
  object { roller11 }
  object { roller10 }
  object { roller9 }
  object { roller8 }
  object { roller7 }
  object { roller6 }
  object { roller5 }
  object { roller4 }
  object { roller3 }
  object { roller2 }
  object { roller1 }
  object { roller }
  texture {
    matte_brown
  }
  scale <1.000000, 1.200000, 1.000000>
  translate <0.011136, 0.398263, 0.014304>
}
#declare belt = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <4.000000, 1.000000, 0.300000>
  translate <4.422122, -1.209022, -1.581029>
}

#declare belt1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.834205, 1.327667, 0.200000>
  translate <4.422122, -1.209022, -1.581029>
}

#declare conveyer = difference {
  object { belt }
  object { belt1 }
  texture {
    shiny_yellow
  }
}

#declare hinge_pin = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Silver3
  }
  scale <0.250000, 0.250000, 4.200000>
  rotate <0.000000, -90.000000, -90.000000>
  translate <1.502391, -3.307807, -1.115696>
}

#declare lower_hinge = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFWood3
  }
  scale <0.200000, 2.000000, 0.700000>
  rotate <0.000000, -15.000000, 0.000000>
  translate <1.728360, -1.213572, -1.850252>
}

#declare upper_hinge = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFWood3
  }
  scale <0.200000, 2.000000, 0.700000>
  rotate <0.000000, 15.000000, 0.000000>
  translate <1.714236, -1.213572, -0.395474>
}

#declare hinge = union {
  object { hinge_pin }
  object { lower_hinge }
  object { upper_hinge }
}

#declare hinhge_cut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_plum
  }
  scale <0.448094, 1.000000, 0.894875>
  translate <1.639847, -1.211116, -1.168497>
}

#declare hole = difference {
  object { hinge }
  object { hinhge_cut }
}

#declare passage = union {
  object { rollers }
  object { conveyer }
  object { hole }
  bounded_by { bin_pass }
  translate <-0.110442, 0.000000, -0.096374>
}
#declare Bind_wad = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.586860, 1.600188, 1.525425>
  translate <-0.939602, 0.099958, 0.465008>
}

#declare Sphere001 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.466045, 0.639729, 0.000000>
}

#declare Sphere002 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.439390, -0.386503, 0.000000>
}

#declare Sphere3 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.439814, 0.639729, 0.000000>
}

#declare Sphere4 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.413158, -0.439814, 0.000000>
}

#declare Sphere5 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.932938, 0.126759, 0.930017>
}

#declare wad = union {
  object { Sphere001 }
  object { Sphere002 }
  object { Sphere3 }
  object { Sphere4 }
  object { Sphere5 }
  bounded_by { Bind_wad }
  scale <0.250000, 0.250000, 0.250000>
  translate <5.445318, -1.254758, -1.105243>
}

#declare Sphere2 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.466045, 0.639729, 0.000000>
}

#declare Sphere6 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.439390, -0.386503, 0.000000>
}

#declare Sphere7 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.439814, 0.639729, 0.000000>
}

#declare Sphere8 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.413158, -0.439814, 0.000000>
}

#declare Sphere9 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.932938, 0.126759, 0.930017>
}

#declare wad1 = union {
  object { Sphere2 }
  object { Sphere6 }
  object { Sphere7 }
  object { Sphere8 }
  object { Sphere9 }
  scale <0.250000, 0.250000, 0.250000>
  translate <3.999076, -1.254758, -1.134168>
}

#declare Sphere10 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.466045, 0.639729, 0.000000>
}

#declare Sphere11 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.439390, -0.386503, 0.000000>
}

#declare Sphere12 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.439814, 0.639729, 0.000000>
}

#declare Sphere13 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.413158, -0.439814, 0.000000>
}

#declare Sphere14 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.932938, 0.126759, 0.930017>
}

#declare wad2 = union {
  object { Sphere10 }
  object { Sphere11 }
  object { Sphere12 }
  object { Sphere13 }
  object { Sphere14 }
  scale <0.250000, 0.250000, 0.250000>
  translate <2.408211, -1.254758, -1.105243>
}

#declare Sphere15 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.466045, 0.639729, 0.000000>
}

#declare Sphere16 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-1.439390, -0.386503, 0.000000>
}

#declare Sphere17 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.439814, 0.639729, 0.000000>
}

#declare Sphere18 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.413158, -0.439814, 0.000000>
}

#declare Sphere19 = object { 
  sphere {<0,0,0>,1}
  texture {
    shiny_pink
  }
  translate <-0.932938, 0.126759, 0.930017>
}

#declare wad3 = union {
  object { Sphere15 }
  object { Sphere16 }
  object { Sphere17 }
  object { Sphere18 }
  object { Sphere19 }
  scale <0.250000, 0.250000, 0.250000>
  translate <6.891559, -1.254758, -1.105243>
}

union {   // mouth
  object { jaw1 }
  object { lower_arm }
  object { upper }
  object { lower_teeth }
  object { passage }
  object { wad }
  object { wad1 }
  object { wad2 }
  object { wad3 }
  bounded_by { Bind_whole }
  scale <1.000000, 1.000000, 1.189496>
  translate <-14.306738, -16.269564, 7.745897>
}

//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 0 lights, 4 textures and 20 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/16/1995    (16.07.1995)
//


//
// ********  T E X T U R E S  *******
//

#include "GAUGE.INC"

// ********  O B J E C T S *******
#declare Bound00001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.140255, 0.687680, 1.311985>
  translate <1.488001, -19.035949, 6.313447>
}

#declare Pipe2 = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    Polished_Chrome2
  }
  scale <0.250000, 0.250000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.866936, -19.385242, 5.574476>
}

#declare pipecut1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.555112, 0.166269, 0.273006>
  translate <1.903489, -19.382024, 5.868396>
}

#declare pipecut2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.555112, 0.166269, 0.273006>
  rotate <0.000000, -90.000000, 0.000000>
  translate <2.144522, -19.382024, 5.601094>
}

#declare elbow1 = difference {
  object { Pipe2 }
  object { pipecut1 }
  object { pipecut2 }
  texture {
    Polished_Chrome2
  }
}

#declare Pipe3 = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    Polished_Chrome2
  }
  scale <0.250000, 0.250000, 0.250000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <1.845605, -19.009863, 5.203841>
}

#declare pipecut3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.266391, 0.585197, 0.171724>
  translate <1.585280, -18.973721, 5.213443>
}

#declare pipecut4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.266391, 0.585197, 0.171724>
  rotate <0.000000, 0.000000, -90.000000>
  translate <1.768806, -18.740142, 5.213443>
}

#declare elbow2 = difference {
  object { Pipe3 }
  object { pipecut3 }
  object { pipecut4 }
  texture {
    Polished_Chrome2
  }
}

#declare lower_gauge1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    Brass_Metal
  }
  scale <1.000000, 1.000000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.506346, -19.652673, 6.509808>
}

#declare Lower_gauge_cut = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.100000, 0.200000, 0.750000>
  translate <1.488001, -19.483373, 6.835176>
}

#declare lower1 = difference {
  object { lower_gauge1 }
  object { Lower_gauge_cut }
  texture {
    Brass_Metal
  }
}

#declare needle = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    shiny_black
  }
  scale <0.050000, 0.050000, 1.193779>
  rotate <0.000000, -19.484529, 0.000000>
  translate <1.497978, -19.590328, 5.855253>
}

#declare gauge_face = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    matte_white
  }
  scale <1.000000, 1.000000, 0.250000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <1.506346, -19.511471, 6.518617>
}

#declare Gauge = union {   // bind_gauge
  object { elbow1 }
  object { elbow2 }
  object { lower1 }
  object { needle }
  object { gauge_face }
  bounded_by { Bound00001 }
  translate <0.0, 0.0, 0.0>
}
object { Gauge
  translate <-4.278024, -1.551301, -0.127177>
}
object { Gauge
  translate <-7.255181, -1.551301, -0.146140>
}
//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 0 lights, 8 textures and 36 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 07/17/1995    (17.07.1995)
//

//
// ********  T E X T U R E S  *******
//

#include "MAN.INC"

// ********  O B J E C T S *******
#declare torso = object { 
  sphere {<0,0,0>,1}
  texture {
    TORSO_TXR2
    scale <2.008486, 1.750000, 1.000000>
    rotate <-90.000000, -180.000000, 0.000000>
    translate <0.999876, -1.000000, -1.017481>
  }
  scale <1.000000, 1.000000, 1.500000>
  translate <0.000000, 0.000000, -1.800000>
}

#declare head = object { 
  sphere {<0,0,0>,1}
  texture {
    Facetxt
    scale <2.300000, 2.300000, 2.300000>
    rotate <-90.000000, -180.000000, 35.000000>
    translate <0.977222, 0.357006, -1.000000>
  }
  scale <0.800000, 0.800000, 0.800000>
}

#declare leg = torus { 
  0.600, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_purple
  }
  scale <0.944774, 2.400000, 1.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.332228, 0.000000, -4.002265>
}

#declare legcut = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.400000, 0.200000, 1.689048>
  rotate <0.000000, -15.000000, 0.000000>
  translate <0.110248, 0.000000, -3.900009>
}

#declare legcut1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.800000, 0.200000, 0.800000>
  translate <-0.399596, 0.000000, -4.960681>
}

#declare left_leg = difference {
  object { leg }
  object { legcut }
  object { legcut1 }
}

#declare shoe = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.400000, 0.400000, 0.200000>
  translate <-0.882186, 0.000000, -4.191612>
}

#declare sole = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_brown
  }
  scale <0.450000, 0.450000, 0.050000>
  translate <-0.897452, 0.000000, -4.361287>
}

#declare boot = difference {
  object { shoe }
  object { sole }
  scale <1.000000, 1.400000, 1.000000>
  translate <0.000000, -0.290510, 0.000000>
}

#declare leg2 = torus { 
  0.600, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_purple
  }
  scale <0.944774, 2.400000, 1.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.332228, 0.000000, -4.002265>
}

#declare legcut4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.400000, 0.200000, 1.689048>
  rotate <0.000000, -15.000000, 0.000000>
  translate <0.110248, 0.000000, -3.900009>
}

#declare legcut5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.800000, 0.200000, 0.800000>
  translate <-0.399596, 0.000000, -4.960681>
}

#declare left_arm = difference {
  object { leg2 }
  object { legcut4 }
  object { legcut5 }
  rotate <-30.000000, 18.549189, 0.000000>
  translate <0.568993, 1.199763, 0.801223>
}

#declare shoe2 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.400000, 0.400000, 0.200000>
  translate <-0.882186, 0.000000, -4.191612>
}

#declare sole2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_brown
  }
  scale <0.450000, 0.450000, 0.050000>
  translate <-0.897452, 0.000000, -4.361287>
}

#declare finger_cut = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-1.072484, -0.330738, -4.182155>
}

#declare finger_cut1 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-0.849408, -0.330738, -4.182155>
}

#declare finger_cut2 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-0.643491, -0.365057, -4.182155>
}

#declare Left_hand = difference {
  object { shoe2 }
  object { sole2 }
  object { finger_cut }
  object { finger_cut1 }
  object { finger_cut2 }
  scale <1.000000, 1.400000, 1.000000>
  rotate <15.000000, 0.000000, 0.000000>
  translate <-0.538308, -2.246289, 1.600465>
}

#declare Left_side = union {
  object { left_leg }
  object { boot }
  object { left_arm }
  object { Left_hand }
}
#declare shoe1 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.400000, 0.400000, 0.200000>
  translate <-0.882186, 0.000000, -4.191612>
}

#declare sole1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_brown
  }
  scale <0.450000, 0.450000, 0.050000>
  translate <-0.897452, 0.000000, -4.361287>
}

#declare boot1 = difference {
  object { shoe1 }
  object { sole1 }
  scale <1.000000, 1.400000, 1.000000>
  translate <2.000000, -0.312531, 0.000000>
}

#declare leg1 = torus { 
  0.600, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_purple
  }
  scale <0.944774, 2.400000, 1.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.332228, 0.000000, -4.002265>
}

#declare legcut2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.400000, 0.200000, 1.689048>
  rotate <0.000000, -15.000000, 0.000000>
  translate <0.110248, 0.000000, -3.900009>
}

#declare legcut3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.800000, 0.200000, 0.800000>
  translate <-0.399596, 0.000000, -4.960681>
}

#declare Right_leg = difference {
  object { leg1 }
  object { legcut2 }
  object { legcut3 }
  rotate <0.000000, 0.000000, -180.000000>
  translate <0.206714, 0.000000, 0.000000>
}

#declare leg3 = torus { 
  0.600, 0.100  // Major, minor radius
  rotate -x*90
  texture {
    shiny_purple
  }
  scale <0.944774, 2.400000, 1.000000>
  rotate <-90.000000, 0.000000, 0.000000>
  translate <-0.332228, 0.000000, -4.002265>
}

#declare legcut6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.400000, 0.200000, 1.689048>
  rotate <0.000000, -15.000000, 0.000000>
  translate <0.110248, 0.000000, -3.900009>
}

#declare legcut7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    shiny_purple
  }
  scale <0.800000, 0.200000, 0.800000>
  translate <-0.399596, 0.000000, -4.960681>
}

#declare Right_arm = difference {
  object { leg3 }
  object { legcut6 }
  object { legcut7 }
  rotate <-95.000000, -180.000000, 35.000000>
  translate <-1.009827, 1.891317, -0.870512>
}

#declare shoe3 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.400000, 0.400000, 0.200000>
  translate <-0.882186, 0.000000, -4.191612>
}

#declare sole3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    matte_brown
  }
  scale <0.450000, 0.450000, 0.050000>
  translate <-0.897452, 0.000000, -4.361287>
}

#declare finger_cut3 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-1.072484, -0.330738, -4.182155>
}

#declare finger_cut4 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-0.849408, -0.330738, -4.182155>
}

#declare finger_cut5 = object { 
  sphere {<0,0,0>,1}
  texture {
    matte_brown
  }
  scale <0.050000, 0.300000, 0.200000>
  translate <-0.643491, -0.365057, -4.182155>
}

#declare right_hand = difference {
  object { shoe3 }
  object { sole3 }
  object { finger_cut3 }
  object { finger_cut4 }
  object { finger_cut5 }
  texture {
    matte_brown
  }
  scale <1.000000, 1.400000, 1.000000>
  rotate <0.000000, 0.000000, 20.000000>
  translate <3.048188, -1.156087, 2.900000>
}

#declare Right_side = union {
  object { boot1 }
  object { Right_leg }
  object { Right_arm }
  object { right_hand }
  translate <-0.261838, 0.000000, 0.000000>
}
union {   // Man
  object { torso }
  object { head }
  object { Left_side }
  object { Right_side }
  scale <2.000000, 2.000000, 2.000000>
  rotate <0.000000, 0.000000, 35.000000>
  translate <-23.566217, -16.166515, 8.800000>
}
#declare gum3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, -4.649391>
  translate <-23.716726, -21.818233, 0.630000>
}

#declare gum2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, 5.000000>
  translate <-23.716726, -21.900425, 1.100000>
}

#declare gum4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, -3.000000>
  translate <-23.716726, -21.900425, 1.550000>
}

#declare gum6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, 2.000000>
  translate <-23.716726, -21.900425, 2.000000>
}

#declare gum8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, -8.000000>
  translate <-23.716726, -21.900425, 2.450000>
}

#declare gum10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, 1.000000>
  translate <-23.716726, -21.900425, 2.900000>
}

#declare gum11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    gum_txt
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, -301.618042, -73.406944>
  translate <-23.676375, -23.822451, 2.200000>
}

union {
  object { gum3 }
  object { gum2 }
  object { gum4 }
  object { gum6 }
  object { gum8 }
  object { gum10 }
  object { gum11 }
  translate <0.011762, 0.000000, -0.200000>
}

box {   // gum12
  <-1, -1, -1>, <1, 1, 1>
  texture { color Pink }
  scale <2.024618, 1.070249, 0.200000>
  rotate <0.000000, 0.000000, -34.068512>
  translate <-16.238095, -17.826672, 5.955275>
}


