#declare Table = plane {
	y, 0
	texture {My_wood}
}

#declare Wall = plane {
	-z, 0
	texture {
		pigment {
			image_map {
				gif "wall.gif"
				map_type 0
				interpolate 2
			}
		}
		finish {ambient 0.2 phong 0.2}
		normal {
			bump_map {
				gif "wall.gif"
				map_type 0
				interpolate 2
				bump_size 1
			}
		}
		scale 4
	}
}

#declare Face = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "dlf.gif"
				once
				map_type 0
				interpolate 2
			}
		}
		finish { ambient 0.3 phong 1 }
	}
	scale <1, 0.5, 1>
	rotate x*90
	translate y*0.001
}

#declare Back = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "grn.gif"
				once
				map_type 0
				interpolate 2
			}
		}
		finish { ambient 0.3 phong 1 }
	}
	scale <1, 0.5, 1>
	rotate x*90
	translate y*0.003
}

#declare Bar = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	pigment { color rgb <0.85, 0.85, 0.85>}
	finish { ambient 0.3 phong 1 }

	scale <1.2, 0.15, 1>
	rotate x*90
	translate y*0.002
}

#declare M_glass = union {
	sphere { <0, 0, 0>, 0.2
		scale <1, 1, 0.15>
		texture {My_glass}
	}
	difference {
		cylinder {<0, 0, -0.02>, <0, 0, 0.02>, 0.21}
		cylinder {<0, 0, -0.1>, <0, 0, 0.1>, 0.19}
	}
	torus {0.21, 0.01 rotate x*90}
	difference {
		sphere {<0, 0, 0>, 0.23}
		box {<-0.3, -0.18, -0.3>, <0.3, 0.18, 0.3>}
		scale <0.25, 1, 0.25>
		translate -y*0.43
	}
	sphere {<0, 0, 0>, 0.22
		pigment {color rgb <0.4, 0, 0>}
		finish {ambient 0.2 phong 1}
		normal {
			bump_map {
				gif "handle.gif"
				map_type 1
				interpolate 2
				bump_size 3
			}
		}
		scale <0.25, 1, 0.25> translate -y*0.43
	}
	texture {Goldish}

	translate y*0.66
	rotate y*90
	rotate z*90
	rotate y*15
	translate <0.15, 0.055, -0.47>
	scale 1.3
}

#declare Bump = union {
	sphere {<0, 0, 0>, 0.02 translate <0.165, 0.95, 0>}
	cylinder {<0, 0, 0>, <0, 0.1, 0>, 0.02 translate <0.165, 0.85, 0>}
}

#declare Vessel = union {
	difference {
		merge {
			difference {
				sphere {<0, 0, 0>, 0.25 scale 0.2 translate y*0.05}
				plane {y, 0}
			}
			cylinder {<0, 0, 0>, <0, 0.1, 0>, 0.2}
			cylinder {<0, 0.05, 0>, <0, 0.7, 0>, 0.25}
			sphere {<0, 0, 0>, 0.25 scale <1, 0.5, 1> translate y*0.7}
			cylinder {<0, 0.6, 0>, <0, 0.9, 0>, 0.15}
		}
		merge {
			difference {
				sphere {<0, 0, 0>, 0.23 scale 0.2 translate y*0.07}
				plane {y, 0.02}
			}
			cylinder {<0, 0.05, 0>, <0, 0.7, 0>, 0.23}
			sphere {<0, 0, 0>, 0.23 scale <1, 0.5, 1> translate y*0.7}
			cylinder {<0, 0.5, 0>, <0, 1.1, 0>, 0.13}
		}
		pigment {color rgbf <0.85, 0.65, 0.45, 0.9>}
		finish {ambient 0.2 phong 1 reflection 0.2}
	}
	union {
		torus {0.17, 0.02 translate y*0.85}
		sphere {<0, 0, 0>, 0.17 scale <1, 0.2, 1> translate y*1}
		cylinder {<0, 0.85, 0>, <0, 1, 0>, 0.17}
		object {Bump}
		object {Bump rotate y*20}
		object {Bump rotate y*40}
		object {Bump rotate y*60}
		object {Bump rotate y*80}
		object {Bump rotate y*100}
		object {Bump rotate y*120}
		object {Bump rotate y*140}
		object {Bump rotate y*160}
		object {Bump rotate y*180}
		object {Bump rotate y*200}
		object {Bump rotate y*220}
		object {Bump rotate y*240}
		object {Bump rotate y*260}
		object {Bump rotate y*280}
		object {Bump rotate y*300}
		object {Bump rotate y*320}
		object {Bump rotate y*340}
		pigment {color rgb <0.8, 0.8, 0.5>}
		finish {ambient 0.2 phong 1}
	}
	scale 2
}

#declare Drop = blob {
	threshold 0.8
	component 1, 1.654240, <0, -0.950570, 0>
	component 1, 1.654240, <0, 1.041825, 0>

	texture {My_glass}

	translate <0, -0.6, 0>
	scale <0.08, 0.1, 0.08>
}

#declare Tube = union {
	cylinder {<1.2, 0, 0>, <1.2, 0, -5>, 0.3}
	cylinder {<-3, 0, 1.2>, <0, 0, 1.2>, 0.3}
	object {
		torus {1.2, 0.34
			clipped_by {plane {-x, 0}}
			clipped_by {plane {-z, 0}}
		}
	}
	torus {0.34, 0.04 rotate <90, 90, 0> translate z*1.2}
	torus {0.34, 0.04 rotate x*90 translate x*1.2}
	cylinder {<-0.02, 0, 0>, <0.02, 0, 0>, 0.34 translate z*1.2}
	cylinder {<0, 0, -0.02>, <0, 0, 0.02>, 0.34 translate x*1.2}
	object {Drop translate <0, -0.34, 1.2>}

	translate <5-1.7, 4.7, 7-1.7>

	pigment {color rgb <0.36, 0.35, 0.25>}
	finish {ambient 0.2 phong 0.2}
	normal {bumps 0.2 scale 0.01}
}














