//
// This is POV data file to scene oddjunk.pov by Timo Ettanen.
//
// This file contains the environment

   #include "colors.inc"
   #include "shapes.inc"
   #include "textures.inc"

#declare  Darkerwood =               // Slightly darker than DMFWood2
 pigment 
  {wood
   turbulence 0.04
   octaves 4
   scale <0.05, .05, 1>
   color_map 
    {[0.00, 0.10 color red 0.50 green 0.33 blue 0.23
                 color red 0.50 green 0.33 blue 0.23]
     [0.10, 0.90 color red 0.50 green 0.33 blue 0.23
                 color red 0.40 green 0.25 blue 0.13]
     [0.90, 1.0  color red 0.40 green 0.25 blue 0.13
                 color red 0.40 green 0.25 blue 0.13]
    }
  }

#declare Longwood =                  // Basic woodpiece without texture
   union{

     box{<0,0,0.25><15,100,2.75>}
     box{<0.25,0,0><14.75,100,3> }

     cylinder{<0.25,0,0.25><0.25,100,0.25>,0.25}
     cylinder{<14.75,0,0.25><14.75,100,0.25>,0.25}
     cylinder{<14.75,0,2.75><14.75,100,2.75>,0.25}
     cylinder{<0.25,0,2.75><0.25,100,2.75>,0.25}

   bounded_by {box{<-.001,-.001,-.001>,<15.001,100.001,3.001>}}
   }

#declare Pilar =                          // Pilar to the corner
   difference{
       box{<-5,0,-5><5,100,5>}
       box{<-6,0,-6><6,100,6> rotate<0,45,0> inverse}

       texture{Darkerwood scale 12
                      rotate<87,0,2>
                      translate<2,0,2>
       }
   }

#declare Horizwood =                        // Support wood across wall
       box{<0,0,0><5,5,135>
           texture{Darkerwood scale 10
                      rotate<1,0,2>
                      translate<6,0,6>
           }
      }

#declare Wallwood1 =
     object {Longwood texture{DMFWood2
                        scale 12
                        rotate<88,0,2>
                        translate<2,0,0.5>}
             }
#declare Wallwood2 =
     object {Longwood texture{DMFWood2
                        scale 10
                        rotate<91,0,-3>
                        translate<5,0,1>}
             }
#declare Wallwood3 =
     object {Longwood texture{Darkerwood
                        scale 11
                        rotate<85,0,2>
                        translate<7,0,0>}
             }

#declare Floorwood1 =
     object {Longwood rotate<90,0,0>
              texture{DMFWood4
                        scale 12
                        rotate<2,0,2>
                        translate<2,0,0.5>}
     }
#declare Floorwood2 =
     object {Longwood rotate<90,0,0>
              texture{DMFWood4
                        scale 11
                        rotate<-2,0,-3>
                        translate<5,0,1>}
     }
#declare Floorwood3 =
     object {Longwood rotate<90,0,0>
              texture{DMFWood4
                        scale 13
                        rotate<1,0,2>
                        translate<7,0,0>}
     }

#declare Leftwallpart =
       union{
         object{Wallwood1 rotate<0,-90,0> translate<-15,-3,35>}
         object{Wallwood2 rotate<0,-90,0> translate<-15,-3,20>}
         object{Wallwood3 rotate<0,-90,0> translate<-15,-3,5>}
       }

#declare Backwallpart =
       union{
         object{Wallwood1 translate<-15,-3,50>}
         object{Wallwood3 translate< 0, -3,50>}
         object{Wallwood2 translate< 15,-3,50>}
       }

#declare Floorpart =
       union{
         object{Floorwood1 translate<-20,-3,-50>}
         object{Floorwood2 translate< -5,-3,-50>}
         object{Floorwood3 translate< 10,-3,-50>}
       }

#declare Tubes =                            // Pile of tubes on the floor
      union{
         cylinder{<40,-1.5,38><70,-1.5,38>,1.5}
         cylinder{<40,-1.5,35><70,-1.5,35>,1.5}
         cylinder{<40,-1.5,32><70,-1.5,32>,1.5}
         cylinder{<41,1,36.5><70,1,36.5>,1.5}

         texture { Odd_Iron
                 scale .4
         }
      }
#declare Barrels =     // Something to reflect from unvisible parts of scene
      union{
         cylinder{<10,-3,-70><10,23,-70>,10  pigment{Gray95}}
         cylinder{<31,-3,-70><40,23,-70>,10  pigment{Yellow}}
      }

#declare Scrap =
      union{
          box{<-4,-2.9,-3><4,-2.89,3>
              rotate<0,-40,0>
              translate<13,0,-7>
              pigment{Gray80}
          }
          cylinder{<-2,-2.5,0><2,-2.5,0>,0.5
              rotate<0,-10,0>
              translate<41,0,19>
              pigment{Brown}
          }
      }

#declare Room =
       union{
         object{ Leftwallpart }
         object{ Leftwallpart translate <0,0,-45>}
         object{ Leftwallpart translate <0,0,-90>}
         object{ Horizwood translate<-15,30,-85>}
         object{ Pilar translate<-10,-3,45> }
         object{ Pilar translate<-10,-3,-10> }
         object{ Pilar translate<50,-3,45> }
         object{ Backwallpart }
         object{ Backwallpart translate<45,0,0>}
         object{ Backwallpart translate<90,0,0>}
         object{ Horizwood rotate<0,90,0> translate<-15,30,50>}
         object{ Floorpart }
         object{ Floorpart translate<45,0,0>}
         object{ Floorpart translate<90,0,0>}
         object{ Tubes }
         object{ Barrels }
         object{ Scrap}
         box{<-20,-5,-90><135,100,55>
             pigment{ color red 0.50 green 0.33 blue 0.23 }
             clipped_by{
                 box{<70,-3,-91><130,80,-89> inverse}
                 box{<134,51,-80><136,70,-66> inverse}
                 box{<134,51,-64><136,70,-50> inverse}
                 box{<134,30,-80><136,49,-66> inverse}
                 box{<134,30,-64><136,49,-50> inverse}
             }
         }
      }
