// Entry for the July Raytracing contest: "Gadgets"
// "Planet Revive-O-Matic"
// created by John Kolesar 7/28/95

#include "colors.inc"
#include "textures.inc"
#include "revive.inc"

camera {
   location  <0, 2, -15>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 0, 20>
}

light_source {<-10, 10, -30> color White}

// Stars backround
box {<0, 0, 0>,<1, 1, 1>
      pigment {image_map { gif "Stars.gif" } }
      finish {ambient .75 diffuse .2}
      translate <-.5, -.5, 75>         // center it
      scale <150, 100, 1>
    }

// Earth (sad)
sphere { <0, 0, 0>, .5
   texture { pigment { image_map { gif "map.gif" map_type 1 } rotate <0,-90,0> } }
   texture { Clouds scale .05 }
   texture { pigment { image_map { gif "frowny2.gif" map_type 1 filter 1,1.0 } rotate <0,-90,0> } }
   rotate <0,-10,0>
   translate <-8,4,0>
}

// Earth (happy)
sphere { <0, 0, 0>, .5
   texture { pigment { image_map { gif "map.gif" map_type 1 } rotate <0,-90,0> } }
   texture { Clouds scale .05 }
   texture { pigment { image_map { gif "smiley2.gif" map_type 1 filter 1,1.0 } rotate <0,-90,0> } }
   rotate <0,10,0>
   translate <8,4,0>
}

object { PlanetRevive translate <0,-.75,0> }
