// Persistence of Vision Raytracer

#declare SpnwhlBase = object {
  intersection {
    object { plane {-x, 0}}
    object { plane { x, 23.625}}
    object { plane {-y, 0.75}}
    object { plane { y,  0.75}}
    object { plane { z, 0}   rotate -8.72338*y translate (27/16)*z}
    object { plane { -z, 0}  translate (-27/16)*z}
  }
  texture {
     SpnwhlTexture
     scale <1.0 1.0 1.0> 
     rotate <0.0 0.0 0.0>
     translate <0.0 0.0 0.0>
  } 
  bounded_by { box {< -0.1, -0.76, -1.7> < 24.0, 0.76, 5.4>} }
}
#declare SpnwhlArm = object {
  union {
    cylinder { <0.00000, 0.0, 0.0>,<  3.8125, 0.0, 0.0>, 0.6875}
    cylinder { <3.81250, 0.0, 0.0>,< 11.1875, 0.0, 0.0>, 0.8750}
    cylinder { <13.6875, 0.0, 0.0>,< 17.9375, 0.0, 0.0>, 0.8750}
    cylinder { <17.9375, 0.0, 0.0>,< 22.0000, 0.0, 0.0>, 0.6875}
    object {torus {(9/16),(5/16)} rotate 90*z translate  3.8125*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 11.1875*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 11.8125*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 12.4375*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 13.0625*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 13.6875*x}
    object {torus {(9/16),(5/16)} rotate 90*z translate 17.9375*x}
  }
  texture {
     SpnwhlTexture
     scale <1.0 1.0 1.0> 
     rotate <0.0 0.0 0.0>
     translate <0.0 0.0 0.0>
  } 
}

#declare Spindle = object {
  union {
    object {
      cone {
        <0.0, 0, 0.0>,0.15625
        <0.0, 0.56250, 0.0>,1.25
      }
    }
    object {
      cylinder {
        <0.0, 0.56250, 0.0>,
        <0.0, 3.9375, 0.0>,0.31250
      }
    }
    object {
      cone {
        <0.0, 3.9375, 0.0>,1.625
        <0.0, 4.47917, 0.0>,0.0
      }
    }
    object {
      sphere { <0.0, 0.0, 0.0>,1.0 scale <0.8125, 0.3125, 0.8125> translate 4.5625*y }
    }
    // cap
    object {
      cone {<0.0,4.5625,0.0>,0.875,<0.0, 4.6875,0.0>,1.0}
    }
    object {
      cone {<0.0,4.6875,0.0>,1.0,<0.0, 4.8125,0.0>,0.875}
    }
    object {
      cone {<0.0,4.8125,0.0>,0.875,<0.0, 4.9375,0.0>,1.0}
    }
    object {
      cone {<0.0,4.9375,0.0>,1.0,<0.0, 5.0625,0.0>,0.875}
    }
    object {
      cone {<0.0,5.0625,0.0>,0.875,<0.0, 5.1875,0.0>,1.0}
    }
    object {
      cone {<0.0,5.1875,0.0>,1.0,<0.0, 5.3125,0.0>,0.875}
    }
    object {
      cylinder {<0.0,5.3125,0.0>,<0.0,5.5625,0.0>,0.125}
    }
    object {
      intersection {
        cylinder{<0.0,5.3125,0.0>,<0.0,5.4375,0.0>,0.25}
        torus{0.25 0.125 translate 5.4375*y inverse}
      }
    }
  }
  texture {
     SpnwhlTexture
     scale <1.0 1.0 1.0> 
     rotate <0.0 0.0 0.0>
     translate <0.0 0.0 0.0>
  } 
  bounded_by{cylinder{<0.0,0.0,0.0><0.0,5.63,0.0>,1.63}}
}

#declare SpindleComb = object {
  intersection {
    object { Qegg_Y sturm
      scale <2.5,5.0,2.5>
      translate 5*y
    }
    object { Qegg_Y sturm
      scale <2.2, 4.0, 2.2> 
      translate 5.0*y 
      inverse
    }
    plane { y, 5.0}
    plane {-z, 0.25}
    plane { z,  0.25}
  }
  texture { SpnwhlTexture } 
  bounded_by {box {<-2.6,-0.1,-0.26><2.6,5.1,0.26>}}
}
#declare Spoke =  object {
  cone {
    <0.0,-1.0,0.0>,(3/16)    // Center and radius of one end
    <0.0,-13.0,0.0>,0.25    // Center and radius of other end
  }
}
#declare Wheel_Z = object { 
  union {
     object{ 
       intersection {
         object { Disk_Z scale< 15.0,  15.0,  0.5 > }
         object { Disk_Z scale< 13.0,  13.0,  0.51 > inverse}
         //object { CounterSink_Z scale< 15.0,15.0,15.0 > translate< 0.0, 0.0,  0.6 > inverse}
         //object { CounterSink_Z scale< 15.0,15.0,15.0 > translate< 0.0, 0.0, -0.6 > inverse}
         object { CounterSink_Z scale< 13.0,13.0,13.0 > translate< 0.0, 0.0,  0.6 > inverse}
         object { CounterSink_Z scale< 13.0,13.0,13.0 > translate< 0.0, 0.0, -0.6 > inverse}
         object {torus{15.0, 0.16666} rotate 90*x translate -0.222*z inverse}
         object {torus{15.0, 0.16666} rotate 90*x translate  0.222*z inverse}
       } 
       bounded_by { box {<-16.0,-16.0,-0.51> <16.0,16.0,0.51>} }
     }
     object{ 
       sphere {
         < 0.0, 0.0, 0.0 > (27/16) 
         scale < 1.0 1.0 0.5 >
       }
     }  
     object { Spoke
       rotate <0.0, 0.0, 0.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 30.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 60.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 90.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 120.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 150.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 180.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 210.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 240.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 270.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 300.0>
     }
     object { Spoke
       rotate <0.0, 0.0, 330.0>
     }
   }
   texture {
     SpnwhlTexture
     scale <1.0 1.0 1.0> 
     rotate <0.0 0.0 0.0>
     translate <0.0 0.0 0.0>
   } 
}
#declare SpindleFrameRing = object {
  intersection {
    torus {0.625, 0.25}
    plane {1*y 0.21875}
    plane {-1*y 0.21875}
  }
  bounded_by {cylinder {<0.0,-0.21876,0.0>,<0.0,0.21876,0.0>,0.876}};
}
#declare SpindleFrame = object {
  union {
    object{ cylinder {<0.0,0.0,0.0>,<0.0,3.21875,0.0>,0.75}}
    object{ cylinder {<0.0,3.21875,0.0>,<0.0,6.84375,0.0>,0.6875}}
    object{ cylinder {<0.0,6.84375,0.0>,<0.0,11.25,0.0>,0.75}}

    object{ cylinder {<0.0,1.5,-8.5>,<0.0,1.5,1.75>,0.5 }}
    object{ cylinder {<0.0,9.875,-8.5>,<0.0,9.875,0.0>,0.5 }}
    object{
      sphere {<0.0,0.0,0.0>,1.0}
      scale <0.5625,0.5625,0.25>
      translate <0.0,1.5,-8.5>
    }
    object{
      sphere {<0.0,0.0,0.0>,1.0}
      scale <0.5625,0.5625,0.25>
      translate <0.0,9.875,-8.5>
    }
    object { SpindleFrameRing
      translate 0.21875*y
    }
    object { SpindleFrameRing
      translate 3.21875*y
    }
    object { SpindleFrameRing
      translate 6.84375*y
    }
    object { SpindleFrameRing
      translate 11.03125*y
    }
  }
  texture {
     SpnwhlTexture
     scale <1.0 1.0 1.0> 
     rotate <0.0 0.0 0.0>
     translate <0.0 0.0 0.0>
  } 
}
#declare SpindleAssy = object {
  union {
    object {SpindleFrame}
    object {Spindle
      translate <1.0,3.75,-4.75>
    }
    object {SpindleComb
      rotate -45*y
      translate <1.0,2.75,-4.75>
    }
  }
}

#declare wheelx0=26.728
#declare wheely0=15.955

#declare SpnwhlUpperAssy = object {
  union {
    object { SpnwhlBase 
    }
    object { Wheel_Z
      rotate 20*z
      translate <wheelx0,wheely0,1.3125>
    }
    object { SpnwhlArm
      translate -20.25*x
      rotate atan2*z
      translate <wheelx0,wheely0,3.3125>
    }
    object { SpnwhlArm
      translate -20.25*x
      rotate atan2*z
      translate <wheelx0,wheely0,-0.6875>
    }
    object { SpindleAssy
      rotate 90*x
      rotate 13.151*z
      translate <2.0, 2.25, -7.9375>
    }
  }
}

#declare SpinningWheel = object {
  union {
    object { SpnwhlUpperAssy
       scale <1.0,  1.0,  1.0 >
       rotate -13.151*z
       translate <-3.75, 17.875, 0.0>
    }
    object{
      cone {<0,0,0>,0.25 
            <0,16.5,0>,0.5 
      }
      texture { SpnwhlTexture }
    }
    object{
      cone {<24*Sqrt3,0,12>,0.25 
            <17.53557,12.5,4.0625>,0.5 
      }
      texture { SpnwhlTexture }
    }
    object{
      cone {<24*Sqrt3,0,-12>,0.25 
            <17.99468,12.5,-0.4375>,0.5 
      }
      texture { SpnwhlTexture }
    }
  }
}
