#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


camera {  //  Camera StdCam
  location  <5,-1,4>
  sky       <0.0,     0.0,  1.0>  
  up        <0.0,     0.0,  1.0>  
  right     <1.3333,  0.0,  0.0>
  look_at   <0,0,2>
}

// *******  L I G H T S *******
light_source {   // Light1
  <15, 20, 10>
  color rgb <1.000, 1.000, 1.000>
}


// ************************************************************************************
// ************************************************************************************
// ************************************************************************************
// ************************************************************************************
// ************************************************************************************
// ************************************************************************************
// ************************************************************************************


// ********  O B J E C T S *******


// Desktop.

plane {
  <0, 0, 1>, 0 
  pigment {
    DMFDarkOak
    rotate 80*y
  }
}



// Ceiling

plane {
  <0, 0, 1>, 20 
  pigment {
White_Marble    
  }
}

// Wall

plane {
  <5, -1, 0>, -5
  pigment {
White_Marble    
  }
}

// Wall

plane {
  <1, -5, 0>, 3
  pigment {
White_Marble    
  }
}


#declare world = object { 
sphere
    {
    <0,0,0>,1

    pigment 
        {
        image_map 
            {
            gif "world1.gif"
            map_type 1
//            interpolate 4
            }
        rotate 90*x
        }
    finish 
        {
        ambient     .25
        diffuse     .75
        reflection  0
        brilliance  0
        phong       0


        specular 1 
        roughness 0.001
        }

    rotate 28*z  // Spin globe to show Switzerland.
    }
}

#declare spine = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 2.800000>
  translate <0.000000, 0.000000, -1.400000>
  texture{ Bronze_Texture}
}

#declare topcorner = object { 
  sphere {<0,0,0>,1}
  scale <0.100000, 0.100000, 0.100000>
  translate <0.000000, 0.000000, 1.400000>
  texture{ Bronze_Texture}
}

#declare topcorner1 = object { 
  sphere {<0,0,0>,1}
  scale <0.100000, 0.100000, 0.100000>
  translate <0.000000, 0.000000, -1.400000>
  texture{ Bronze_Texture}
}

#declare holder = torus { 
  1.400, 0.100  // Major, minor radius
  rotate -x*90
  rotate <-0.000000, -90.000000, -0.000000>
}

#declare cutinhalf = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <2.000000, 2.000000, 2.000000>
  translate <0.000000, -2.000000, 0.000000>
}

#declare semitorus = intersection {
  object { holder }
  object { cutinhalf }
  texture{ Bronze_Texture}
}

#declare globeinholder = union {
  object { world }
  object { spine }
  object { topcorner }
  object { topcorner1 }
  object { semitorus }
  rotate <15.000000, -0.000000, 115.000000>
  translate <0.000000, 0.000000, 2.500000>
}
#declare globebase = object {
  union {
  // Segment 1
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.76250, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.29180, -0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.53917, -0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.70446, -0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.76250, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 0.76250, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.29180, 0.70446, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.53917, 0.53917, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.52500, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.70446, 0.29180, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.76250, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.52500, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.58359, -1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.07834, -1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.40892, -0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.52500, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 1.52500, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.58359, 1.40892, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.07834, 1.07834, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.28750, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.40892, 0.58359, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.52500, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.28750, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <3.05000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.00000, -3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.00000, -2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, -2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.87539, -2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, -2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.61751, -1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, -1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
      <-3.05000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.11337, -0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-3.05000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-3.05000, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.28750, 0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <-1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <-0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.00000, 3.05000, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.00000, 2.28750, 0.00000> <0.00000, 0.00000, -1.00000>
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.16718, 2.81783, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <0.87539, 2.11337, 0.00000> <0.00000, 0.00000, -1.00000>
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.15668, 2.15668, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <1.61751, 1.61751, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.81783, 1.16718, 0.00000> <0.00000, 0.00000, -1.00000>
      <3.05000, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
    smooth_triangle {
      <2.11337, 0.87539, 0.00000> <0.00000, 0.00000, -1.00000>
      <2.28750, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
      <3.05000, -0.00000, 0.00000> <0.00000, 0.00000, -1.00000>
    }
  // Segment 2
    smooth_triangle {
      <3.05000, 0.00000, 0.00000> <1.00000, 0.00000, -0.00000>
      <2.89063, 0.00000, 0.15188> <0.40914, 0.00000, 0.91247>
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
    }
    smooth_triangle {
      <3.05000, 0.00000, 0.00000> <1.00000, 0.00000, -0.00000>
      <2.81783, -1.16718, 0.00000> <0.92388, -0.38268, -0.00000>
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
    }
    smooth_triangle {
      <2.81783, -1.16718, 0.00000> <0.92388, -0.38268, -0.00000>
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
    }
    smooth_triangle {
      <2.81783, -1.16718, 0.00000> <0.92388, -0.38268, -0.00000>
      <2.15668, -2.15668, 0.00000> <0.70711, -0.70711, -0.00000>
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
    }
    smooth_triangle {
      <2.15668, -2.15668, 0.00000> <0.70711, -0.70711, -0.00000>
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
    }
    smooth_triangle {
      <2.15668, -2.15668, 0.00000> <0.70711, -0.70711, -0.00000>
      <1.16718, -2.81783, 0.00000> <0.38268, -0.92388, -0.00000>
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
    }
    smooth_triangle {
      <1.16718, -2.81783, 0.00000> <0.38268, -0.92388, -0.00000>
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
    }
    smooth_triangle {
      <1.16718, -2.81783, 0.00000> <0.38268, -0.92388, -0.00000>
      <-0.00000, -3.05000, 0.00000> <-0.00000, -1.00000, -0.00000>
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
    }
    smooth_triangle {
      <-0.00000, -3.05000, 0.00000> <-0.00000, -1.00000, -0.00000>
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
    }
    smooth_triangle {
      <-0.00000, -3.05000, 0.00000> <-0.00000, -1.00000, -0.00000>
      <-1.16718, -2.81783, 0.00000> <-0.38268, -0.92388, -0.00000>
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
    }
    smooth_triangle {
      <-1.16718, -2.81783, 0.00000> <-0.38268, -0.92388, -0.00000>
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
    }
    smooth_triangle {
      <-1.16718, -2.81783, 0.00000> <-0.38268, -0.92388, -0.00000>
      <-2.15668, -2.15668, 0.00000> <-0.70711, -0.70711, -0.00000>
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
    }
    smooth_triangle {
      <-2.15668, -2.15668, 0.00000> <-0.70711, -0.70711, -0.00000>
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
    }
    smooth_triangle {
      <-2.15668, -2.15668, 0.00000> <-0.70711, -0.70711, -0.00000>
      <-2.81783, -1.16718, 0.00000> <-0.92388, -0.38268, -0.00000>
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
    }
    smooth_triangle {
      <-2.81783, -1.16718, 0.00000> <-0.92388, -0.38268, -0.00000>
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
    }
    smooth_triangle {
      <-2.81783, -1.16718, 0.00000> <-0.92388, -0.38268, -0.00000>
      <-3.05000, 0.00000, 0.00000> <-1.00000, 0.00000, -0.00000>
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
    }
    smooth_triangle {
      <-3.05000, 0.00000, 0.00000> <-1.00000, 0.00000, -0.00000>
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
    }
    smooth_triangle {
      <-3.05000, 0.00000, 0.00000> <-1.00000, 0.00000, -0.00000>
      <-2.81783, 1.16718, 0.00000> <-0.92388, 0.38268, -0.00000>
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
    }
    smooth_triangle {
      <-2.81783, 1.16718, 0.00000> <-0.92388, 0.38268, -0.00000>
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
    }
    smooth_triangle {
      <-2.81783, 1.16718, 0.00000> <-0.92388, 0.38268, -0.00000>
      <-2.15668, 2.15668, 0.00000> <-0.70711, 0.70711, -0.00000>
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
    }
    smooth_triangle {
      <-2.15668, 2.15668, 0.00000> <-0.70711, 0.70711, -0.00000>
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
    }
    smooth_triangle {
      <-2.15668, 2.15668, 0.00000> <-0.70711, 0.70711, -0.00000>
      <-1.16718, 2.81783, 0.00000> <-0.38268, 0.92388, -0.00000>
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
    }
    smooth_triangle {
      <-1.16718, 2.81783, 0.00000> <-0.38268, 0.92388, -0.00000>
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
    }
    smooth_triangle {
      <-1.16718, 2.81783, 0.00000> <-0.38268, 0.92388, -0.00000>
      <0.00000, 3.05000, 0.00000> <0.00000, 1.00000, -0.00000>
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
    }
    smooth_triangle {
      <0.00000, 3.05000, 0.00000> <0.00000, 1.00000, -0.00000>
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
    }
    smooth_triangle {
      <0.00000, 3.05000, 0.00000> <0.00000, 1.00000, -0.00000>
      <1.16718, 2.81783, 0.00000> <0.38268, 0.92388, -0.00000>
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
    }
    smooth_triangle {
      <1.16718, 2.81783, 0.00000> <0.38268, 0.92388, -0.00000>
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
    }
    smooth_triangle {
      <1.16718, 2.81783, 0.00000> <0.38268, 0.92388, -0.00000>
      <2.15668, 2.15668, 0.00000> <0.70711, 0.70711, -0.00000>
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
    }
    smooth_triangle {
      <2.15668, 2.15668, 0.00000> <0.70711, 0.70711, -0.00000>
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
    }
    smooth_triangle {
      <2.15668, 2.15668, 0.00000> <0.70711, 0.70711, -0.00000>
      <2.81783, 1.16718, 0.00000> <0.92388, 0.38268, -0.00000>
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
    }
    smooth_triangle {
      <2.81783, 1.16718, 0.00000> <0.92388, 0.38268, -0.00000>
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
      <2.89063, -0.00000, 0.15188> <0.40914, -0.00000, 0.91247>
    }
    smooth_triangle {
      <2.81783, 1.16718, 0.00000> <0.92388, 0.38268, -0.00000>
      <3.05000, -0.00000, 0.00000> <1.00000, -0.00000, -0.00000>
      <2.89063, -0.00000, 0.15188> <0.40914, -0.00000, 0.91247>
    }
    smooth_triangle {
      <2.89063, 0.00000, 0.15188> <0.40914, 0.00000, 0.91247>
      <2.41250, 0.00000, 0.28584> <0.19241, 0.00000, 0.98131>
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
    }
    smooth_triangle {
      <2.89063, 0.00000, 0.15188> <0.40914, 0.00000, 0.91247>
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
    }
    smooth_triangle {
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
    }
    smooth_triangle {
      <2.67059, -1.10619, 0.15188> <0.37799, -0.15657, 0.91247>
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
    }
    smooth_triangle {
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
    }
    smooth_triangle {
      <2.04398, -2.04398, 0.15188> <0.28930, -0.28930, 0.91247>
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
    }
    smooth_triangle {
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
    }
    smooth_triangle {
      <1.10619, -2.67059, 0.15188> <0.15657, -0.37799, 0.91247>
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
    }
    smooth_triangle {
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
    }
    smooth_triangle {
      <-0.00000, -2.89063, 0.15188> <-0.00000, -0.40914, 0.91247>
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
    }
    smooth_triangle {
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
    }
    smooth_triangle {
      <-1.10619, -2.67059, 0.15188> <-0.15657, -0.37799, 0.91247>
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
    }
    smooth_triangle {
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
    }
    smooth_triangle {
      <-2.04398, -2.04398, 0.15188> <-0.28930, -0.28930, 0.91247>
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
    }
    smooth_triangle {
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
    }
    smooth_triangle {
      <-2.67059, -1.10619, 0.15188> <-0.37799, -0.15657, 0.91247>
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
    }
    smooth_triangle {
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
    }
    smooth_triangle {
      <-2.89063, 0.00000, 0.15188> <-0.40914, 0.00000, 0.91247>
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
    }
    smooth_triangle {
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
    }
    smooth_triangle {
      <-2.67059, 1.10619, 0.15188> <-0.37799, 0.15657, 0.91247>
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
    }
    smooth_triangle {
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
    }
    smooth_triangle {
      <-2.04398, 2.04398, 0.15188> <-0.28930, 0.28930, 0.91247>
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
    }
    smooth_triangle {
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
    }
    smooth_triangle {
      <-1.10619, 2.67059, 0.15188> <-0.15657, 0.37799, 0.91247>
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
    }
    smooth_triangle {
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
    }
    smooth_triangle {
      <0.00000, 2.89063, 0.15188> <0.00000, 0.40914, 0.91247>
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
    }
    smooth_triangle {
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
    }
    smooth_triangle {
      <1.10619, 2.67059, 0.15188> <0.15657, 0.37799, 0.91247>
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
    }
    smooth_triangle {
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
    }
    smooth_triangle {
      <2.04398, 2.04398, 0.15188> <0.28930, 0.28930, 0.91247>
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
    }
    smooth_triangle {
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
      <2.41250, -0.00000, 0.28584> <0.19241, -0.00000, 0.98131>
    }
    smooth_triangle {
      <2.67059, 1.10619, 0.15188> <0.37799, 0.15657, 0.91247>
      <2.89063, -0.00000, 0.15188> <0.40914, -0.00000, 0.91247>
      <2.41250, -0.00000, 0.28584> <0.19241, -0.00000, 0.98131>
    }
    smooth_triangle {
      <2.41250, 0.00000, 0.28584> <0.19241, 0.00000, 0.98131>
      <1.61563, 0.00000, 0.40188> <0.11128, 0.00000, 0.99379>
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
    }
    smooth_triangle {
      <2.41250, 0.00000, 0.28584> <0.19241, 0.00000, 0.98131>
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
    }
    smooth_triangle {
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
    }
    smooth_triangle {
      <2.22886, -0.92322, 0.28584> <0.17777, -0.07363, 0.98131>
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
    }
    smooth_triangle {
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
    }
    smooth_triangle {
      <1.70590, -1.70590, 0.28584> <0.13606, -0.13606, 0.98131>
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
    }
    smooth_triangle {
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
    }
    smooth_triangle {
      <0.92322, -2.22886, 0.28584> <0.07363, -0.17777, 0.98131>
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
    }
    smooth_triangle {
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
    }
    smooth_triangle {
      <-0.00000, -2.41250, 0.28584> <-0.00000, -0.19241, 0.98131>
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
    }
    smooth_triangle {
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
    }
    smooth_triangle {
      <-0.92322, -2.22886, 0.28584> <-0.07363, -0.17777, 0.98131>
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
    }
    smooth_triangle {
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
    }
    smooth_triangle {
      <-1.70590, -1.70589, 0.28584> <-0.13606, -0.13606, 0.98131>
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
    }
    smooth_triangle {
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
    }
    smooth_triangle {
      <-2.22886, -0.92322, 0.28584> <-0.17777, -0.07363, 0.98131>
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
    }
    smooth_triangle {
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
    }
    smooth_triangle {
      <-2.41250, 0.00000, 0.28584> <-0.19241, 0.00000, 0.98131>
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
    }
    smooth_triangle {
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
    }
    smooth_triangle {
      <-2.22886, 0.92322, 0.28584> <-0.17777, 0.07363, 0.98131>
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
    }
    smooth_triangle {
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
    }
    smooth_triangle {
      <-1.70589, 1.70590, 0.28584> <-0.13606, 0.13606, 0.98131>
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
    }
    smooth_triangle {
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
    }
    smooth_triangle {
      <-0.92322, 2.22886, 0.28584> <-0.07363, 0.17777, 0.98131>
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
    }
    smooth_triangle {
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
    }
    smooth_triangle {
      <0.00000, 2.41250, 0.28584> <0.00000, 0.19241, 0.98131>
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
    }
    smooth_triangle {
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
    }
    smooth_triangle {
      <0.92322, 2.22886, 0.28584> <0.07363, 0.17777, 0.98131>
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
    }
    smooth_triangle {
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
    }
    smooth_triangle {
      <1.70590, 1.70589, 0.28584> <0.13606, 0.13606, 0.98131>
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
    }
    smooth_triangle {
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
      <1.61563, -0.00000, 0.40188> <0.11128, -0.00000, 0.99379>
    }
    smooth_triangle {
      <2.22886, 0.92322, 0.28584> <0.17777, 0.07363, 0.98131>
      <2.41250, -0.00000, 0.28584> <0.19241, -0.00000, 0.98131>
      <1.61563, -0.00000, 0.40188> <0.11128, -0.00000, 0.99379>
    }
    smooth_triangle {
      <1.61563, 0.00000, 0.40188> <0.11128, 0.00000, 0.99379>
      <0.50000, 0.00000, 0.50000> <0.06976, 0.00000, 0.99756>
      <0.46194, -0.19134, 0.50000> <0.06445, -0.02669, 0.99756>
    }
    smooth_triangle {
      <1.61563, 0.00000, 0.40188> <0.11128, 0.00000, 0.99379>
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
      <0.46194, -0.19134, 0.50000> <0.06445, -0.02669, 0.99756>
    }
    smooth_triangle {
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
      <0.46194, -0.19134, 0.50000> <0.06445, -0.02669, 0.99756>
      <0.35355, -0.35355, 0.50000> <0.04933, -0.04933, 0.99756>
    }
    smooth_triangle {
      <1.49264, -0.61827, 0.40188> <0.10281, -0.04259, 0.99379>
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
      <0.35355, -0.35355, 0.50000> <0.04933, -0.04933, 0.99756>
    }
    smooth_triangle {
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
      <0.35355, -0.35355, 0.50000> <0.04933, -0.04933, 0.99756>
      <0.19134, -0.46194, 0.50000> <0.02669, -0.06445, 0.99756>
    }
    smooth_triangle {
      <1.14242, -1.14242, 0.40188> <0.07869, -0.07869, 0.99379>
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
      <0.19134, -0.46194, 0.50000> <0.02669, -0.06445, 0.99756>
    }
    smooth_triangle {
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
      <0.19134, -0.46194, 0.50000> <0.02669, -0.06445, 0.99756>
      <-0.00000, -0.50000, 0.50000> <-0.00000, -0.06976, 0.99756>
    }
    smooth_triangle {
      <0.61827, -1.49264, 0.40188> <0.04259, -0.10281, 0.99379>
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
      <-0.00000, -0.50000, 0.50000> <-0.00000, -0.06976, 0.99756>
    }
    smooth_triangle {
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
      <-0.00000, -0.50000, 0.50000> <-0.00000, -0.06976, 0.99756>
      <-0.19134, -0.46194, 0.50000> <-0.02669, -0.06445, 0.99756>
    }
    smooth_triangle {
      <-0.00000, -1.61563, 0.40188> <-0.00000, -0.11128, 0.99379>
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
      <-0.19134, -0.46194, 0.50000> <-0.02669, -0.06445, 0.99756>
    }
    smooth_triangle {
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
      <-0.19134, -0.46194, 0.50000> <-0.02669, -0.06445, 0.99756>
      <-0.35355, -0.35355, 0.50000> <-0.04933, -0.04933, 0.99756>
    }
    smooth_triangle {
      <-0.61827, -1.49264, 0.40188> <-0.04259, -0.10281, 0.99379>
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
      <-0.35355, -0.35355, 0.50000> <-0.04933, -0.04933, 0.99756>
    }
    smooth_triangle {
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
      <-0.35355, -0.35355, 0.50000> <-0.04933, -0.04933, 0.99756>
      <-0.46194, -0.19134, 0.50000> <-0.06445, -0.02669, 0.99756>
    }
    smooth_triangle {
      <-1.14242, -1.14242, 0.40188> <-0.07869, -0.07869, 0.99379>
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
      <-0.46194, -0.19134, 0.50000> <-0.06445, -0.02669, 0.99756>
    }
    smooth_triangle {
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
      <-0.46194, -0.19134, 0.50000> <-0.06445, -0.02669, 0.99756>
      <-0.50000, 0.00000, 0.50000> <-0.06976, 0.00000, 0.99756>
    }
    smooth_triangle {
      <-1.49264, -0.61827, 0.40188> <-0.10281, -0.04259, 0.99379>
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
      <-0.50000, 0.00000, 0.50000> <-0.06976, 0.00000, 0.99756>
    }
    smooth_triangle {
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
      <-0.50000, 0.00000, 0.50000> <-0.06976, 0.00000, 0.99756>
      <-0.46194, 0.19134, 0.50000> <-0.06445, 0.02669, 0.99756>
    }
    smooth_triangle {
      <-1.61563, 0.00000, 0.40188> <-0.11128, 0.00000, 0.99379>
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
      <-0.46194, 0.19134, 0.50000> <-0.06445, 0.02669, 0.99756>
    }
    smooth_triangle {
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
      <-0.46194, 0.19134, 0.50000> <-0.06445, 0.02669, 0.99756>
      <-0.35355, 0.35355, 0.50000> <-0.04933, 0.04933, 0.99756>
    }
    smooth_triangle {
      <-1.49264, 0.61827, 0.40188> <-0.10281, 0.04259, 0.99379>
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
      <-0.35355, 0.35355, 0.50000> <-0.04933, 0.04933, 0.99756>
    }
    smooth_triangle {
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
      <-0.35355, 0.35355, 0.50000> <-0.04933, 0.04933, 0.99756>
      <-0.19134, 0.46194, 0.50000> <-0.02669, 0.06445, 0.99756>
    }
    smooth_triangle {
      <-1.14242, 1.14242, 0.40188> <-0.07869, 0.07869, 0.99379>
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
      <-0.19134, 0.46194, 0.50000> <-0.02669, 0.06445, 0.99756>
    }
    smooth_triangle {
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
      <-0.19134, 0.46194, 0.50000> <-0.02669, 0.06445, 0.99756>
      <0.00000, 0.50000, 0.50000> <0.00000, 0.06976, 0.99756>
    }
    smooth_triangle {
      <-0.61827, 1.49264, 0.40188> <-0.04259, 0.10281, 0.99379>
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
      <0.00000, 0.50000, 0.50000> <0.00000, 0.06976, 0.99756>
    }
    smooth_triangle {
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
      <0.00000, 0.50000, 0.50000> <0.00000, 0.06976, 0.99756>
      <0.19134, 0.46194, 0.50000> <0.02669, 0.06445, 0.99756>
    }
    smooth_triangle {
      <0.00000, 1.61563, 0.40188> <0.00000, 0.11128, 0.99379>
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
      <0.19134, 0.46194, 0.50000> <0.02669, 0.06445, 0.99756>
    }
    smooth_triangle {
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
      <0.19134, 0.46194, 0.50000> <0.02669, 0.06445, 0.99756>
      <0.35355, 0.35355, 0.50000> <0.04933, 0.04933, 0.99756>
    }
    smooth_triangle {
      <0.61827, 1.49264, 0.40188> <0.04259, 0.10281, 0.99379>
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
      <0.35355, 0.35355, 0.50000> <0.04933, 0.04933, 0.99756>
    }
    smooth_triangle {
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
      <0.35355, 0.35355, 0.50000> <0.04933, 0.04933, 0.99756>
      <0.46194, 0.19134, 0.50000> <0.06445, 0.02669, 0.99756>
    }
    smooth_triangle {
      <1.14242, 1.14242, 0.40188> <0.07869, 0.07869, 0.99379>
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
      <0.46194, 0.19134, 0.50000> <0.06445, 0.02669, 0.99756>
    }
    smooth_triangle {
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
      <0.46194, 0.19134, 0.50000> <0.06445, 0.02669, 0.99756>
      <0.50000, -0.00000, 0.50000> <0.06976, -0.00000, 0.99756>
    }
    smooth_triangle {
      <1.49264, 0.61827, 0.40188> <0.10281, 0.04259, 0.99379>
      <1.61563, -0.00000, 0.40188> <0.11128, -0.00000, 0.99379>
      <0.50000, -0.00000, 0.50000> <0.06976, -0.00000, 0.99756>
    }
  // Segment 3
    smooth_triangle {
      <0.50000, 0.00000, 0.50000> <-0.27564, 0.00000, 0.96126>
      <0.46875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.50000, 0.00000, 0.50000> <-0.27564, 0.00000, 0.96126>
      <0.46194, -0.19134, 0.50000> <-0.25466, 0.10548, 0.96126>
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46194, -0.19134, 0.50000> <-0.25466, 0.10548, 0.96126>
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46194, -0.19134, 0.50000> <-0.25466, 0.10548, 0.96126>
      <0.35355, -0.35355, 0.50000> <-0.19491, 0.19491, 0.96126>
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.35355, -0.35355, 0.50000> <-0.19491, 0.19491, 0.96126>
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.35355, -0.35355, 0.50000> <-0.19491, 0.19491, 0.96126>
      <0.19134, -0.46194, 0.50000> <-0.10548, 0.25466, 0.96126>
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.19134, -0.46194, 0.50000> <-0.10548, 0.25466, 0.96126>
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.19134, -0.46194, 0.50000> <-0.10548, 0.25466, 0.96126>
      <-0.00000, -0.50000, 0.50000> <0.00000, 0.27564, 0.96126>
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.50000, 0.50000> <0.00000, 0.27564, 0.96126>
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.50000, 0.50000> <0.00000, 0.27564, 0.96126>
      <-0.19134, -0.46194, 0.50000> <0.10548, 0.25466, 0.96126>
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.19134, -0.46194, 0.50000> <0.10548, 0.25466, 0.96126>
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.19134, -0.46194, 0.50000> <0.10548, 0.25466, 0.96126>
      <-0.35355, -0.35355, 0.50000> <0.19491, 0.19491, 0.96126>
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.35355, -0.35355, 0.50000> <0.19491, 0.19491, 0.96126>
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.35355, -0.35355, 0.50000> <0.19491, 0.19491, 0.96126>
      <-0.46194, -0.19134, 0.50000> <0.25466, 0.10548, 0.96126>
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46194, -0.19134, 0.50000> <0.25466, 0.10548, 0.96126>
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46194, -0.19134, 0.50000> <0.25466, 0.10548, 0.96126>
      <-0.50000, 0.00000, 0.50000> <0.27564, -0.00000, 0.96126>
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.50000, 0.00000, 0.50000> <0.27564, -0.00000, 0.96126>
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.50000, 0.00000, 0.50000> <0.27564, -0.00000, 0.96126>
      <-0.46194, 0.19134, 0.50000> <0.25466, -0.10548, 0.96126>
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46194, 0.19134, 0.50000> <0.25466, -0.10548, 0.96126>
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46194, 0.19134, 0.50000> <0.25466, -0.10548, 0.96126>
      <-0.35355, 0.35355, 0.50000> <0.19491, -0.19491, 0.96126>
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.35355, 0.35355, 0.50000> <0.19491, -0.19491, 0.96126>
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.35355, 0.35355, 0.50000> <0.19491, -0.19491, 0.96126>
      <-0.19134, 0.46194, 0.50000> <0.10548, -0.25466, 0.96126>
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.19134, 0.46194, 0.50000> <0.10548, -0.25466, 0.96126>
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.19134, 0.46194, 0.50000> <0.10548, -0.25466, 0.96126>
      <0.00000, 0.50000, 0.50000> <-0.00000, -0.27564, 0.96126>
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.50000, 0.50000> <-0.00000, -0.27564, 0.96126>
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.50000, 0.50000> <-0.00000, -0.27564, 0.96126>
      <0.19134, 0.46194, 0.50000> <-0.10548, -0.25466, 0.96126>
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.19134, 0.46194, 0.50000> <-0.10548, -0.25466, 0.96126>
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.19134, 0.46194, 0.50000> <-0.10548, -0.25466, 0.96126>
      <0.35355, 0.35355, 0.50000> <-0.19491, -0.19491, 0.96126>
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.35355, 0.35355, 0.50000> <-0.19491, -0.19491, 0.96126>
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.35355, 0.35355, 0.50000> <-0.19491, -0.19491, 0.96126>
      <0.46194, 0.19134, 0.50000> <-0.25466, -0.10548, 0.96126>
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46194, 0.19134, 0.50000> <-0.25466, -0.10548, 0.96126>
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.46875, -0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46194, 0.19134, 0.50000> <-0.25466, -0.10548, 0.96126>
      <0.50000, -0.00000, 0.50000> <-0.27564, 0.00000, 0.96126>
      <0.46875, -0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.46875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.43307, -0.17938, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.33146, -0.33146, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.17938, -0.43307, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.46875, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.17938, -0.43307, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.33146, -0.33146, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.43307, -0.17938, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.46875, 0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.43307, 0.17938, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.33146, 0.33146, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.17938, 0.43307, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.46875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.17938, 0.43307, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.33146, 0.33146, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.37500, -0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.43307, 0.17938, 0.50000> <-0.00000, -0.00000, 1.00000>
      <0.46875, -0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.37500, -0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.21875, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, -0.08371, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, -0.08371, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, -0.08371, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.15468, -0.15468, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, -0.15468, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, -0.15468, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.08371, -0.20210, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, -0.20210, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, -0.20210, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.00000, -0.21875, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.21875, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.00000, -0.21875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.08371, -0.20210, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.08371, -0.20210, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.08371, -0.20210, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.15468, -0.15468, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.14351, -0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.15468, -0.15468, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.15468, -0.15468, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.20210, -0.08371, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.26517, -0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.20210, -0.08371, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.20210, -0.08371, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.21875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.34645, -0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.21875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.21875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.20210, 0.08371, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.37500, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.20210, 0.08371, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.20210, 0.08371, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.15468, 0.15468, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.15468, 0.15468, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.15468, 0.15468, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.08371, 0.20210, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.08371, 0.20210, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <-0.08371, 0.20210, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.00000, 0.21875, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.21875, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.21875, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, 0.20210, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.37500, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, 0.20210, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, 0.20210, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, 0.15468, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.14351, 0.34645, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, 0.15468, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, 0.15468, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, 0.08371, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.26517, 0.26517, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, 0.08371, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, 0.08371, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.21875, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.34645, 0.14351, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.37500, -0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.21875, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.21875, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, -0.08371, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.20210, -0.08371, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.00000, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.15468, -0.15468, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.15468, -0.15468, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.00000, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.08371, -0.20210, 0.50000> <0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <0.08371, -0.20210, 0.50000> <0.00000, -0.00000, 1.00000>
      <0.00000, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
      <-0.00000, -0.21875, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.00000, -0.21875, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.00000, -0.00000, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.08371, -0.20210, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.08371, -0.20210, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.00000, -0.00000, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.15468, -0.15468, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.15468, -0.15468, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.00000, -0.00000, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.20210, -0.08371, 0.50000> <-0.00000, -0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.20210, -0.08371, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.00000, -0.00000, 0.50000> <-0.00000, -0.00000, 1.00000>
      <-0.21875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.21875, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.20210, 0.08371, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.20210, 0.08371, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.15468, 0.15468, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.15468, 0.15468, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.08371, 0.20210, 0.50000> <-0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <-0.08371, 0.20210, 0.50000> <-0.00000, 0.00000, 1.00000>
      <-0.00000, 0.00000, 0.50000> <-0.00000, 0.00000, 1.00000>
      <0.00000, 0.21875, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.00000, 0.21875, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.08371, 0.20210, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.08371, 0.20210, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.15468, 0.15468, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.15468, 0.15468, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.20210, 0.08371, 0.50000> <0.00000, 0.00000, 1.00000>
    }
    smooth_triangle {
      <0.20210, 0.08371, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.00000, 0.00000, 0.50000> <0.00000, 0.00000, 1.00000>
      <0.21875, -0.00000, 0.50000> <0.00000, -0.00000, 1.00000>
    }
  // Segment 4
  }
  scale <0.50000, 0.50000, 1.000000>
  texture{ Bronze_Texture}
}

#declare support = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.100000, 0.100000, 1.000000>
  translate <0.000000, 0.000000, 0.100000>
  texture{ Bronze_Texture}
}

union {   // wholeglobe
  object { globeinholder }
  object { globebase }
  object { support }

  translate <-2,2,0>
}




#include "knife.pov"
