//  Persistance of Vision Raytracer V2.0
//  World definition file.
//
//  Contains 2 lights, 5 textures and 88 primitives.
//
//  This file was generated for POV-Ray V2.0 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 06/06/1995    (06.06.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
//#include "enviro.inc"

camera {  //  Camera StdCam
  location  <18.0, -22.5, 12.0>
  direction <0.0,     0.0,  2.3>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <3.579, 3.713, 2.000>
}

// *******  L I G H T S *******
//light_source {   // Light1
//  <3.166, -8.678, 10.318>
//  color rgb <1.000, 1.000, 1.000>
//}

//light_source {   // Light2
//  <-7.796, 1.436, 5.550>
//  color rgb <0.667, 0.667, 0.667>
//}

light_source {
  <0, -30, 18> color White

  area_light x,z, 5, 5
  adaptive 1
  jitter
}


//
// ********  T E X T U R E S  *******
//

#include "CALC.INC"

// ********  O B J E C T S *******
#declare but_1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.139000, 0.102000, 0.115000>
}

#declare but_2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.139000, 0.117000, 0.100000>
}

#declare but_3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.154000, 0.102000, 0.100000>
}

#declare but_c2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.278000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.139000, -0.102000, 0.100000>
}

#declare but_c1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.278000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.139000, 0.102000, 0.100000>
}

#declare but_base_s = union {
  object { but_1 }
  object { but_2 }
  object { but_3 }
  object { but_c2 }
  object { but_c1 }
}

#declare but_c3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s1 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s3 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_1 = union {
  object { but_c3 }
  object { but_c5 }
  object { but_c7 }
  object { but_s1 }
  object { but_s3 }
  translate <-0.139000, 0.000000, 0.000000>
}

#declare but_c4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s2 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s4 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_2 = union {
  object { but_c4 }
  object { but_c6 }
  object { but_c8 }
  object { but_s2 }
  object { but_s4 }
  translate <0.139000, 0.000000, 0.000000>
}

#declare button_s = union {
  object { but_base_s }
  object { but_side_1 }
  object { but_side_2 }
//  texture {
//    Texture01
//  }
  rotate <8.000000, -0.000000, -0.000000>
  translate <0.154, 0.117, -0.045000>
}

//plane {   // Plane001
//  z,0
//  texture {
//    DMFLightOak
//    scale 3
//    rotate x*90
//    rotate z*60
//    translate z*-2
//  }
//}

box {
  <-7, -18, -2>, <18, 18, 0>
  texture {
    DMFLightOak
    scale 3
    rotate x*90
    translate z*2
  }
//  finish {ambient 1.0}
  rotate z*110
}

plane {
  x,21
  pigment { color Gray95 }
  normal  { bumps 0.2 scale 0.2 }

  rotate z*110
//  clipped_by {box { <-60, -60, -3>, <60, 60, 20> } }
}

#declare but_7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.189000, 0.102000, 0.115000>
}

#declare but_8 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.189000, 0.117000, 0.100000>
}

#declare but_9 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.204000, 0.102000, 0.100000>
}

#declare but_c14 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.378000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.189000, -0.102000, 0.100000>
}

#declare but_c15 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.378000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.189000, 0.102000, 0.100000>
}

#declare but_base_m = union {
  object { but_7 }
  object { but_8 }
  object { but_9 }
  object { but_c14 }
  object { but_c15 }
}

#declare but_c9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s5 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s6 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_3 = union {
  object { but_c9 }
  object { but_c10 }
  object { but_c11 }
  object { but_s5 }
  object { but_s6 }
  translate <0.189000, 0.000000, 0.000000>
}

#declare but_c16 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c17 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c18 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s7 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s8 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_4 = union {
  object { but_c16 }
  object { but_c17 }
  object { but_c18 }
  object { but_s7 }
  object { but_s8 }
  translate <-0.189000, 0.000000, 0.000000>
}

#declare button_m = union {
  object { but_base_m }
  object { but_side_3 }
  object { but_side_4 }
//  texture {
//   Texture01
//  }
  rotate <8.000000, -0.000000, -0.000000>
  translate <0.204, 0.117, -0.045000>
}

#declare but_4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.370000, 0.102000, 0.115000>
}

#declare but_5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.370000, 0.117000, 0.100000>
}

#declare but_6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.385000, 0.102000, 0.100000>
}

#declare but_c12 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.740000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.370000, -0.102000, 0.100000>
}

#declare but_c13 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.740000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <0.370000, 0.102000, 0.100000>
}

#declare but_base_L = union {
  object { but_4 }
  object { but_5 }
  object { but_6 }
  object { but_c12 }
  object { but_c13 }
}

#declare but_c19 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c20 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c21 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s9 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s10 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_5 = union {
  object { but_c19 }
  object { but_c20 }
  object { but_c21 }
  object { but_s9 }
  object { but_s10 }
  translate <0.370000, 0.000000, 0.000000>
}

#declare but_c22 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.204000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_c23 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, 0.102000, -0.100000>
}

#declare but_c24 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.015000, 0.015000, 0.200000>
  translate <0.000000, -0.102000, -0.100000>
}

#declare but_s11 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, -0.102000, 0.100000>
}

#declare but_s12 = object { 
  sphere {<0,0,0>,1}
  scale <0.015000, 0.015000, 0.015000>
  translate <0.000000, 0.102000, 0.100000>
}

#declare but_side_6 = union {
  object { but_c22 }
  object { but_c23 }
  object { but_c24 }
  object { but_s11 }
  object { but_s12 }
  translate <-0.370000, 0.000000, 0.000000>
}

#declare button_l = union {
  object { but_base_L }
  object { but_side_5 }
  object { but_side_6 }
//  texture {
//    Texture01
//  }
  rotate <8.000000, -0.000000, -0.000000>
  translate <0.385, 0.117, -0.045000>
}

#declare calc_base_1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.214000, 0.238000, 5.522000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.214000, 0.214000, 0.238000>
}

#declare calc_base_2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.214000, 0.238000, 5.522000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <2.928000, 0.214000, 0.238000>
}

#declare calc_base_3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.238000, 0.214000, 2.714000>
  rotate <-0.000000, 90.000000, -0.000000>
  translate <0.214000, 0.214000, 0.238000>
}

#declare calc_base_s1 = object { 
  sphere {<0,0,0>,1}
  scale <0.214000, 0.214000, 0.238000>
  translate <0.214000, 0.214000, 0.238000>
}

#declare calc_base_s2 = object { 
  sphere {<0,0,0>,1}
  scale <0.214000, 0.214000, 0.238000>
  translate <2.928000, 0.214000, 0.238000>
}

#declare calc_base_s3 = object { 
  sphere {<0,0,0>,1}
  scale <0.214000, 0.080000, 0.238000>
  translate <0.214000, 5.736000, 0.238000>
}

#declare calc_base_s4 = object { 
  sphere {<0,0,0>,1}
  scale <0.214000, 0.080000, 0.238000>
  translate <2.928000, 5.736000, 0.238000>
}

#declare calc_base_r1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.571000, 2.908000, 0.090000>
  translate <1.571000, 2.908000, 0.328000>
}

#declare calc_base_bot = union {
  object { calc_base_1 }
  object { calc_base_2 }
  object { calc_base_3 }
  object { calc_base_s1 }
  object { calc_base_s2 }
  object { calc_base_s3 }
  object { calc_base_s4 }
  object { calc_base_r1 }
}

#declare cbb_clip1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.571000, 3.000000, 1.000000>
  rotate <1.750000, -0.000000, -0.000000>
  translate <1.571000, 3.029000, -0.670000>
}

#declare calc_bot = intersection {
  object { calc_base_bot }
  object { cbb_clip1 }
  texture {
    Texture01
  }
}

#declare topf_bnd = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <1.571000, 2.908000, 0.054000>
  translate <1.571000, 2.908000, 0.054000>
}

#declare calc_topf_1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.511000, 2.771000, 0.054000>
  translate <1.571000, 2.985000, 0.054000>
}

#declare calc_topf_2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.511000, 2.801000, 0.054000>
  translate <1.571000, 3.015000, 0.054000>
}

#declare calc_topf_c1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.214000, 0.214000, 0.048000>
  translate <0.214000, 0.214000, 0.000000>
}

#declare calc_topf_c2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.214000, 0.214000, 0.048000>
  translate <2.928000, 0.214000, 0.000000>
}

#declare calc_topf_c3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 0.048000>
  translate <0.060000, 5.756000, 0.000000>
}

#declare calc_topf_c4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 0.048000>
  translate <3.082000, 5.756000, 0.000000>
}

#declare calc_topf_c5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 5.542000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <0.060000, 0.214000, 0.048000>
}

#declare calc_topf_c6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 5.542000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <3.082000, 0.214000, 0.048000>
}

#declare calc_topf_c7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 2.714000>
  rotate <-0.000000, 90.000000, -0.000000>
  translate <0.214000, 0.060000, 0.048000>
}

#declare calc_topf_c8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.060000, 0.060000, 3.022000>
  rotate <-0.000000, 90.000000, -0.000000>
  translate <0.060000, 5.756000, 0.048000>
}

#declare topf_s3 = object { 
  sphere {<0,0,0>,1}
  scale <0.060000, 0.060000, 0.060000>
  translate <0.060000, 5.756000, 0.048000>
}

#declare topf_s4 = object { 
  sphere {<0,0,0>,1}
  scale <0.060000, 0.060000, 0.060000>
  translate <3.082000, 5.756000, 0.048000>
}

#declare topf_3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.357000, 0.077000, 0.054000>
  translate <1.571000, 0.137000, 0.054000>
}

#declare topf_c9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.154000, 0.154000, 0.108000>
  translate <0.214000, 0.214000, 0.000000>
}

#declare topf_c10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.154000, 0.154000, 0.108000>
  translate <2.928000, 0.214000, 0.000000>
}

#declare topf_t1 = torus { 
  0.154, 0.060  // Major, minor radius
  rotate -x*90
  translate <0.214000, 0.214000, 0.048000>
}

#declare topf_t2 = torus { 
  0.154, 0.060  // Major, minor radius
  rotate -x*90
  translate <2.928000, 0.214000, 0.048000>
}

#declare topf_4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.357000, 0.214000, 0.024000>
  translate <1.571000, 0.214000, 0.024000>
}

#declare topf_base_raw = union {
  object { calc_topf_1 }
  object { calc_topf_2 }
  object { calc_topf_c1 }
  object { calc_topf_c2 }
  object { calc_topf_c3 }
  object { calc_topf_c4 }
  object { calc_topf_c5 }
  object { calc_topf_c6 }
  object { calc_topf_c7 }
  object { calc_topf_c8 }
  object { topf_s3 }
  object { topf_s4 }
  object { topf_3 }
  object { topf_c9 }
  object { topf_c10 }
  object { topf_t1 }
  object { topf_t2 }
  object { topf_4 }
}

#declare topf_x_2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.319000, 0.064000, 0.200000>
  translate <1.571000, 5.150000, 0.000000>
}

#declare topf_x_3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.271000, 0.088000, 0.200000>
  translate <1.571000, 0.264000, 0.000000>
}

#declare topf_x_c1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.156000, 0.156000, 0.400000>
  translate <0.300000, 0.332000, -0.200000>
}

#declare topf_x_c2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.156000, 0.156000, 0.400000>
  translate <2.842000, 0.332000, -0.200000>
}

#declare topf_x_c3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.108000, 0.108000, 0.400000>
  translate <0.252000, 5.106000, -0.200000>
}

#declare topf_x_c4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <0.108000, 0.108000, 0.400000>
  translate <2.890000, 5.106000, -0.200000>
}

#declare topf_x_logo = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.506000, 0.133000, 0.200000>
  translate <0.794000, 5.463000, 0.000000>
}

#declare topf_x_1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.427000, 2.387000, 0.200000>
  translate <1.571000, 2.719000, 0.000000>
}

#declare topf_holes = union {
  object { topf_x_2 }
  object { topf_x_3 }
  object { topf_x_c1 }
  object { topf_x_c2 }
  object { topf_x_c3 }
  object { topf_x_c4 }
  object { topf_x_logo }
  object { topf_x_1 }
}

#declare topf_base = difference {
  object { topf_base_raw }
  object { topf_holes }
}

#declare topf_bound = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.571000, 2.908000, 0.050000>
  translate <1.571000, 2.908000, -0.050000>
}

#declare calc_topf = difference {
  object { topf_base }
  object { topf_bound }
  texture {
    Texture01
  }
  bounded_by { topf_bnd }
}

#declare calc_label = object {   // label
  height_field {
    gif "hp_label.gif" 
    water_level 0.000000
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin

  texture {
    tiles {
      texture {Chrome_Metal}
    tile2
      texture {pigment {Gray20} }
    }
    scale <2, 2, 1>
    translate <-1, -1, -0.2>
  }

  scale <0.506000, 0.133000, 0.025000>
  translate <0.794000, 5.463000, 0.075000>
}

#declare wind_1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.427000, 0.849000, 0.050000>
  translate <1.571000, 4.365000, 0.050000>
}

#declare wind_x_1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.316000, 0.500000, 0.020000>
  translate <1.571000, 4.272000, 0.100000>
}

#declare wind_x_3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.230000, 0.335000, 0.200000>
  translate <1.571000, 4.283000, 0.000000>
}

#declare wind_face_base = difference {
  object { wind_1 }
  object { wind_x_1 }
  object { wind_x_3 }
//  texture {
//    lt_face_col
//  }
  texture {
    tiles {
      texture {pigment { Gray30 } }
    tile2
      texture { lt_face_col }
    }
    scale <6, 6, 1>
    translate 0.099*z
  }
}

#declare wind_2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    wind_face
  }
  scale <1.230000, 0.335000, 0.001000>
  translate <1.571000, 4.283000, 0.001000>
}

#declare calc_wind = union {
  object { wind_face_base }
  object { wind_2 }
}

#declare key_base = box {   // key_base
  <-1, -1, -1>, <1, 1, 1>
//  texture {
//    lt_face_col
//  }
  scale <1.427000, 1.670000, 0.027000>
  translate <1.427000, 1.670000, 0>
}

#declare calc_buts = union {
  object { key_base }
  object { button_s translate <0.105, 2.980, 0> }       // row 1, col 1
  object { button_s translate <0.565, 2.980, 0> }       // row 1, col 2
  object { button_s translate <1.035, 2.980, 0> }       // row 1, col 3
  object { button_s translate <1.495, 2.980, 0> }       // row 1, col 4
  object { button_s translate <1.960, 2.980, 0> }       // row 1, col 5
  object { button_s translate <2.425, 2.980, 0> }       // row 1, col 6

  object { button_s translate <0.105, 2.520, 0> }       // row 2, col 1
  object { button_s translate <0.565, 2.520, 0> }       // row 2, col 2
  object { button_s translate <1.035, 2.520, 0> }       // row 2, col 3
  object { button_s translate <1.495, 2.520, 0> }       // row 2, col 4
  object { button_s translate <1.960, 2.520, 0> }       // row 2, col 5
  object { button_s translate <2.425, 2.520, 0> }       // row 2, col 6

  object { button_l translate <0.105, 2.060, 0> }       // row 3, col 1
  object { button_s translate <1.035, 2.060, 0> }       // row 3, col 2
  object { button_s translate <1.495, 2.060, 0> }       // row 3, col 3
  object { button_s translate <1.960, 2.060, 0> }       // row 3, col 4
  object { button_s translate <2.425, 2.060, 0> }       // row 3, col 5

  object { button_s translate <0.105, 1.600, 0> }       // row 4, col 1
  object { button_m translate <0.630, 1.600, 0> }       // row 4, col 2
  object { button_m translate <1.200, 1.600, 0> }       // row 4, col 3
  object { button_m translate <1.760, 1.600, 0> }       // row 4, col 4
  object { button_m translate <2.320, 1.600, 0> }       // row 4, col 5

  object { button_s translate <0.105, 1.140, 0> }       // row 4, col 1
  object { button_m translate <0.630, 1.140, 0> }       // row 4, col 2
  object { button_m translate <1.200, 1.140, 0> }       // row 4, col 3
  object { button_m translate <1.760, 1.140, 0> }       // row 4, col 4
  object { button_m translate <2.320, 1.140, 0> }       // row 4, col 5

  object { button_s translate <0.105, 0.680, 0> }       // row 4, col 1
  object { button_m translate <0.630, 0.680, 0> }       // row 4, col 2
  object { button_m translate <1.200, 0.680, 0> }       // row 4, col 3
  object { button_m translate <1.760, 0.680, 0> }       // row 4, col 4
  object { button_m translate <2.320, 0.680, 0> }       // row 4, col 5

  object { button_s translate <0.105, 0.215, 0> }       // row 4, col 1
  object { button_m translate <0.630, 0.215, 0> }       // row 4, col 2
  object { button_m translate <1.200, 0.215, 0> }       // row 4, col 3
  object { button_m translate <1.760, 0.215, 0> }       // row 4, col 4
  object { button_m translate <2.320, 0.215, 0> }       // row 4, col 5

  texture {
    material_map {
      gif "hp_buttn.gif"
      texture {pigment {White} }
      texture {pigment {White} }
      texture {pigment {Gray30} }
      texture {pigment {Gray30} }
      texture {pigment {Orange} }
      texture {pigment {Orange} }
      texture {lt_face_col}
      texture {lt_face_col}
      texture {pigment {Black} }
      texture {pigment {Black} }
      texture {pigment {Black} }
    }
    scale <2.854, 3.340, 1>
    translate <0, -0.003, 0>
  }
  translate <0.144, 0.176, 0.027>
}

#declare calc_top = union {
  object { calc_topf }
  object { calc_label }
  object { calc_wind }
  object { calc_buts }
  rotate x*1.75
  translate z*.248
}

#declare calculator = union {
  object { calc_top }
  object { calc_bot }
  bounded_by { box { <0, 0, 0>, <4, 6, 1> } }
}

object {
  calculator

  rotate z*15
  translate <-1, -3, 0>
}

box {
  <0, 0, 0>, <1, 1, 0.002>

  pigment {
    image_map {
      gif "paper.gif"
    }
  }
  finish {ambient 0.35}

  scale <8.64, 10.40, 1>
  rotate z*40
  translate <7, -2, 0>
}

/////////////////////////////////////////////////////////

#include "pencil.pov"

object {
  pencil
  translate <7, -2, 0>
  rotate z*60
  translate <4,-4.3,0>
}

#include "abacus.pov"

object {
  abacus
  rotate z*30
  translate <-3, 12, 0>
}

//box {
//  <-5.5, -0.5, 0>, <5.5, 0.5, 6>
//  pigment {Red}
//  rotate z*30
//  translate <-3, 12, 0>
//}
