#declare FramePiece1 =
difference {
  cylinder { <0,-6,0>,<0,6,0>,.4 }
  box { <-3,-6,-3>,<3,0,3> rotate -45*z translate <.4,-6,0> }
  box { <-3,0,-3>,<3,6,3> rotate 45*z translate <.4,6,0> }
}

#declare FramePiece2 =
difference {
  cylinder { <0,-8,0>,<0,8,0>,.4 }
  box { <-3,-6,-3>,<3,0,3> rotate -45*z translate <.4,-8,0> }
  box { <-3,0,-3>,<3,6,3> rotate 45*z translate <.4,8,0> }
}

#declare Frame =
union {
  object { FramePiece1 translate 7.6*x }
  object { FramePiece1 translate 7.6*x scale <-1,1,1> }
  object { FramePiece2 rotate 90*z translate 5.6*y }
  object { FramePiece2 rotate -90*z translate -5.6*y }
  pigment {
    wood color_map {
      [0 color rgb<.888,.6,.3> ]
      [.8 color rgb<.6,.4,.2> ]
      [1 color rgb<.4,.3,.2> ]
    }
    turbulence .2
    scale 2
    translate 4*y
  }
  finish {
    specular .3
  }
}

#declare PAINTING =
union {
  object { Frame }
  box { <-7.6,-5.6,0>,<7.6,5.6,.1> 
    pigment {
      image_map {
        tga "pic0001.tga"
        interpolate 2
      }
      translate <-.5,-.5,0>
      scale <14.4,10.4,1>
    }
    finish { ambient .4 }
  }
  translate -.1*z
  scale 1.2
  rotate 45*y 
  translate <10.25,7,49.75>
  rotate -25*y
}
