#declare PianoShape =
union {
  box { <-5,-.125,4>,<-3,.125,12> }
  box { <-5,-.125,0>,<5,.125,4> }
  box { <-3,-.125,7>,<-1,.125,10> }
  box { <-3,-.125,4>,<2,.125,7> }
  cylinder { <2,-.125,4>,<2,.125,4>,3 }
  cylinder { <-3,-.125,10>,<-3,.125,10>,2 }
  difference {
    box { <-1,-.125,7>,<2,.125,10> }
    cylinder { <2,-1,10>,<2,1,10>,3 }
  }
}

#declare PianoShape2 =
union {
  box { <-4.75,-.125,4>,<-3,.125,11.75> }
  box { <-4.75,-.125,0>,<4.75,.125,4> }
  box { <-3,-.125,7>,<-1.25,.125,10> }
  box { <-3,-.125,4>,<2,.125,6.75> }
  cylinder { <2,-.125,4>,<2,.125,4>,2.75 }
  cylinder { <-3,-.125,10>,<-3,.125,10>,1.75 }
  difference {
    box { <-1.25,-.125,6.75>,<2,.125,10> }
    cylinder { <2,-1,10>,<2,1,10>,3.25 }
  }
}

#declare PianoLid =
object {
  PianoShape
  translate -6*z
  scale <1.05,1,1.05>
  translate 6*z
  translate 5*x
  rotate 10*z
  translate -5*x
  translate y
}

#declare PianoBody =
difference {
  object {
    PianoShape
    translate -6*z
    scale <1,8,1>
    translate 6*z
  }
  object {
    PianoShape2
    translate -6*z
    scale <1,8,1>
    translate 6*z
    translate .5*y
  }
}

#declare PianoLidStand =
box { <-.125,-4.5,-.125>,<.125,0,.125>
      rotate 20*x 
      rotate 3*z
      translate 8.5*x
      translate 2.5*z
      rotate 10*z
      translate -5*x
      translate y
}

#declare SidePiece =
union {
  box { <-.25,-1,-1.5>,<0,0,0> }
  box { <-.25,0,-.75>,<0,.5,0> }
  cylinder { <-.25,0,0>,<0,0,0>,.5
             scale <1,1,1.5>
             translate -.75*z 
  }
  difference {
    box { <-.25,.5,-.75>,<0,1,0> }
    cylinder { <-.5,0,0>,<.25,0,0>,.5
               scale <1,1,1.5>
               translate <0,1,-.75> }
  }
}

#declare PianoKeysSide =
union {
  object { 
    SidePiece
    translate 5*x
  }
  object { 
    SidePiece
    translate -4.75*x
  }
  box { <-5,-1,-1.5>,<5,0,0> }
}

#declare Leg =
box { <-.35,-5,-.35>,<0,-1,0> }

#declare PianoLegs =
union {
  object { 
    Leg
    translate <-4.3,0,.35>
  }
  object { 
    Leg
    translate <4.65,0,.35>
  }
  object { 
    Leg
    translate <-3.3,0,11>
  }
}

#declare WhiteKey =
union {
  box { <0,0,-1.3888888888888>,<.203571878571,.22222222222222,0> }
  box { <0,.22222222222222,-1.5>,<.203571878571,.33333333333333,0> }
}

#declare WhiteOctave =
union {
  object {
    WhiteKey
  }
  object {
    WhiteKey
    translate .22619097619*x
  }
  object {
    WhiteKey
    translate .45238195238*x
  }
  object {
    WhiteKey
    translate .67857292857*x
  }
  object {
    WhiteKey
    translate .90476390476*x
  }
  object {
    WhiteKey
    translate 1.13095488095*x
  }
  object {
    WhiteKey
    translate 1.35714585714*x
  }
}

#declare BlackKey =
box { <-.0753969920633,0,-.875>,<.0753969920633,.583333333333333,0> }

#declare BlackOctave =
union {
  object {
    BlackKey
    translate .22619097619*x
  }
  object {
    BlackKey
    translate .45238195238*x
  }
  object {
    BlackKey
    translate .90476390476*x
  }
  object {
    BlackKey
    translate 1.13095488095*x
  }
  object {
    BlackKey
    translate 1.35714585714*x
  }
}

#declare OneOctave =
union {
  object {
    WhiteOctave
    pigment { rgb<.8,.8,.8> }
    finish { phong 1 }
  }
  object {
    BlackOctave
    pigment { rgb<.1,.1,.1> }
    finish { phong .5 }
  }
}

#declare Keys =
union {
  object { 
    OneOctave
    translate -4.75*x
  }
  object { 
    OneOctave
    translate -3.1666666666666667*x
  }
  object { 
    OneOctave
    translate -1.5833333333333333*x
  }
  object { 
    OneOctave
  }
  object { 
    OneOctave
    translate 1.58333333333333333*x
  }
  object { 
    OneOctave
    translate 3.16666666666666667*x
  }
}

#declare Piano =
union {
  object { PianoLid }
  object { PianoLidStand }
  object { PianoBody }
  object { PianoKeysSide }
  object { PianoLegs }
  pigment { rgb<.1,.1,.1> }
  finish { specular .2 phong .6 reflection .125 }
}

#declare GrandPiano =
union {
  object { Piano }
  object { Keys }
}

#declare SeatPad = 
union {
  cylinder { <0,-2.5,0>,<0,-1.575,0>,1.175 }
  sphere { <0,0,0>,1.175 scale <1,.127659574468,1> translate -1.575*y }
  pigment { rgb<.225,.225,.225> }
}

#declare MetalRings =
union {
  torus { 1.175,.075 translate -1.575*y }
  torus { 1.175,.075 translate -2.5*y }
  pigment { rgb<.9,.91,.98> }
  finish { specular .5 phong .8 reflection .25 metallic ambient 0 }
}

#declare StoolSeat =
union {
  object { SeatPad }
  object { MetalRings }
}

#declare StoolLegs =
union {
  cylinder { <.742462120246,-2.5,.742462120246>,<.742462120246,-5,.742462120246>,.125 }
  cylinder { <-.742462120246,-2.5,.742462120246>,<-.742462120246,-5,.742462120246>,.125 }
  cylinder { <.742462120246,-2.5,-.742462120246>,<.742462120246,-5,-.742462120246>,.125 }
  cylinder { <-.742462120246,-2.5,-.742462120246>,<-.742462120246,-5,-.742462120246>,.125 }
  cylinder { <-.742462120246,-3.75,-.742462120246>,<.742462120246,-3.75,-.742462120246>,.125 }
  cylinder { <-.742462120246,-3.75,.742462120246>,<.742462120246,-3.75,.742462120246>,.125 }
  cylinder { <.742462120246,-3.75,-.742462120246>,<.742462120246,-3.75,.742462120246>,.125 }
  cylinder { <-.742462120246,-3.75,-.742462120246>,<-.742462120246,-3.75,.742462120246>,.125 }
  pigment { 
    wood color_map {
      [0 .3 color rgb<.7,.3,0> color rgb<.7,.3,0>]
      [.7 1 color rgb<.5,.2,0> color rgb<.4,.1,0>]
    }
    turbulence 0.12
    scale .25
    rotate 15*x
  }
  finish { specular .2 }
}

#declare Stool =
union {
  object { StoolSeat }
  object { StoolLegs }
  translate -4.5*z
}
