// Bob Belas textures

//  Starfield by Dan Farmer
#declare DF_Starfield =
     texture {
	 finish { ambient 1 }
	 pigment {
	     granite
	     color_map {
		 [ 0.00  0.72 color Black  color Black ]
		 [ 0.72  0.75 color Gray20 color Gray40 ]
		 [ 0.75  0.78 color Gray40 color Gray60 ]
		 [ 0.78  0.81 color Gray60 color Gray80 ]
		 [ 0.81  0.85 color Gray80 color Gray95 ]
		 [ 0.85  0.91 color Gray95 color White  ]
		 [ 0.91  1.00 color Black  color Black ]
	     }
	     scale .015
	 }
     }



//  my Rosewood
#declare Bobs_Rosewood = texture {
  //pigment { color rgb < 0.737,  0.561,  0.561> }
	Rosewood
  finish {
    ambient   0.20
    diffuse   0.50
    brilliance   1.00
    phong   0.60
    phong_size  20.00
  }
	turbulence 0.25
	octaves 4
	lambda 2
}



// Clear checker pattern
#declare Clear_Checker = texture {
   pigment {
      checker colour YellowGreen colour Clear
      quick_color White
      scale .2
      rotate <90, 0.0, -90.0>
   }
   finish {
      brilliance 8
      phong 1
      phong_size 100
   }
}

//gridline texture
#declare Wireframe =
texture {
	pigment {
		gradient x
		color_map {
			[0.1 color Red]
			[0.1 color Clear]
		}
	}
}
texture {
	pigment {
		gradient y
		color_map {
			[0.1 color Red]
			[0.1 color Clear]
		}
	}
}
texture {
	pigment {
		gradient z
		color_map {
			[0.1 color Red]
			[0.1 color Clear]
		}
	}
}

//sparking_effect
#declare Sparking_Effect =
texture {
	pigment {
		marble
		turbulence 0.5
		colour_map {
			[ 0.0 colour Clear ]
			[ 0.4 colour Clear ]
			[ 0.4 colour rgb < 0.4, 0.4, 1.0 > filter 1 ]
			[ 0.5 colour rgb < 0.9, 0.9, 1.0 > ]
			[ 0.6 colour rgb < 0.4, 0.4, 1.0 > filter 1 ]
			[ 0.6 colour Clear ]
			[ 1.0 colour Clear ]
			}
		rotate <0, 0, 90>
		}
	finish { ambient 1.0 }
}

// AmberZero
// I've been struggling with this for what seem to be ages;
// then I hit on the obvious... go back to the source!

#declare Amber0 = pigment 
{marble
turbulence 1.1
color_map 
{[0.0, 0.8   color red 0.95 green 0.72 blue 0.05 filter 0.0
color red 1.0 green 0.5 blue 0.5 filter 0.9]
[0.8, 1.0   color red 1.0 green 0.80 blue 0.80 filter 0.0
color red 1.0 green 0.65 blue 0.65 filter 0.9]}}

// Shiny Fred
// It's an odd one, kind of a mad mixture... looks really strange as
// a flattened out blob...

#declare Shiny_Fred = texture { 
pigment {
granite
turbulence 0.5
octaves 2
colour_map {
[0.0 0.2   colour red  0.45  green  0.05  blue  0.05  filter  0.0
colour red  0.80  green  0.65  blue  0.65  filter  0.0]
[0.2 0.3   colour red  0.45  green  0.65 blue  0.25  filter  0.0
colour red  0.45  green  0.75  blue  0.25  filter  0.0]
[0.3 0.4   colour red  0.60  green  0.35  blue  0.03  filter  0.0
colour red  0.45  green  0.75  blue  0.25  filter  0.0]
[0.4 0.5   colour red  0.45  green  0.33  blue  0.25  filter  0.0
colour red  0.45  green  0.05  blue  0.05  filter  0.0]
[0.5 0.6   colour red  0.80  green  0.65  blue  0.25  filter  0.0
colour red  0.45  green  0.25  blue  0.35  filter  0.0]
[0.6 0.7   colour red  0.90  green  0.90  blue  0.0  filter  0.0
colour red  0.365  green  0.765  blue  0.00  filter  0.0]
[0.7 0.8   colour red  0.78  green  0.00  blue  0.05  filter  0.0
colour red  0.08  green  0.645  blue  0.645  filter  0.0]
[0.8 0.85   colour red  0.99  green  0.09  blue  0.09  filter  0.0
colour red  0.22  green  0.09  blue  0.09  filter  0.0]
[0.85 0.9   colour red  0.79  green  0.39  blue  0.09  filter  0.0
colour red  0.22  green  0.39  blue  0.09  filter  0.0]
[0.9 0.95   colour red  0.45  green  0.55  blue  0.05  filter  0.0
colour red  0.22  green  0.22  blue  0.05  filter  0.0]
[0.95 0.97   colour red  0.55  green  0.45  blue  0.05  filter  0.0
colour red  0.22  green  0.22  blue  0.05  filter  0.0]
[0.97 0.98   colour red  0.65  green  0.0  blue  0.0  filter  0.0
colour red  0.30  green  0.0  blue  0.0  filter  0.0]
[0.98 0.99   colour red  0.533  green  0.533  blue  0.027  filter  0.0
colour red  0.22  green  0.22  blue  0.027  filter  0.0]
[0.99 1.0   colour red  0.75  green  0.75  blue  0.09  filter  0.0
colour red  0.2  green  0.2  blue  0.09  filter  0.0]
}}
scale <0.1 0.1 0.1>
translate <10 0 0>
}
texture { pigment {
granite
turbulence 0.9
colour_map {
[0.0 0.120   colour red  1.0  green  1.0  blue  1.0  filter  1.0
colour red  0.702  green  0.412  blue  0.118  filter  0.608]
[0.120 0.231   colour red  0.702  green  0.412  blue  0.118  filter  0.608
colour red  0.702  green  0.467  blue  0.118  filter  0.608]
[0.231 0.496   colour red  0.702  green  0.467  blue  0.118  filter  0.608
colour red  1.0  green  1.0  blue  1.0  filter  1.0]
[0.496 0.701   colour red  1.0  green  1.0  blue  1.0  filter  1.0
colour red  1.0  green  1.0  blue  1.0  filter  1.0]
[0.701 0.829   colour red  1.0  green  1.0  blue  1.0  filter  1.0
colour red  0.702  green  0.467  blue  0.118  filter  0.608]
[0.829 1   colour red  0.702  green  0.467  blue  0.118  filter  0.608
colour red  1.0  green  1.0  blue  1.0  filter  1.0]
}}
finish {
reflection 0.35 }
scale <0.5 0.5 0.5>
translate <10 0 0>
}

// Surface of the Sun
// A kind of sun surface texture... generates really nice cross textures
// when a light source is "popped" inside...

#declare Sol_Surface = texture { 
pigment { agate
octaves 9
colour_map {
[0.0 0.6   colour red  0.99  green  0.05  blue  0.05  filter  0.050
colour red  0.89  green  0.05  blue  0.05  filter  0.000]
[0.6 0.7   colour red  0.90  green  0.40  blue  0.05  filter  0.050
colour red  0.89  green  0.05  blue  0.05  filter  0.050]
[0.7 0.9   colour red  0.92  green  0.0  blue  0.05  filter   0.000
colour red  0.99  green  0.00  blue  0.09  filter  0.500]
[0.9 1.0   colour red  0.85  green  0.00  blue  0.00  filter  0.000
colour red  0.99  green  0.02  blue  0.00  filter  0.050]}}
finish {
brilliance 0.5
reflection 0.01
specular   1.0
roughness  0.005}}

// Black Neon
// A Filmore East, late 1960's, oil'n water sort of thing...

#declare Black_Neon = texture { 
pigment {
marble   
turbulence 2.0
colour_map {
[0.0 0.2   colour BlueViolet filter 0.8
colour NavyBlue]
[0.2 0.4   colour NeonBlue filter 0.4
colour CoolCopper]
[0.4 0.5   colour Black 
colour Gray05]
[0.5 0.6   colour Gray05 
colour Blue]
[0.6 1.0   colour BlueViolet filter 1.0 
colour DarkGreen]}}}

