/******************************************************************************

  Foucault's Pendulum - Proof of the rotation of the earth
  by Russ Jones - rjones@southwind.net

  Leon Foucault (1819-1868) became a famous man in 1851 by his pendulum
  experiment to demonstrate the Earth's rotation. It was suggested to him
  by the chance observation that a steel rod, clamped in the chuck of a lathe,
  tended to vibrate in the same plane when the lathe was slowly turned. After
  trials with a seven-foot pendulum in his own cellar and with a 36-foot one
  in the Paris Observatory, Foucault carried out a dramatic public exhibition.

  A contemporary, one C. A. Young described it thus: "From the dome of the
  Pantheon of Paris he suspended a heavy iron ball about a foot in diameter
  by a wire more than 200 feet long. A circular rail some 12 feet across,
  with a little ridge of sand on it, was placed under the pendulum in such
  a way that a pin attached to the swinging ball would just scrape the sand
  and leave a mark on each vibration. The ball was drawn aside by a cotton
  cord and allowed to come absolutely to rest; then the cord was burned, 
  and the pendulum set to swinging in a true plane; but this plane seemed
  to deviate slightly towards the right, cutting the sand in a new place at
  each swing and shifting at a rate which would carry it completely around
  in about 32 hours if the pendulum did not first come to rest. In fact,
  the floor of the Pantheon was seen turning under the plane of the
  pendulum's vibration."

  This experiment, which is today shown in many planetariums and museums
  (I've seen a Foucault's pendulum in museums in Chicago, San Diego, Denver,
  New York City, and Washington), made a sensation in 1851. Foucault was
  awarded the Cross of the Legion of Honor and, at the instigation of 
  Emperor Napoleon III, was appointed to the staff of the Paris 
  Observatory as a physicist, where he turned his attention to the 
  improvement of reflecting telescopes.

  This rendering is based both on Mr. Young's description, and from an
  engraving to be found in A. Berget's "Le Ciel," 1923.

  I have been unable to obtain any information on the dimensions of the
  Pantheon of Paris, but I rather doubt that it had a dome that extended
  to "more than 200 feet" in height. Nevertheless, I have rendered the wire
  a full 200 feet in length. It's angle of vibration is less than two
  degrees, and appears to be nearly vertical here.

********************************************************************************/

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare Ball_Metal =
texture
{
  Polished_Brass
  finish
  {
    ambient 0.4
  }
}

union
{
  // the wire
  cylinder
  {
    <0, 0, 0>
    <0, -200, 0>
    0.01
    texture {Silver_Texture finish {ambient 0.6}}
  }
  // the ball
  sphere
  {
    <0, -200, 0>
    0.5
  }
  // assorted useless Victorian decoration at the top
  torus
  {
    0.5, 0.015
    translate <0, -200, 0>
  }
  cylinder
  {
    <0, -200.51, 0>
    <0,  -199.45, 0>
    0.1
  }
  cylinder
  {
    <0, -199.49, 0>
    <0, -199.46, 0>
    0.10000001
    texture
    {
      pigment { color Black }
      finish {Phong_Shiny }
    }
  }
  cone
  {
    <0, -199.45, 0> 0.1
    <0, -199.43, 0> 0.08
  }
  sphere
  {
    <0, -199.9, 0>
    0.18
    clipped_by
    {
      cylinder
      {
        < 0, -200.1, 0>
	< 0, -199.4, 0>
	0.08
      }
    }
  }
  // and at the bottom
  cylinder
  {
    <0, -200.51, 0>
    <0, -200.52, 0>
    0.09
  }
  cylinder
  {
    <0, -200.52, 0>
    <0, -200.53, 0>
    0.08
  }
  cone
  {
    <0, -200.53, 0> 0.07
    <0, -200.75, 0> 0
  }
  // texture, rotation, etc
  texture
  {
    Ball_Metal
  }
  rotate <0, 0, 1.7>
  rotate <0, 110, 0>
  translate <0, 200, 0>
}

// first a wooden rail to keep the riff-raff out
torus
{
  7.5, 0.125
  texture
  {
    Cherry_Wood
    finish
    {
      Phong_Shiny
    }
    scale <1.2, 0.2, 1.2>
  }
  translate <0, -0.8, 0>
}    

#declare Post_1 =
union
{
  cylinder
  {
    <7.5, -0.8, 0>
    <7.5, -4,   0>
    0.1
  }
  cylinder
  {
    <7.5, -0.8, -0.2>
    <7.5, -0.8,  0.2>
    0.130
  }
  cylinder
  {
    <7.5, -0.8, 0>
    <7.5, -1.05, 0>
    0.11
  }
  cylinder
  {
    <7.5, -3.8, 0>
    <7.5, -4.0, 0>
    0.11
  }
  cone
  {
    <7.5, -3.9, 0> 0.1
    <7.5, -4.0, 0> 0.3
  }
  texture
  {
    Ball_Metal
  }
}
object {Post_1 rotate <0,   0, 0> }
object {Post_1 rotate <0,  20, 0> }
object {Post_1 rotate <0,  40, 0> }
object {Post_1 rotate <0,  60, 0> }
object {Post_1 rotate <0,  80, 0> }
object {Post_1 rotate <0, 100, 0> }
object {Post_1 rotate <0, 120, 0> }
object {Post_1 rotate <0, 140, 0> }
object {Post_1 rotate <0, 160, 0> }
object {Post_1 rotate <0, 180, 0> }
object {Post_1 rotate <0, 200, 0> }
object {Post_1 rotate <0, 220, 0> }
object {Post_1 rotate <0, 240, 0> }
object {Post_1 rotate <0, 260, 0> }
object {Post_1 rotate <0, 280, 0> }
object {Post_1 rotate <0, 300, 0> }
object {Post_1 rotate <0, 320, 0> }
object {Post_1 rotate <0, 340, 0> }

// and the calibrated sandbox rail
union
{
  difference
  {
    cylinder
    {
      <0, -0.8, 0>
      <0, -1.1, 0>
      6.0
    }
    cylinder
    {
      <0, -0.7999, 0>
      <0, -1.1001, 0>
      5.95
    }
  }
  // this one is so the numbers don't show through the back
  difference
  {
    cylinder
    {
      <0, -0.8, 0>
      <0, -1.1, 0>
      5.95
    }
    cylinder
    {
      <0, -0.7999, 0>
      <0, -1.1001, 0>
      5.94
    }
    texture
    {
      Silver_Texture
      finish
      {
	Dull
      }
    }
  }
  difference
  {
    cylinder
    {
      <0, -0.8, 0>
      <0, -0.85, 0>
      6.0
    }
    cylinder
    {
      <0, -0.7999, 0>
      <0, -0.8501, 0>
      5.8
    }
  }
  difference
  {
    torus
    {
      5.9, 0.08
      scale <1, 3, 1>
      translate <0, -0.8, 0>
    }
    cylinder
    {
      <0, -0.8, 0>
      <0, -2.0, 0>
      6.1
    }
    intersection
    {
      box
      {
        <-5, -0.7, -6.5>
        <5, 0, 0>
      }
      plane
      {
        -x, 0
        rotate <0, 20, 0>
      }
      plane
      {
	x, 0
	rotate <0, -5, 0>
      }
    }
    intersection
    {
      box
      {
        <-5, -0.7, -6.5>
        <5, 0, 0>
      }
      plane
      {
        -x, 0
        rotate <0, 20, 0>
      }
      plane
      {
	x, 0
	rotate <0, -5, 0>
      }
    rotate <0, 180, 0>
    }

    texture
    {
      pigment {color Tan }
      finish
      {
	crand 0.3
      }
    }
  }
  texture
  {
    Silver_Texture
    finish
    {
      Dull
    }
    normal
    {
      bump_map
      {
        tga "numbers.tga"
        bump_size 0.4
	map_type 0
      }
      scale <10, 0.3, 1>
      translate <0, 0.06, 0>
    }
  }
}

#declare Post_2 =
union
{
  box
  {
    <5.90, -1.15, -0.075>
    <6.05, -1.05,  0.075>
  }
  cylinder
  {
    <5.975, -1.15, 0>
    <5.975, -4, 0>
    0.025
  }
  box
  {
    <5.925, -4, -0.05>
    <6.025, -3.9, 0.05>
  }
  texture
  {
    Silver_Texture
  }
}

object {Post_2 rotate <0,  10, 0> }
object {Post_2 rotate <0,  50, 0> }
object {Post_2 rotate <0,  90, 0> }
object {Post_2 rotate <0, 130, 0> }
object {Post_2 rotate <0, 170, 0> }
object {Post_2 rotate <0, 210, 0> }
object {Post_2 rotate <0, 250, 0> }
object {Post_2 rotate <0, 290, 0> }
object {Post_2 rotate <0, 330, 0> }

#declare Floor_Stone =
texture{pigment{color Black}
	finish{ambient 0.4 crand 0.06 diffuse 0.7}
}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Grnt9a scale <6, 1, 1> rotate <0, 0, 40>
	finish{phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90}
}

plane
{
  y, -4
  texture
  {
    tiles
    {
      texture
      {
	Stone8
	finish {Dull}
      }
      tile2 texture
      {
	Stone13
	finish {Dull}
      }
    }
    scale <2, 1, 2>
  }
  clipped_by
  {
    cylinder
    {
      <0, -3, 0>
      <0, -5, 0>
      45
    }
  }
}


// black circle in floor
union
{
  cylinder
  {
    <0, -4, 0>
    <0, -3.99999, 0>
    8
    texture
    {
      Grnt15 scale <2,3,2> rotate <0, 0, -30>
    }
    texture
    {
      Crack4 scale <0.5, 0.2, 0.3> rotate <20, 30, 5>
      finish
      {
        phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90
      }
    }
  }
  difference
  {
    cylinder
    {
      <0, -4, 0>
      <0, -3.998, 0>
      6.55
    }
    cylinder
    {
      <0, -4, 0>
      <0, -3, 0>
      6.50
    }
    texture
    {
      Silver_Texture
    }
  }
  difference
  {
    cylinder
    {
      <0, -4, 0>
      <0, -3.998, 0>
      6.8
    }
    cylinder
    {
      <0, -4, 0>
      <0, -3, 0>
      6.75
    }
    texture
    {
      Silver_Texture
    }
  }
}

// Now a ring of columns around the whole place.
// They go all around so they'll reflect in the ball.
#declare Col_Texture = 
texture
{
  Stone1
  scale <1, 1.3, 1>
}


#declare Column_Top = 30
#declare Column_Section =
union
{
  cylinder
  {
    <0, -4, 0>
    <0, Column_Top, 0>
    1
  }
  torus
  {
    1, 0.25
    translate <0, -4, 0>
  }
  torus
  {
    1, 0.10
    translate <0, -3.65, 0>
  }
  texture
  {
    Col_Texture
  }
  rotate <0, 7.5, 0>
  translate <0, 0, 30>
}

object {Column_Section rotate <0, 000, 0>}
object {Column_Section rotate <0, 015, 0>}
object {Column_Section rotate <0, 030, 0>}
object {Column_Section rotate <0, 045, 0>}
object {Column_Section rotate <0, 060, 0>}
object {Column_Section rotate <0, 075, 0>}
object {Column_Section rotate <0, 090, 0>}
object {Column_Section rotate <0, 105, 0>}
object {Column_Section rotate <0, 120, 0>}
object {Column_Section rotate <0, 135, 0>}
object {Column_Section rotate <0, 150, 0>}
object {Column_Section rotate <0, 165, 0>}
object {Column_Section rotate <0, 180, 0>}
object {Column_Section rotate <0, 195, 0>}
object {Column_Section rotate <0, 210, 0>}
object {Column_Section rotate <0, 225, 0>}
object {Column_Section rotate <0, 240, 0>}
object {Column_Section rotate <0, 255, 0>}
object {Column_Section rotate <0, 270, 0>}
object {Column_Section rotate <0, 285, 0>}
object {Column_Section rotate <0, 300, 0>}
object {Column_Section rotate <0, 315, 0>}
object {Column_Section rotate <0, 330, 0>}
object {Column_Section rotate <0, 345, 0>}

// and a sky of some sort
sphere
{
  <0, 0, 0>
  800
  texture
  {
    pigment
    {
      image_map
      {
	tga "stars.tga"
	map_type 0
	interpolate 2
      }
    }
    finish
    {
      ambient 0.8
    }
  }
}

light_source { <-30, 450, -255> color White}
light_source { <-30, 450, -255> color White}

camera
{
  location <0, 2.5, -20>
  direction <0, 0, 1.5>
  look_at <0, -1, 0>
}
