#declare Ornament = object {
	union {
		object {
			height_field { gif "orn.gif" }
			water_level 0.9
			translate <-0.05, 0, 0.05>
			translate -y*0.87
		}
		union {
			sphere {<1, 0, 0>, 0.05}
			cylinder {<0, 0, 0>, <1, 0, 0>, 0.05}
			cylinder {<1, 0, 0>, <1, 0, 1>, 0.05}
			box {<0, -0.05, 0>, <1, 0.05, 0.05>}
			box {<0.95, -0.05, 0>, <1, 0.05, 1>}
		}
	}
	texture {
		pigment { color rgb <0.85, 0.45, 0.1> }
		finish {
			metallic
			ambient 0.2
			phong 1
			reflection 0.3
		}
	}
}

#declare Cover = object {
	union {
		sphere {<3, 0, 0>, 0.03 }
		sphere {<3, 0, 4>, 0.03 }
		box {<0, -0.03, 0>, <3, 0.03, 4>}
		cylinder {<0, 0, 0>, <3, 0, 0>, 0.03}
		cylinder {<0, 0, 4>, <3, 0, 4>, 0.03}
		cylinder {<3, 0, 0>, <3, 0, 4>, 0.03}
		object {Ornament translate x*2}
		object {Ornament rotate -y*90 translate <3, 0, 3>}
	}
	texture {
		pigment {color rgb <0.5, 0, 0.1>}
		finish {ambient 0.2 phong 0.2}
		normal {bumps 0.05 scale 0.01}
	}
}

#declare Back = object {
	union {
		difference {
			cylinder {<0, 0, 0.05>, <0, 0, 4-0.05>, 0.24}
			cylinder {<0, 0, -0.1>, <0, 0, 4.1>, 0.21}
			plane {y, 0}
			plane {-x, 0}
		}
		box {<-0.24, -0.5, 0.05>, <-0.21, 0, 4-0.05>
			texture {
				pigment {color rgb <0.5, 0, 0.1>}
				finish {ambient 0.2 phong 0.3}
			}
			texture {
				pigment {
					image_map {
						gif "pov.gif"
						once
						map_type 0
						filter 215, 1
						filter 210, 0.1
						interpolate 2
					}
				}
				finish {ambient 0.2 phong 0.3}
				normal {
					bump_map {
						gif "pov.gif"
						once
						map_type 0
						interpolate 2
						bump_size 1
					}
				}
				translate <-0.5, -0.5, 0>
				scale <4.8, 0.9, 1>
				rotate y*90
				translate <-0.24, -0.25, 2>
			}
		}
		difference {
			cylinder {<0, -0.5, 0.05>, <0, -0.5, 4-0.05>, 0.24}
			cylinder {<0, -0.5, -0.1>, <0, -0.5, 4.1>, 0.21}
			plane {-y, 0.5}
			plane {-x, 0}
		}
	}
	translate -y*0.25
	pigment {color rgb <0.5, 0, 0.1>}
	finish {ambient 0.2 phong 0.3}
}

#declare Lists = object {
	difference {
		box {<0, -0.95, 0.05>, <3-0.05, -0.05, 4-0.05>}
		cylinder {<2.95+0.879985, -0.95/2, 0>,
				<2.95+0.879985, -0.95/2, 4>, 1
		}
	}
	texture {
		pigment {
			image_map {
				gif "pages.gif"
				map_type 0
				interpolate 2
			}
		}
		finish {ambient 0.25 phong 0.5}
		normal {
			bump_map {
				gif "pages.gif"
				map_type 0
				interpolate 2
				bump_size 1
			}
		}
		scale 0.2
	}
}

#declare Top = blob {
	threshold 0.600000
	component 1.0, 0.21, <0, 0.194779, 0>
	component 1.0, 0.18, <0, 0.422916, 0>
	component 1.0, 0.18, <0, 0.635843, 0>
	component 1.0, 0.18, <0, 0.848771, 0>
	component 1.0, 0.19, <0, 1.061699, 0>
	component 1.0, 0.18, <0, 1.274627, 0>
	component 1.0, 0.18, <0, 1.487554, 0>
	component 1.0, 0.18, <0, 1.700482, 0>
	component 1.0, 0.17, <0, 1.913410, 0>
	component 1.0, 0.19, <0, 2.126338, 0>
	translate -y*0.1
	scale <0.3, 0.43, 0.3>

	texture {
		pigment { color rgb <1, 1, 0.75> }
		finish { ambient 0.2 phong 0.4 }
		normal {bumps 0.6 scale 0.02}
   }
}

#declare Mark = intersection {
	difference {
		cylinder {<0, 0, 0>, <0.3, 0, 0>, 0.2}
		cylinder {<-0.1, 0, 0>, <0.4, 0, 0>, 0.199}
	}
	box {<-0.1, 0.05, 0>, <0.4, 0.3, 0.3>}
	texture {
		pigment { color rgb <0.9, 1, 0.96> }
		finish { ambient 0.2 phong 0.4 }
   }
   translate -y*0.2
   scale <1, 1, 1.3>
}

#declare Book = union {
	object {Cover}
	object {Cover rotate x*180 translate <0, -1, 4>}
	object {Back}
	object {Lists}
	object {Top translate <0, -0.95, 0.05>}
	object {Top translate <0, -0.95, 3.95>}
	object {Mark translate <0.4, -0.3, 3.95>}
	translate <-1.5, 1.05, -2>
	scale 0.25
}

#declare Books = union {
	object {
		Book rotate y*200
		translate <0, 0.275, 0.1>
	}
	union {
		object {Book scale <1.15, 1, 1.15>}
		object {Leaf scale 0.9 rotate y*220 translate <0.4, 0.15, 0>}
	}
}
