#declare Golden =  texture {
	pigment { color rgb <1, 0.7, 0.3> }
	finish {
		metallic
		ambient 0.2
		phong 1
		reflection 0.6
   }
}

#declare My_glass = texture {
	pigment { color rgbf <0.95, 1, 1, 0.9> }
	finish {
		ambient 0.15
		phong 1.0 phong_size 80
		specular 0.8
		roughness 0.01
		reflection 0.4
		refraction 1
		ior 1.3
	}
}

#declare Lens = object {
	union {
		sphere { <0, 0, 0>, 0.5
			scale <1, 1, 0.15>
			texture { My_glass }
		}
		torus {0.5, 0.02 rotate x*90 texture {Golden}}
	}
}

#declare Pad = object {
	sphere { <0, 0, 0>, 0.2
		scale <0.2, 1, 0.5>
		texture { Golden }
	}
	translate -y*0.2
}

#declare Corner = object {
	intersection {
		difference {
			cylinder {
				<0, 0, 0>,
				<0, 0, 0.1>, 0.52
			}
			cylinder {
				<0, 0, -0.1>,
				<0, 0, 0.2>, 0.48
			}
			box {
				<-0.6, -0.025, 0.02>,
				<0, 0.025, 0.15>
			}
		}
		cylinder {
			<-0.6, 0, 0>,
			<0, 0, 0>, 0.08
		}
	}
	texture { Golden }
}

#declare Side = object {
	union {
		box {
			<-0.005, -0.02, 0.025>,
			<0.005, 0.02, 1.5>
		}
		difference {
			cylinder {<-0.005, 0, 0>, <0.005, 0, 0>, 0.52}
			cylinder {<-0.02, 0, 0>, <0.02, 0, 0>, 0.48}
			plane {z, 0}
			plane {y, 0 rotate x*45}
			translate <0, -0.5, 1.5>
		}
		sphere {
			<0, 0, 0>, 0.03
			translate z*0.5 rotate x*45 translate <0, -0.5, 1.5>
		}
	}
	texture {Golden}
}

#declare Bridge = object {
	difference {
		cylinder {
			<0, 0, -0.02>,
			<0, 0, 0.02>, 0.27
		}
		cylinder {
			<0, 0, -0.05>,
			<0, 0, 0.05>, 0.23
		}
		plane {y, 0}
	}
	texture { Golden }
}

#declare Spectacles = union {
	object { Lens translate -x*0.75}
	object { Lens translate x*0.75}
	object { Bridge }
	object { Pad rotate -z*10 translate -x*0.2 }
	object { Pad rotate z*10 translate x*0.2 }
	object { Corner translate -x*0.75}
	object { Corner rotate z*180 translate x*0.75}
	object { Side translate -x*1.25}
	object { Side translate x*1.25}
	translate y*0.52
	scale 0.5
	rotate -x*11
}
