#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


camera {  //  Camera StdCam
  location  <-25, -150, 45 >
  direction <0.0,     0.0,  1.75>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}


light_source {   // Light1
  <100, -50, 75>
  color rgb <1.500, 1.500, 1.500>
}


object {   // ground
  height_field {
    tga "lndscp02.tga" 
    water_level 0.000000
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Jade
    normal { wrinkles 1.0 scale 10 }
    finish {
      ambient   0.40
        }
    scale 0.01
  }
  scale <500.000000, 500.000000, 1.000000>
}

object {   // sky
  sphere {<0,0,0>,1}
  texture {
    Blue_Sky3
    finish {
      ambient   0.40
    }
  }
  scale <495.000000, 495.000000, 495.000000>
}

#declare obelisk1 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  translate <40.500000, 0.000000, 9.000000>
}

#declare obelisk2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -30.000000>
  translate <35.074029, -20.250000, 9.000000>
}

#declare obelisk3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -60.000000>
  translate <20.250000, -35.074029, 9.000000>
}

#declare obelisk4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <0.000000, -40.500000, 9.000000>
}

#declare obelisk5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -120.000000>
  translate <-20.250000, -35.074029, 9.000000>
}

#declare obelisk6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -150.000000>
  translate <-35.074029, -20.250000, 9.000000>
}

#declare obelisk7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -180.000000>
  translate <-40.500000, 0.000000, 9.000000>
}

#declare obelisk8 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -210.000000>
  translate <-35.074029, 20.250000, 9.000000>
}

#declare obelisk9 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -240.000000>
  translate <-20.250000, 35.074029, 9.000000>
}

#declare obelisk10 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -270.000000>
  translate <0.000000, 40.500000, 9.000000>
}

#declare obelisk11 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -300.000000>
  translate <20.250000, 35.074029, 9.000000>
}

#declare obelisk12 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <0.000000, 0.000000, -330.000000>
  translate <35.074029, 20.250000, 9.000000>
}

#declare obelisk13 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.500000, 1.500000, 4.500000>
  translate <10.000000, 10.000000, 4.500000>
}

#declare obelisk14 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.500000, 1.500000, 4.500000>
  translate <10.000000, -10.000000, 4.500000>
}

#declare obelisk15 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.500000, 1.500000, 4.500000>
  translate <-10.000000, -10.000000, 4.500000>
}

#declare obelisk16 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <1.500000, 1.500000, 4.500000>
  translate <-10.000000, 10.000000, 4.500000>
}

#declare obelisk17 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <-90.000000, -90.000000, -45.000000>
  translate <28.250000, -28.250000, 21.000000>
}

#declare obelisk18 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <-90.000000, -90.000000, -135.000000>
  translate <-28.250000, -28.250000, 21.000000>
}

#declare obelisk19 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <-90.000000, -90.000000, -225.000000>
  translate <-28.250000, 28.250000, 21.000000>
}

#declare obelisk20 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <3.000000, 4.000000, 9.000000>
  rotate <-90.000000, -90.000000, -315.000000>
  translate <28.250000, 28.250000, 21.000000>
}

union {
  object { obelisk1 }
  object { obelisk2 }
  object { obelisk3 }
  object { obelisk4 }
  object { obelisk5 }
  object { obelisk6 }
  object { obelisk7 }
  object { obelisk8 }
  object { obelisk9 }
  object { obelisk10 }
  object { obelisk11 }
  object { obelisk12 }
  object { obelisk13 }
  object { obelisk14 }
  object { obelisk15 }
  object { obelisk16 }
  object { obelisk17 }
  object { obelisk18 }
  object { obelisk19 }
  object { obelisk20 }
  texture {
        pigment { hexagon color Gray25 color Gray35 color Gray45 }
        normal { bumps 0.3 scale 0.2 }
        finish {
                ambient   0.50
                }
        scale 0.4
        rotate <45, 45, 45>
        }
}
