//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 2 textures and 13 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 05/24/1995    (24.05.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
// #include "enviro.inc"

camera {  //  Camera StdCam
  location  <-9.468, 14.454, 20.823>
  direction <0.0,     0.0,  2.1144>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******
light_source {   // Light001
  <8.652, 17.223, 24.688>
  color rgb <1.500, 1.500, 1.500>
}


//
// ********  T E X T U R E S  *******
//

#include "SUNDIAL.INC"

// ********  O B J E C T S *******
object {   // Ground
  height_field {
    tga "d:\pov\scenes\lndscapa.tga" 
    water_level 0.000000
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Cork
    finish {
      ambient   0.40
      diffuse   0.00
      reflection  0.000
    }
  }
  scale <30.000000, 30.000000, 0.200000>
  translate <0.000000, 0.000000, 0.100000>
}

#declare DialBase = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <5.000000, 5.000000, 0.800000>
}

#declare Pointer = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  scale <0.200000, 1.000000, 7.000000>
  rotate <-45.000000, -179.549545, 0.000000>
  translate <0.000000, -2.750000, 5.000000>
}

#declare Cube001 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -60.000000>
  translate <0.000000, -4.000000, 0.500000>
}

#declare Cube2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -120.000000>
  translate <0.000000, -4.000000, 0.500000>
}

#declare Cube3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-1.000000, -4.000000, 0.500000>
}

#declare Cube4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-0.600000, -4.000000, 0.500000>
}

#declare Twelve = union {
  object { Cube001 }
  object { Cube2 }
  object { Cube3 }
  object { Cube4 }
  translate <0.400000, 0.000000, 0.000000>
}

#declare Cube7 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-4.100000, 0.000000, 0.500000>
}

#declare Cube6 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-4.900000, 0.000000, 0.500000>
}

#declare Cube5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-4.500000, 0.000000, 0.500000>
}

#declare Three = union {
  object { Cube7 }
  object { Cube6 }
  object { Cube5 }
  translate <0.500000, 0.000000, 0.000000>
}

#declare Cube8 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -60.000000>
  translate <0.000000, -4.000000, 0.500000>
}

#declare Cube9 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -120.000000>
  translate <0.000000, -4.000000, 0.500000>
}

#declare Cube10 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.500000, 0.100000, 0.500000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <-0.600000, -4.000000, 0.500000>
}

#declare Nine = union {
  object { Cube8 }
  object { Cube9 }
  object { Cube10 }
  rotate <0.000000, 0.000000, -180.000000>
  translate <3.800000, -4.000000, 0.000000>
}

union {
  object { DialBase }
  object { Pointer }
  object { Twelve }
  object { Three }
  object { Nine }
  texture {
    Jade
    scale 8
    finish {
      ambient   0.40
    }
  }
}

