// "A Writer's Tools"  by Matt Kruse (mkruse@saunix.sau.edu)
// This image was created for November's theme - "tools"
// Each object in this file may be used by anyone who wants to use them, 
//     but I'd ask that you not try to pass anything off as your own if
//     it isn't (of course).
// GUM was used for a few minor things, such as the bezier patches and
//     a little bit of camera positioning.  GUM is excellent!
// Scale:  1 cm = 1 unit

#include "colors.inc"
#include "textures.inc"

//----------------------------------------
//First Define building blocks and objects
//----------------------------------------

#declare Pen_Brass=
texture {New_Brass
   pigment {color Yellow}
   finish {phong 1.0 phong_size 90 diffuse .4 metallic reflection .3 ambient .3}
}

#declare Gold_Piece=
   difference{
      sphere { <0,0,0> , .4 texture {Pen_Brass} 
           scale <1,.375,1> translate y*.05 }
      plane { y,0 texture {Pen_Brass} } 
      plane { <0,-1,0> , -.1 texture {Pen_Brass} }
   }

#declare Pen_Texture=
texture { pigment {granite color_map { [0.0 color Black] [0.4 color Black]
                   [0.4 color blue .65] [1.0 color blue .658823] } scale .4 }  
                   finish {ambient .3} }
texture { pigment {color Clear}
          finish {phong 1.0 phong_size 60 diffuse .5 reflection .25} }

#declare Pen_Body=
cylinder { <0,0,0> , <0,1,0> , .4}

#declare Pen=
union{
object { Gold_Piece }
object { Gold_Piece translate y*.1}
object { Pen_Body scale <1,4.8,1> texture {Pen_Texture} } 
object { Gold_Piece translate y*5 }
object { Gold_Piece translate y*5.1}
object { Pen_Body scale <1,6.3,1> translate y*5.2 texture {Pen_Texture} }
cone { <0,11.5,0> , .4 , <0,12.9,0> , .15 open texture {Pen_Brass} }
cylinder { <0,11.2,0> , <0,13.05,0> , .10 texture {Silver_Texture} }
cone { <0,13.05,0> , .10 , <0,13.25,0> , 0 texture {Silver_Texture} }
}

#declare WhiteOutTexture =
   texture {pigment {color Gray90}
            finish {phong .45 phong_size 50 reflection .08 ambient .15} }

#declare WO_Bottle=  union {
   cylinder { <0,.3,0> , <0,4.2,0> , 1.35
      texture {WhiteOutTexture} 
      texture {
         pigment { image_map { gif "wolabel.gif" interpolate 2 map_type 2 once} 
                               scale <1,3.5,1> translate y*.5}
         finish {phong 0.1 phong_size 30 reflection 0.0}}
      rotate y*-60  //get image in right position
      }
   torus { .95 , .4
      scale <1,.75,1>
      translate y*.3
      texture {WhiteOutTexture} }
   torus { 1.25, .1
      translate y*4.2
      texture {WhiteOutTexture} }
   cone { <0,.09535,0> , 1.2801399, <0,.5,0> ,0
      translate y*4.2
      texture {WhiteOutTexture} }
   cylinder { <0,4.2,0> , <0,5.0,0> , .35
      texture {WhiteOutTexture} }
   cone { <0,0,0> , .85, <0,1.4,0> ,.77 //cap
      texture {WhiteOutTexture
              pigment {color White}
              normal { bump_map { gif "ribs.gif" bump_size 5 
                                  map_type 2 interpolate 2} }
              }  //end of texture statement
      translate y*4.7}  //end of cone
      
   }  //end of union
      
#declare Paper=
difference {
   box { <0,0,0> , <21.7,.001,28.1>
   texture { pigment {color Gray85} }
   texture { pigment {gradient z
             color_map { [0.0 color Clear] [0.95 color Clear]
                         [0.95 color Blue] [1.0 color Blue] } 
             scale .7 } }
   texture { pigment { gradient x
             color_map { [0.0 color Pink] [0.003 color Pink]
                         [0.003 color Clear] [1.0 color Clear] }
             scale x*21.7 translate x*3.1} } } 
//  subtract the following cylinders for the holes in the paper
cylinder { <1.2,-1,3.2> , <1.2,1,3.2> , .4 }
cylinder { <1.2,-1,14> , <1.2,1,14> , .4 }
cylinder { <1.2,-1,24.9> , <1.2,1,24.9> , .4 }
}  //end of difference

#declare Book=
union {       //union the book and cover together
difference    //this is the main book
{
   box { < 0, 0, 0 >, < 1, 1, 1 >  scale < 10.7, 3.5, 17.8 > }
   // this cylinder makes the spine curved
   cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1
      scale < 0.25, 25, 1.75 > rotate < 90, 0, 0 >
      translate < 0, 1.75, -0.5 > }

texture { pigment { gradient y color_map{[0.0 color Yellow] 
                    [1.0 color Goldenrod] } frequency 10} finish {ambient .6}}
texture { pigment { image_map { gif "thes2.gif" interpolate 2 once }
                   rotate y*90 scale <1,3.49,17.78> translate z*17.79}}
}
// Use a bicubic patch for the cover to get the bent corners.
// Makes it a lot more realistic, in my opinion.
bicubic_patch
{
   type 1
   flatness 0.05
   u_steps 4
   v_steps 4
   < 0.0065654, 3.5, -0.0086593 >, < 3.5666, 3.5, -0.0086593 >, < 7.1266, 3.5, -0.0086593 >, < 10.666, 4.1616, -0.0753 >, 
   < 0.0065654, 3.5, 5.9313 >, < 3.5666, 3.5, 5.9313 >, < 7.1266, 3.5, 5.9313 >, < 10.598, 3.766, 5.9313 >, 
   < 0.0065654, 3.5, 11.871 >, < 3.5666, 3.5, 11.871 >, < 7.1266, 3.5, 11.871 >, < 10.477, 3.861, 11.871 >, 
   < 0.0065654, 3.5, 17.811 >, < 3.5666, 3.5, 17.811 >, < 7.164, 3.8153, 17.634 >, < 10.666, 4.8071, 17.634 >
   pigment { image_map { gif "thes.gif" interpolate 2 once} 
             rotate x*90 scale <10.7,1,17.8> translate y*3.5}
}
} //end of book union

//----------------------------------------------
// Time to put all those objects into the scene!
//----------------------------------------------

object {WO_Bottle rotate y*-30 translate <3,0,9>}
object {Pen rotate z*-90 translate y*.4
        rotate y*-180 translate <19,0,5>}
object {Paper rotate y*-5 translate <5,0,3>}
object {Book rotate y*-5 translate <18,0,6>}
plane {y,0 texture {DMFWood5 scale 30 rotate x*5 finish {ambient .55 phong .3} } }

camera { location <0,0,0> direction <0,0,1.75>
         translate z*-40 rotate x*11.9622 rotate y*42.13
         translate <19,0,21> }

// put in a few lights.  area_lights take too long for my computer, so you'll 
// have to live with the sharp shadows...
light_source { <0,10,0> color White}
light_source { <20,10,20> color White}
light_source { <10,50,10> color Gray50 }
