/*
#include "colors.inc"
#include "shapes.inc"

camera{
    location <0, 0, -8>
    look_at <0, 0, 0>
}

light_source{ <1000, 1000, -1000> color Gray60 }

// From shapes2.inc
#declare Pyramid2 = intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0 }
   translate <0 ,-1, 0>
}
*/

/////////////////////////////////////////////////////////////////////

#declare FrameTex = texture{
    pigment{
        wood
        turbulence .05
        color_map{
            [0.0 0.8 color rgb <.725, .5, .3> color rgb <.53, .36, .11>]
            [0.8 1.0 color rgb <.53, .36, .11> color rgb <.52, .36, .11>]
        }
    }
    scale .1*<2, 1, 1>
    rotate x*90
}

#declare Picture =
union{

    // Frame
    difference{
        box{ <-2, -1.5, -.2> <2, 1.5, .2> scale 1.2*<1, 1, 1> }
        union{
            box{ <-2, -1.5, -2> <2, 1.5, 2> }
            cylinder{ <-2.2, 1.65, -.2> <2.2, 1.65, -.2> .1 }
            cylinder{ <-2.2, -1.65, -.2> <2.2, -1.65, -.2> .1 }
            cylinder{ <-2.2, 1.75, -.2> <-2.2, -1.75, -.2> .1 }
            cylinder{ <2.2, 1.75, -.2> <2.2, -1.75, -.2> .1 }
        }
        texture{ FrameTex rotate z*-90 }
        finish{ ambient .35 }
    }

    // Image
    box{
        <0, 0, 0> <1, 1, 1>
        texture{ pigment{ image_map{
            tga "gpbridge.tga" map_type 0 once
        }}}
        finish{ ambient .6 }
        translate <-.5, -.5, -.5>
        scale <4, 3, .1>
        translate <0, 0, -.15>
    }

}

/*
object{ Picture rotate y*30 }
*/
