/* POVRAY DESCRIPTION FILE
   SCENE DESCRIPTION : A tranformer robot being persued somewhere in Mega
                       City, guns blazing at YOU, the innocent bystander.                       
   DATE CREATED : 10.11.95
   AUTHOR : Nathan O'Brien
            33/392 Jones St Ultimo 2007 Australia
            phone : 612 966 01102  (AH) 
            fax   : 612 261 8932
            email : no13@ozemail.com.au
  THANKS TO : Gennadiy Obukhov for his Head object (see head.inc)
*/


#include "colors.inc"
#include "trans1.inc"

camera {
        location <400,0,-2500>
        look_at  <-100,0,0>
}

light_source {<400,0,-2500> color red .05 green .05 blue .05}

light_source {<-2000,2000,-8000> color red 1.1 green 1.1 blue 1.1
        spotlight
        point_at<0,0,0>
        radius 5
        falloff 6
        tightness 100
}

light_source {<-2000,2000,-8000> color White
        spotlight
        point_at<0,0,0>
        radius 5
        falloff 13
        tightness 10
}

box {<-5000,-5000,0><5000,5000,10>
        texture{pigment{
        image_map{gif "brick2.gif" interpolate 4}
        scale<500,250,250>
        }}
        texture{pigment{
        image_map{gif "graffiti.gif" interpolate 4 once filter 255,1}
        scale<4500,2000,2000>
        translate<-2250,-1000,0>
        }}
        normal{
        bump_map{gif "brick1.gif" bump_size 10 interpolate 4}
        scale<500,250,250>
        }
        finish {ambient -.1 diffuse .3}
}

object {transformer1 scale<2.2,2.2,2.2> rotate<-10,-40,-5> translate<-200,-600,-1200>}

