/*-------------------------------------------------------------------

//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 2 textures and 15 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 10/13/1995    (13.10.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.
#include "enviro.inc"

camera {  //  Camera StdCam
  location  <-15.794, -0.039, -0.447>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******
light_source {   // Light1
  <10.820, -8.500, 10.316>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  T E X T U R E S  *******
//

#include "CHAIR.INC"

-------------------------------------------------------------------*/

#declare OWood =
 pigment 
  {wood
   turbulence 0.03
   octaves 4
   scale <0.05, .05, 1>
   color_map 
    {[0.00, 0.10 color Gray30
                 color Gray30]
     [0.10, 0.90 color Gray30
                 color Gray25]
     [0.90, 1.0  color Gray15
                 color Gray15]
    }
  }

// ********  O B J E C T S *******
#declare leg = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  scale <0.150000, 0.150000, 2.500000>
  translate <0.000000, 0.000000, -2.500000>
}

#declare Wheel2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  rotate <0.000000, -90.000000, 0.000000>
}

#declare Post2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  scale <0.100000, 0.100000, 2.000000>
  translate <-0.500000, 0.000000, 0.000000>
}

#declare WheelU1 = union {
  object { Wheel2 }
  object { Post2 }
  scale <0.250000, 0.250000, 0.250000>
  translate <-0.750000, 0.000000, -2.900000>
}

#declare Wheel1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  rotate <0.000000, -90.000000, 0.000000>
}

#declare Post1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  scale <0.100000, 0.100000, 2.000000>
  translate <-0.500000, 0.000000, 0.000000>
}

#declare WheelU = union {
  object { Wheel1 }
  object { Post1 }
  scale <0.250000, 0.250000, 0.250000>
  translate <1.000000, 0.000000, -2.900000>
}

#declare base1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    
    pigment{Gray30}
  }
  scale <1.000000, 0.100000, 0.100000>
  translate <0.000000, 0.000000, -2.400000>
}

#declare BaseWhl = union {
  object { WheelU1 }
  object { WheelU }
  object { base1 }
}

#declare Wheel3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  rotate <0.000000, -90.000000, 0.000000>
}

#declare Post3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  scale <0.100000, 0.100000, 2.000000>
  translate <-0.500000, 0.000000, 0.000000>
}

#declare WheelU2 = union {
  object { Wheel3 }
  object { Post3 }
  scale <0.250000, 0.250000, 0.250000>
  rotate <0.000000, 0.000000, 90.000000>
  translate <-0.850000, 0.100000, -2.900000>
}

#declare Wheel4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  rotate <0.000000, -90.000000, 0.000000>
}

#declare Post4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    
    pigment{Gray15}
  }
  scale <0.100000, 0.100000, 2.000000>
  translate <-0.500000, 0.000000, 0.000000>
}

#declare WheelU3 = union {
  object { Wheel4 }
  object { Post4 }
  scale <0.250000, 0.250000, 0.250000>
  rotate <0.000000, 0.000000, -90.000000>
  translate <0.850000, -0.100000, -2.900000>
}

#declare base2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    
    pigment{Gray30}
  }
  scale <1.000000, 0.100000, 0.100000>
  translate <0.000000, 0.000000, -2.400000>
}

#declare BaseWhl1 = union {
  object { WheelU2 }
  object { WheelU3 }
  object { base2 }
  rotate <0.000000, 0.000000, -90.000000>
}

#declare seat = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    pigment{Gray10}
  }
  scale <1.000000, 1.000000, 0.150000>
}

#declare cushion = object { 
  sphere {<0,0,0>,1}
  texture {
    OWood
  }
  scale <0.950000, 0.950000, 0.250000>
  translate <0.000000, 0.000000, 0.150000>
}

#declare Seat = union {
  object { seat }
  object { cushion }
}

#declare cushion1 = object { 
  sphere {<0,0,0>,1}
  texture {
    OWood
  }
  scale <0.950000, 0.950000, 0.250000>
  translate <0.000000, 0.000000, 0.150000>
}

#declare Seat1 = 
  object { cushion1 
    scale <0.800000, 1.200000, 1.000000>
    rotate <-80.000000, 0.000000, 0.000000>
    translate <0.000000, -1.300000, 2.000000>
  }

#declare Backpost_1 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <1.577447, 0.000000, 0.000000>  <1.577447, -1.000000, 0.000000>  <7.443618, -1.000000, 0.000000>  <7.443618, 0.000000, 0.000000>
    <-1.000000, 0.000000, 2.000000>  <-1.000000, -1.000000, 2.000000>  <-0.090458, -1.000000, 2.000000>  <-0.090458, 0.000000, 2.000000>
    <-1.000000, 0.000000, 4.000000>  <-1.000000, -1.000000, 4.000000>  <0.702602, -1.000000, 4.000000>  <0.702602, 0.000000, 4.000000>
    <0.784387, 0.000000, 6.000000>  <0.784387, -1.000000, 6.000000>  <3.676580, -1.000000, 6.000000>  <3.676580, 0.000000, 6.000000>  }
}
#declare Backpost_2 = object { 
  bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3
    <7.443618, 0.000000, 0.000000>  <7.443618, 1.000000, 0.000000>  <1.577447, 1.000000, 0.000000>  <1.577447, 0.000000, 0.000000>
    <-0.090458, 0.000000, 2.000000>  <-0.090458, 1.000000, 2.000000>  <-1.000000, 1.000000, 2.000000>  <-1.000000, 0.000000, 2.000000>
    <0.702602, 0.000000, 4.000000>  <0.702602, 1.000000, 4.000000>  <-1.000000, 1.000000, 4.000000>  <-1.000000, 0.000000, 4.000000>
    <3.676580, 0.000000, 6.000000>  <3.676580, 1.000000, 6.000000>  <0.784387, 1.000000, 6.000000>  <0.784387, 0.000000, 6.000000>  }
}
#declare Backpost = union { 
  object { Backpost_1 }
  object { Backpost_2 }
  texture {
    pigment{Gray10}
  }
  scale <0.100000, 0.150000, 0.350000>
  rotate <0.000000, 0.000000, 90.000000>
  translate <0.000000, -1.600000, 0.000000>
}

#declare Chair =
union {
  object { leg }
  object { BaseWhl }
  object { BaseWhl1 }
  object { Seat }
  object { Seat1 }
  object { Backpost }
  rotate <90.000000, 0.000000, 0.000000>
  rotate<0,0,180>
  rotate<0,180,0>
}

