#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "chair.inc"
#include "lamp.inc"
#include "room.inc"
#include "table.inc"
#include "table2.inc"
#include "cup.inc"
#include "pencil.inc"
#include "cabinet.inc"

camera {
  location<0,2,-45> 
  look_at<0,0,0>
}

#declare Painting =
object{
  object{UnitBox
    pigment{
      image_map{
        tga "torus2.tga"
        map_type 0
        interpolate 0
        once
      }
      scale 1.1
    }
  }
}

object{
  Lamp
  scale .75
  rotate<0,-80,0>
  translate<-11.5,-3.25,-6>
  scale<1,1.5,1>
} 

/*Right lamp*/
object{
  LampNoLight
  scale .75
  rotate<0,-15,0>
  translate<17,-3.25,-5.75>
  scale<1,1.5,1>
} 

object{Chair
  rotate<0,75,0>
  translate <0,-5.4,-10>
  scale 1.4
} 


/*Right Chair*/
object{Chair
  rotate<0,-30,0>
  translate <7,-5.4,-8>
  scale 1.4
} 


/*This is the left table in the scene.*/
object{
  Table
  translate<-2,-0.85,-2>
  scale <3,6,3>
}

/*This is the table in the right corner.*/
object{
  Table2
  rotate<0,90,0>
  translate<5,-0.85,-5>
  scale <3,6,3>
}

object{
  DraftingTable
  rotate<-45,0,0>
  translate<-2,-2.75,-7.5>
  scale <2.75, 1, 1.75>
  pigment{White}
  no_shadow
}

/*Right drafting table*/
object{
  DraftingTable
  rotate<-45,0,0>
  rotate<0,90,0>
  translate<7,-2.75,-8.5>
  scale <2.75, 1, 1.75>
  pigment{White}
  no_shadow
}

/*
/*This is the pencil that sits on the right table*/
object{
  Pencil
  rotate<0,0,-90>
  translate<11,-5,-25>
  scale 5
}
*/

/*These two objects are the overhead lights in the room.*/
object{
  SLight
  rotate<10,0,0>
  translate<8,10,-20>
  no_shadow
}

object{
  SLight
  rotate<10,0,0>
  translate<-7,10,-20>
  no_shadow
}

#declare CupPencils =
union{
  object{
    Cup
    translate<0,0,-20>
    pigment{Black}
  }
  object{
    Pencil
    rotate<0,0,-25>
    translate<0,1.25,-20>
  }
  object{
    Pencil
    rotate<0,0,25>
    translate<0,1.25,-20>
  }
  object{
    BPencil
    rotate<25,0,0>
    translate<0,1.25,-20>
  }
}

object{
  CupPencils
  translate<-31.5,-9.75,-10>
  scale 0.5
}

/*On the right side of the room*/
object{
  CupPencils
  translate<35.5,-7.75,-15>
  scale 0.5
}


object{Cabinet
  rotate<0,180,0>
  rotate<180,0,0>
  translate<1.75,-4 ,-5>
  scale <2,2,1.5>
}

object{
  Painting
  translate<0,.4,-45>
  scale <7,6,0.1>
}

object{
  Room
  pigment{LightSteelBlue}
  scale 2
}

