/*This include file has the source for a desktop lamp.*/

#declare Lamp =
union{
  union{
    /*This forms the lampsahde*/
    cone{
      <0,1,0>, 0.5
      <0,0,0>, 1.1
      open
      pigment{Gray25}
    }

    /*Lightbulb*/
    object{
      light_source{<-9,2,-8> color White
        spotlight
        point_at <-3,0,-4>
        radius 6.5
        falloff 25
        tightness 3
      }
      no_shadow
    }
 
    /*This is the top part of the lampshade and the switch*/
    union{
      cylinder{
        <0,1,0>
        <0,1.5,0>
        0.5
        pigment{Gray50}
      }
      sphere{
        <0,1.5,0>, 0.5
        pigment{Gray50}
      }

      /*switch*/
      sphere{<0,1,0>, 0.1
        pigment{Gray25}
        scale <1,2,1>
      }
    }
    rotate<20,0,0>
    translate<0,2.2,-1.75>
  }

  union{
    /*This is the base of lamp.*/
    cone{
      <0,0.5,0>, 0
      <0,0,0>, 1
      pigment{Gray25}
    }
    /*Next 2 cylinders make up the neck*/
    cylinder{
      <0,0,0>
      <0,2.5,0>
      0.2
      pigment{Gray95}
    }
    cylinder{
      <0,0,0>
      < 0,2,0>
      0.2
      pigment{Gray95}
      rotate<0,0,-45>
      translate<0,2.4,0>
    }
    rotate<0,90,0>
  }
  finish{specular 0.3 metallic}
}

/*This lamp has no lightbulb*/
#declare LampNoLight =
union{
  union{
    /*This forms the lampsahde*/
    cone{
      <0,1,0>, 0.5
      <0,0,0>, 1.1
      open
      pigment{Gray25}
    }
 
    /*This is the top part of the lampshade and the switch*/
    union{
      cylinder{
        <0,1,0>
        <0,1.5,0>
        0.5
        pigment{Gray50}
      }
      sphere{
        <0,1.5,0>, 0.5
        pigment{Gray50}
      }

      /*switch*/
      sphere{<0,1,0>, 0.1
        pigment{Gray25}
        scale <1,2,1>
      }
    }
    rotate<20,0,0>
    translate<0,2.2,-1.75>
  }

  union{
    /*This is the base of lamp.*/
    cone{
      <0,0.5,0>, 0
      <0,0,0>, 1
      pigment{Gray25}
    }
    /*Next 2 cylinders make up the neck*/
    cylinder{
      <0,0,0>
      <0,2.5,0>
      0.2
      pigment{Gray95}
    }
    cylinder{
      <0,0,0>
      < 0,2,0>
      0.2
      pigment{Gray95}
      rotate<0,0,-45>
      translate<0,2.4,0>
    }
    rotate<0,90,0>
  }
  finish{specular 0.3 metallic}
}

