#declare Roof_1 = texture {
	Goldish
	normal {
		bump_map {
			gif "roof1.gif"
			bump_size 2
			map_type 0
			interpolate 2
		}
		scale 0.03
		rotate x*90
	}
}

#declare Roof_2 = texture {
	Goldish
	normal {
		bump_map {
			gif "roof2.gif"
			bump_size 1.4
			map_type 2
			interpolate 2
		}
		scale 0.03
	}
}

#declare Bricks = texture {
	Goldish
	normal {
		bump_map {
			gif "bricks.gif"
			bump_size -1.2
			map_type 0
			interpolate 2
		}
		scale 0.02
	}
}

#declare Bricks_c = texture {
	Goldish
	normal {
		bump_map {
			gif "bricks.gif"
			bump_size -1.2
			map_type 2
			interpolate 2
		}
		scale 0.02
	}
}

#declare Window = union {
	difference {
		intersection {
			cylinder {<0, 0, -0.01>, <0, 0, 0.01>, 0.15}
			plane {-y, 0}
			scale <0.25, 1, 1>
		}
		intersection {
			cylinder {<0, 0, -0.02>, <0, 0, -0.005>, 0.14}
			plane {-y, -0.01}
			scale <0.25, 1, 1>
		}
	}
	box {<-0.04, -0.01, -0.02>, <0.04, 0, 0.01>}
	box {<-0.035, -0.015, -0.016>, <0.035, -0.01, 0.01>}
	box {<-0.03, -0.02, -0.012>, <0.03, -0.015, 0.01>}

	box {<-0.002, 0, -0.008>, <0.002, 0.145, 0.008>}
	difference {
		union {
			box {<-0.035, 0.048, -0.008>, <0.035, 0.052, 0.008>}
			box {<-0.035, 0.098, -0.008>, <0.035, 0.102, 0.008>}
		}
		cylinder {<0, 0, -0.02>, <0, 0, -0.005>, 0.145 scale <0.25, 1, 1>
			inverse
		}
	}
	translate -z*0.1
}

#declare Column = union {
	cylinder {<0, 0.35, 0>, <0, 0.355, 0>, 0.013}
	cylinder {<0, 0.355, 0>, <0, 0.36, 0>, 0.012}
	cylinder {<0, 0.36, 0>, <0, 0.42, 0>, 0.01}
	cylinder {<0, 0.42, 0>, <0, 0.425, 0>, 0.012}
	cylinder {<0, 0.425, 0>, <0, 0.43, 0>, 0.013}
	translate z*0.07
	rotate y*22.5
}

#declare Subtower = union {
	cylinder {<0, 0, 0>, <0, 0.01, 0>, 0.03}
	cylinder {<0, 0.01, 0>, <0, 0.1, 0>, 0.04
		texture {Bricks_c}
	}
	cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.045}
	difference {
		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.035}
		cylinder {<0, 0.08, 0>, <0, 0.22, 0>, 0.02}
		union {
			cylinder {<0, 0.17, -0.1>, <0, 0.17, 0.1>, 0.016}
			box {<-0.016, 0.11, -0.1>, <0.016, 0.17, 0.1>}
			rotate y*45
		}
		union {
			cylinder {<0, 0.17, -0.1>, <0, 0.17, 0.1>, 0.016}
			box {<-0.016, 0.11, -0.1>, <0.016, 0.17, 0.1>}
			rotate y*135
		}
	}
	cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.05}
	cone {<0, 0.2, 0>, 0.07, <0, 0.23, 0>, 0.04 texture {Roof_2}}
	cone {<0, 0.23, 0>, 0.04, <0, 0.5, 0>, 0 texture {Roof_2}}
}

#declare T_window = intersection {
	plane {-y, -0.1}
	union {
		difference {
			union {
				cylinder {<0, 0.14, -0.2>, <0, 0.14, 0.2>, 0.04}
				box {<-0.04, 0.1, -0.2>, <0.04, 0.14, 0.2>}
			}
			union {
				cylinder {<0, 0.14, -0.2>, <0, 0.14, 0.2>, 0.03}
				box {<-0.03, 0.1, -0.2>, <0.03, 0.14, 0.2>}
			}
		}
		box {<-0.002, 0.1, -0.2>, <0.002, 0.18, 0.2>}
		box {<-0.04, 0.12, -0.2>, <0.04, 0.124, 0.2>}
		box {<-0.04, 0.145, -0.2>, <0.04, 0.149, 0.2>}
	}
	cylinder {<0, 0, 0>, <0, 0.2, 0>, 0.12}
}

#declare Tower_small = union {
	intersection {
		plane {z, 0.12 rotate y*0}
		plane {z, 0.12 rotate y*45}
		plane {z, 0.12 rotate y*90}
		plane {z, 0.12 rotate y*135}
		plane {z, 0.12 rotate y*180}
		plane {z, 0.12 rotate y*225}
		plane {z, 0.12 rotate y*270}
		plane {z, 0.12 rotate y*315}
		plane {-y, 0}
		plane {y, 0.1}
	}
	intersection {
		plane {z, 0.1 texture {Bricks} rotate y*0}
		plane {z, 0.1 texture {Bricks} rotate y*45}
		plane {z, 0.1 texture {Bricks} rotate y*90}
		plane {z, 0.1 texture {Bricks} rotate y*135}
		plane {z, 0.1 texture {Bricks} rotate y*180}
		plane {z, 0.1 texture {Bricks} rotate y*225}
		plane {z, 0.1 texture {Bricks} rotate y*270}
		plane {z, 0.1 texture {Bricks} rotate y*315}
		plane {-y, -0.05}
		plane {y, 0.65}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12
			texture {Bricks_c}
		}
		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.11}
		cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.125}
		cylinder {<0, 0.18, 0>, <0, 0.19, 0>, 0.13}
		cylinder {<0, 0.19, 0>, <0, 0.20, 0>, 0.14}
		object {T_window}
		object {T_window rotate y*45}
		object {T_window rotate y*90}
		object {T_window rotate y*135}
		cone {<0, 0.2, 0>, 0.17, <0, 0.3, 0>, 0.08
			texture {Roof_2}
		}
		cylinder {<0, 0.3, 0>, <0, 0.33, 0>, 0.08
			texture {Bricks_c}
		}
		cylinder {<0, 0.33, 0>, <0, 0.35, 0>, 0.09}
		object {Column rotate y*0}
		object {Column rotate y*45}
		object {Column rotate y*90}
		object {Column rotate y*135}
		object {Column rotate y*180}
		object {Column rotate y*225}
		object {Column rotate y*270}
		object {Column rotate y*315}
		cylinder {<0, 0.43, 0>, <0, 0.45, 0>, 0.09}
		cone {<0, 0.45, 0>, 0.13, <0, 0.5, 0>, 0.07
			texture {Roof_2}
		}
		cone {<0, 0.5, 0>, 0.07, <0, 0.95, 0>, 0
			texture {Roof_2}
		}
		sphere {<0, 0.95, 0>, 0.015}
		cylinder {<0, 0.95, 0>, <0, 1.1, 0>, 0.002}
		sphere {<0, 1.1, 0>, 0.005}
		translate y*0.6
	}
}

#declare Tower_tiny = union {
	intersection {
		plane {z, 0.12 rotate y*0}
		plane {z, 0.12 rotate y*45}
		plane {z, 0.12 rotate y*90}
		plane {z, 0.12 rotate y*135}
		plane {z, 0.12 rotate y*180}
		plane {z, 0.12 rotate y*225}
		plane {z, 0.12 rotate y*270}
		plane {z, 0.12 rotate y*315}
		plane {-y, 0}
		plane {y, 0.1}
	}
	intersection {
		plane {z, 0.1 texture {Bricks} rotate y*0}
		plane {z, 0.1 texture {Bricks} rotate y*45}
		plane {z, 0.1 texture {Bricks} rotate y*90}
		plane {z, 0.1 texture {Bricks} rotate y*135}
		plane {z, 0.1 texture {Bricks} rotate y*180}
		plane {z, 0.1 texture {Bricks} rotate y*225}
		plane {z, 0.1 texture {Bricks} rotate y*270}
		plane {z, 0.1 texture {Bricks} rotate y*315}
		plane {-y, -0.05}
		plane {y, 0.65}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12
			texture {Bricks_c}
		}
		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.11}
		cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.125}
		cylinder {<0, 0.18, 0>, <0, 0.19, 0>, 0.13}
		cylinder {<0, 0.19, 0>, <0, 0.20, 0>, 0.14}
		object {T_window}
		object {T_window rotate y*45}
		object {T_window rotate y*90}
		object {T_window rotate y*135}
		cone {<0, 0.2, 0>, 0.17, <0, 0.26, 0>, 0.09
			texture {Roof_2}
		}
		cone {<0, 0.26, 0>, 0.09, <0, 0.72, 0>, 0
			texture {Roof_2}
		}
		sphere {<0, 0.72, 0>, 0.015}
		translate y*0.6
	}
}

#declare Tower_middle = union {
	intersection {
		plane {z, 0.1 texture {Bricks} rotate y*0}
		plane {z, 0.1 texture {Bricks} rotate y*45}
		plane {z, 0.1 texture {Bricks} rotate y*90}
		plane {z, 0.1 texture {Bricks} rotate y*135}
		plane {z, 0.1 texture {Bricks} rotate y*180}
		plane {z, 0.1 texture {Bricks} rotate y*225}
		plane {z, 0.1 texture {Bricks} rotate y*270}
		plane {z, 0.1 texture {Bricks} rotate y*315}
		plane {-y, 0}
		plane {y, 1.1}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12
			texture {Bricks_c}
		}
		union {
			cylinder {<0, 0.1, 0>, <0, 0.11, 0>, 0.012}
			cylinder {<0, 0.11, 0>, <0, 0.2, 0>, 0.01}
			cylinder {<0, 0.2, 0>, <0, 0.21, 0>, 0.012}
			translate -z*0.08
		}
		union {
			cylinder {<0, 0.1, 0>, <0, 0.11, 0>, 0.012}
			cylinder {<0, 0.11, 0>, <0, 0.2, 0>, 0.01}
			cylinder {<0, 0.2, 0>, <0, 0.21, 0>, 0.012}
			translate -z*0.08
			rotate y*90
		}
		union {
			cylinder {<0, 0.1, 0>, <0, 0.11, 0>, 0.012}
			cylinder {<0, 0.11, 0>, <0, 0.2, 0>, 0.01}
			cylinder {<0, 0.2, 0>, <0, 0.21, 0>, 0.012}
			translate -z*0.08
			rotate y*180
		}
		union {
			cylinder {<0, 0.1, 0>, <0, 0.11, 0>, 0.012}
			cylinder {<0, 0.11, 0>, <0, 0.2, 0>, 0.01}
			cylinder {<0, 0.2, 0>, <0, 0.21, 0>, 0.012}
			translate -z*0.08
			rotate y*270
		}
		cylinder {<0, 0.21, 0>, <0, 0.22, 0>, 0.08}
		cone {<0, 0.22, 0>, 0.10, <0, 0.95, 0>, 0
			texture {Roof_2}
		}
		sphere {<0, 0.95, 0>, 0.015}
		cylinder {<0, 0.95, 0>, <0, 1.1, 0>, 0.002}
		sphere {<0, 1.1, 0>, 0.005}
		translate y*1.1
	}
	object {Subtower translate <0.13, 1.17, 0> rotate y*45}
	object {Subtower translate <0.13, 1.17, 0> rotate y*135}
	object {Subtower translate <0.13, 1.17, 0> rotate y*225}
	object {Subtower translate <0.13, 1.17, 0> rotate y*315}
}

#declare Tower_1 = union {
	object {Tower_small}
	object {Window translate y*0.15}
	object {Window translate y*0.4}
	object {Window translate y*0.15 rotate y*90}
	object {Window translate y*0.4 rotate y*90}
	translate <-1, 0, -0.5>
}

#declare Tower_2 = union {
	object {Tower_tiny}
	object {Window translate y*0.15}
	object {Window translate y*0.4}
	translate <0, 0, -0.5>
}

#declare Tower_3 = object {
	Tower_1
	translate <1, 0, 0.5>
	rotate -y*90
	translate <1, 0, -0.5>
}

#declare Tower_4 = union {
	object {Tower_middle}
	union {
		object {Window translate y*0.15}
		object {Window translate y*0.45}
		object {Window translate y*0.8}
	}
	union {
		object {Window translate y*0.15}
		object {Window translate y*0.45}
		object {Window translate y*0.8}
		rotate -y*90
	}
	union {
		object {Window translate y*0.15}
		object {Window translate y*0.45}
		object {Window translate y*0.8}
		rotate y*180
	}
	translate <0.55, 0, 0>
}

#declare Half_tower_5 = union {
	difference {
		intersection {
			box {<-0.15, 0.7, -0.17>, <0.15, 1.7, 0.17>}
			plane {y, 0 texture {Roof_1 rotate y*90} rotate z*65
				translate <-0.15, 1.3, 0>
			}
			plane {y, 0 texture {Roof_1 rotate -y*90} rotate -z*65
				translate <0.15, 1.3, 0>
			}
		}
		intersection {
			box {<-0.14, 0.6, -0.2>, <0.14, 1.7, -0.16>}
			plane {y, 0 rotate z*65 translate <-0.14, 1.3, 0>}
			plane {y, 0 rotate -z*65 translate <0.14, 1.3, 0>}
		}
		intersection {
			box {<-0.14, 0.6, 0.16>, <0.14, 1.7, 0.2>}
			plane {y, 0 rotate z*65 translate <-0.14, 1.3, 0>}
			plane {y, 0 rotate -z*65 translate <0.14, 1.3, 0>}
		}
		intersection {
			box {<-0.12, 0.6, -0.2>, <0.12, 1.7, -0.15>}
			plane {y, 0 rotate z*65 translate <-0.12, 1.3, 0>}
			plane {y, 0 rotate -z*65 translate <0.12, 1.3, 0>}
		}
		intersection {
			box {<-0.12, 0.6, 0.15>, <0.12, 1.7, 0.2>}
			plane {y, 0 rotate z*65 translate <-0.12, 1.3, 0>}
			plane {y, 0 rotate -z*65 translate <0.12, 1.3, 0>}
		}
	}
	difference {		// clock
		union {
			cylinder {<0, 1.3, -0.16>, <0, 1.3, 0.16>, 0.12}
			cylinder {<0, 1.3, -0.17>, <0, 1.3, 0.17>, 0.11}
		}
		cylinder {<0, 1.3, -0.2>, <0, 1.3, -0.16>, 0.10}
		cylinder {<0, 1.3, 0.16>, <0, 1.3, 0.2>, 0.10}
	}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*0 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*30 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*60 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*90 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*120 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*150 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*180 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*210 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*240 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*270 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*300 translate y*1.3}
	cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.015 rotate -z*330 translate y*1.3}

	cylinder {<0, 0.025, -0.165>, <0, 0.025, 0.165>, 0.025 scale <0.2, 1, 1> translate y*1.3}
	cylinder {<0.035, 0, -0.165>, <0.035, 0, 0.165>, 0.035 scale <1, 0.2, 1> translate y*1.3}

	box {<-0.12, 1.15, -0.16>, <0.12, 1.18, 0.16>}
	box {<-0.14, 1.16, -0.17>, <0.14, 1.17, 0.17>}
	union {
		difference {
			cylinder {<0, 1.04, -0.16>, <0, 1.04, 0.16>, 0.10}
			cylinder {<0, 1.04, -0.17>, <0, 1.04, 0.17>, 0.09}
			plane {y, 1.04}
		}
		difference {
			box {<-0.1, 0.8, -0.16>, <0.1, 1.04, 0.16>}
			box {<-0.09, 0.81, -0.2>, <0.09, 1.03, 0.2>}
		}
		box {<-0.0025, 0.81, -0.16>, <0.0025, 1.14, 0.16>}
		difference {
			union {
				box {<-0.045, 0.81, -0.16>, <-0.04, 1.14, 0.16>}
				box {<0.04, 0.81, -0.16>, <0.045, 1.14, 0.16>}
			}
			union {
				cylinder {<0, 1.04, -0.16>, <0, 1.04, 0.16>, 0.10}
				box {<-0.1, 0.8, -0.16>, <0.1, 1.04, 0.16>}
				inverse
			}
		}
	}
}

#declare Tower_5 = union {
	object {Half_tower_5}
	object {Half_tower_5 rotate y*90}
	intersection {
		plane {z, 0.1 texture {Bricks} rotate y*0}
		plane {z, 0.1 texture {Bricks} rotate y*45}
		plane {z, 0.1 texture {Bricks} rotate y*90}
		plane {z, 0.1 texture {Bricks} rotate y*135}
		plane {z, 0.1 texture {Bricks} rotate y*180}
		plane {z, 0.1 texture {Bricks} rotate y*225}
		plane {z, 0.1 texture {Bricks} rotate y*270}
		plane {z, 0.1 texture {Bricks} rotate y*315}
		plane {-y, -1.3}
		plane {y, 1.7}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12
			texture {Bricks_c}
		}
		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.11}
		cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.125}
		cylinder {<0, 0.18, 0>, <0, 0.19, 0>, 0.13}
		cylinder {<0, 0.19, 0>, <0, 0.20, 0>, 0.14}
		object {T_window}
		object {T_window rotate y*45}
		object {T_window rotate y*90}
		object {T_window rotate y*135}
		cone {<0, 0.2, 0>, 0.17, <0, 0.3, 0>, 0.08 texture {Roof_2}}
		cylinder {<0, 0.3, 0>, <0, 0.33, 0>, 0.08}
		cylinder {<0, 0.33, 0>, <0, 0.35, 0>, 0.09}
		object {Column rotate y*0}
		object {Column rotate y*45}
		object {Column rotate y*90}
		object {Column rotate y*135}
		object {Column rotate y*180}
		object {Column rotate y*225}
		object {Column rotate y*270}
		object {Column rotate y*315}
		cylinder {<0, 0.43, 0>, <0, 0.45, 0>, 0.09}
		cone {<0, 0.45, 0>, 0.13, <0, 0.5, 0>, 0.07 texture {Roof_2}}
		cone {<0, 0.5, 0>, 0.07, <0, 0.95, 0>, 0 texture {Roof_2}}
		sphere {<0, 0.95, 0>, 0.015}
		cylinder {<0, 0.95, 0>, <0, 1.1, 0>, 0.002}
		sphere {<0, 1.1, 0>, 0.005}
		translate y*1.7
	}
}

#declare Inbetween_1 = union {
	box {<-0.45, 0, -0.08>, <0.45, 0.05, 0.08>}
	box {<-0.45, 0.05, -0.06>, <0.45, 0.28, 0.06>
		texture {Bricks}
	}
	box {<-0.45, 0.28, -0.07>, <0.45, 0.3, 0.07>}
	intersection {
		plane {y, 0.5}
		plane {-y, -0.3}
		plane {-x, 0.45}
		plane {x, 0.45}
		plane {y, 0
			texture {Roof_1}
			rotate -x*74 translate -z*0.18
		}
		plane {y, 0
			texture {Roof_1}
			rotate x*74 translate z*0.18
		}
	}
	box {<-0.45, 0.5, -0.01>, <0.45, 0.51, 0.01>}
	box {<-0.45, 0.54, -0.01>, <0.45, 0.55, 0.01>}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.4}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.35}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.3}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.25}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.2}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.15}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.1}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.1}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.15}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.2}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.25}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.3}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.35}
	sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.4}
	difference {
		box {<-0.1, 0, -0.12>, <0.1, 0.7, 0.12>}
		plane {y, 0
			texture {Roof_1}
			rotate -x*68 translate <0, 0.3, -0.12> inverse
		}
		plane {y, 0
			rotate x*68 translate <0, 0.3, 0.12> inverse
			texture {Roof_1}
		}
	}
	difference {
		box {<-0.08, 0, -0.14>, <0.08, 0.7, 0.14>}
		plane {y, 0
			texture {Roof_1 rotate -y*90}
			rotate -z*73 translate <0.08, 0.3, 0> inverse
		}
		plane {y, 0
			texture {Roof_1 rotate y*90}
			rotate z*73 translate <-0.08, 0.3, 0> inverse
		}
		box {<-0.06, 0.01, -0.16>, <0.06, 0.3, -0.13>}
		box {<-0.04, 0.02, -0.16>, <0.04, 0.29, -0.12>}
		intersection {
			box {<-0.06, 0.3, -0.16>, <0.06, 0.6, -0.13>}
			plane {y, 0 rotate -z*73 translate <0.08, 0.25, 0>}
			plane {y, 0 rotate z*73 translate <-0.08, 0.25, 0>}
		}
	}
	box {<-0.002, 0.02, -0.128>, <0.002, 0.29, 0.136>}
	box {<-0.04, 0.05, -0.128>, <0.04, 0.054, 0.136>}
	box {<-0.04, 0.1, -0.128>, <0.04, 0.104, 0.136>}
	box {<-0.04, 0.15, -0.128>, <0.04, 0.154, 0.136>}
	box {<-0.04, 0.2, -0.128>, <0.04, 0.204, 0.136>}
	box {<-0.04, 0.25, -0.128>, <0.04, 0.254, 0.136>}
	difference {
		cylinder {<0, 0.35, -0.132>, <0, 0.35, 0.132>, 0.04}
		cylinder {<0, 0.35, -0.16>, <0, 0.35, 0.16>, 0.01}
	}
	difference {
		cylinder {<0, 0.35, -0.134>, <0, 0.35, 0.134>, 0.03}
		cylinder {<0, 0.35, -0.16>, <0, 0.35, 0.16>, 0.02}
	}
	difference {
		box {<-0.06, 0, -0.08>, <0.06, 0.2, 0>}
		plane {y, 0 texture {Roof_1 rotate y*90} rotate z*70
			translate -x*0.06 inverse
		}
		plane {y, 0 texture {Roof_1 rotate -y*90} rotate -z*70
			translate x*0.06 inverse
		}
		intersection {
			plane {z, -0.076}
			plane {y, 0 rotate z*70 translate -x*0.06}
			plane {y, 0 rotate -z*70 translate x*0.06}
			translate -y*0.01
		}
		translate <-0.25, 0.3, 0>
	}
	difference {
		box {<-0.06, 0, -0.08>, <0.06, 0.2, 0>}
		plane {y, 0 texture {Roof_1 rotate y*90} rotate z*70
			translate -x*0.06 inverse
		}
		plane {y, 0 texture {Roof_1 rotate -y*90} rotate -z*70
			translate x*0.06 inverse
		}
		intersection {
			plane {z, -0.076}
			plane {y, 0 rotate z*70 translate -x*0.06}
			plane {y, 0 rotate -z*70 translate x*0.06}
			translate -y*0.01
		}
		translate <0.25, 0.3, 0>
	}
	object {Window translate <-0.32, 0.1, 0.04>}
	object {Window translate <-0.18, 0.1, 0.04>}
	object {Window translate <0.32, 0.1, 0.04>}
	object {Window translate <0.18, 0.1, 0.04>}
}

#declare Inbetween_2 = union {
	box {<-0.45, 0, -0.08>, <0.45, 0.35, 0.08>}
	box {<-0.45, 0.35, -0.06>, <0.45, 0.68, 0.06>}
	box {<-0.45, 0.68, -0.07>, <0.45, 0.7, 0.07>}
	intersection {
		plane {y, 1}
		plane {-y, -0.7}
		plane {-x, 0.5}
		plane {x, 0.5}
		plane {y, 0 texture {Roof_1} rotate -x*78 translate <0, 0.5, -0.14>}
		plane {y, 0 texture {Roof_1} rotate x*78 translate <0, 0.5, 0.14>}
	}
	box {<-0.45, 1, -0.01>, <0.45, 1.01, 0.01>}
	box {<-0.45, 1.04, -0.01>, <0.45, 1.05, 0.01>}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.45}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.4}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.35}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.3}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.25}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.2}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*0.15}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.15}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.2}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.25}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.3}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.35}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.4}
	sphere {<0, 1.025, 0>, 0.0225 scale <0.4, 1, 0.4> translate x*0.45}
	difference {
		intersection {
			box {<-0.4, 0, -0.25>, <0.4, 1.1, 0.25>}
			plane {y, 0 texture {Roof_1 rotate -y*90} rotate -z*37
				translate <0.4, 0.7, 0>
			}
			plane {y, 0 texture {Roof_1 rotate y*90} rotate z*37
				translate <-0.4, 0.7, 0>
			}
		}
		intersection {
			box {<-0.45, 0.35, -0.3>, <0.45, 1.1, -0.23>}
			plane {y, 0 rotate -z*37 translate <0.4, 0.7, 0>}
			plane {y, 0 rotate z*37 translate <-0.4, 0.7, 0>}
			translate -y*0.01
		}
		intersection {
			box {<-0.38, 0.35, -0.3>, <0.38, 1.1, -0.22>}
			plane {y, 0 rotate -z*37 translate <0.4, 0.7, 0>}
			plane {y, 0 rotate z*37 translate <-0.4, 0.7, 0>}
			translate -y*0.02
		}
	}
	difference {
		union {
			cylinder {<0, 0.8, -0.23>, <0, 0.8, 0.23>, 0.11}
			box {<-0.11, 0.35, -0.23>, <0.11, 0.8, 0.23>}
		}
		union {
			cylinder {<0, 0.8, -0.25>, <0, 0.8, 0.25>, 0.1}
			box {<-0.1, 0.36, -0.25>, <0.1, 0.81, 0.25>}
		}
	}
	difference {
		union {
			cylinder {<-0.175, 0.75, -0.23>, <-0.175, 0.75, 0.23>, 0.055}
			box {<-0.23, 0.35, -0.23>, <-0.12, 0.75, 0.23>}
		}
		union {
			cylinder {<-0.175, 0.75, -0.25>, <-0.175, 0.75, 0.25>, 0.045}
			box {<-0.22, 0.36, -0.25>, <-0.13, 0.76, 0.25>}
		}
	}
	difference {
		union {
			cylinder {<-0.175, 0.75, -0.23>, <-0.175, 0.75, 0.23>, 0.055}
			box {<-0.23, 0.35, -0.23>, <-0.12, 0.75, 0.23>}
		}
		union {
			cylinder {<-0.175, 0.75, -0.25>, <-0.175, 0.75, 0.25>, 0.045}
			box {<-0.22, 0.36, -0.25>, <-0.13, 0.76, 0.25>}
		}
		rotate y*180
	}
	difference {
		union {
			cylinder {<-0.295, 0.66, -0.23>, <-0.295, 0.66, 0.23>, 0.055}
			box {<-0.295-0.055, 0.35, -0.23>, <-0.24, 0.66, 0.23>}
		}
		union {
			cylinder {<-0.295, 0.66, -0.25>, <-0.295, 0.66, 0.25>, 0.045}
			box {<-0.295-0.045, 0.36, -0.25>, <-0.25, 0.67, 0.25>}
		}
	}
	difference {
		union {
			cylinder {<-0.295, 0.66, -0.23>, <-0.295, 0.66, 0.23>, 0.055}
			box {<-0.295-0.055, 0.35, -0.23>, <-0.24, 0.66, 0.23>}
		}
		union {
			cylinder {<-0.295, 0.66, -0.25>, <-0.295, 0.66, 0.25>, 0.045}
			box {<-0.295-0.045, 0.36, -0.25>, <-0.25, 0.67, 0.25>}
		}
		rotate y*180
	}
	difference {
		union {
			box {<-0.005, 0.3, -0.23>, <0.005, 0.9, 0.23>}
			box {<-0.06, 0.3, -0.23>, <-0.05, 0.9, 0.23>}
			box {<-0.06, 0.3, -0.23>, <-0.05, 0.9, 0.23> rotate y*180}
			box {<-0.1775, 0.3, -0.23>, <-0.1725, 0.9, 0.23>}
			box {<-0.1775, 0.3, -0.23>, <-0.1725, 0.9, 0.23> rotate y*180}
			box {<-0.2975, 0.3, -0.23>, <-0.2925, 0.9, 0.23>}
			box {<-0.2975, 0.3, -0.23>, <-0.2925, 0.9, 0.23> rotate y*180}
			box {<-0.4, 0.8, -0.23>, <0.4, 0.81, 0.23>}
			box {<-0.4, 0.7, -0.23>, <0.4, 0.71, 0.23>}
			box {<-0.4, 0.6, -0.23>, <0.4, 0.61, 0.23>}
			box {<-0.4, 0.5, -0.23>, <0.4, 0.51, 0.23>}
			box {<-0.4, 0.4, -0.23>, <0.4, 0.41, 0.23>}
		}
		union {
			union {
				cylinder {<0, 0.8, -0.25>, <0, 0.8, 0.25>, 0.1}
				box {<-0.1, 0.36, -0.25>, <0.1, 0.81, 0.25>}
			}
			union {
				cylinder {<-0.175, 0.75, -0.25>, <-0.175, 0.75, 0.25>, 0.045}
				box {<-0.22, 0.36, -0.25>, <-0.13, 0.76, 0.25>}
			}
			union {
				cylinder {<-0.175, 0.75, -0.25>, <-0.175, 0.75, 0.25>, 0.045}
				box {<-0.22, 0.36, -0.25>, <-0.13, 0.76, 0.25>}
				rotate y*180
			}
			union {
				cylinder {<-0.295, 0.66, -0.25>, <-0.295, 0.66, 0.25>, 0.045}
				box {<-0.295-0.045, 0.36, -0.25>, <-0.25, 0.67, 0.25>}
			}
			union {
				cylinder {<-0.295, 0.66, -0.25>, <-0.295, 0.66, 0.25>, 0.045}
				box {<-0.295-0.045, 0.36, -0.25>, <-0.25, 0.67, 0.25>}
				rotate y*180
			}
			inverse
		}
	}
}

#declare Wall_half = union {
	object {Tower_1}
	object {Tower_2}
	object {Tower_3}
	object {Inbetween_1 translate <-0.5, 0, -0.5>}
	object {Inbetween_1 translate <0.5, 0, -0.5>}
	object {Inbetween_1 rotate y*90 translate <-1, 0, 0>}
}

#declare Castle = union {
	object {Wall_half}
	object {Wall_half rotate y*180}
	object {Tower_4}
	object {Tower_4 rotate y*180}
	object {Inbetween_2}
	object {Tower_5}
	texture {Goldish}
}

