// Scene File: MAYADAY.POV for POV-Ray v2.x
// #1 of the Maya Series....In the beginning

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"
#include "maya2.inc"

 camera {
   up <0,1,0>
   right <4/3, 0, 0>
   direction <0, 0, 1.149921> //Lens_50mm
   location <5, 1, -7> 
   look_at <-.2, 2, 0>
}

height_field {
   gif "mayatree.gif" 
   water_level 0

   pigment {
      image_map { gif "mayatree.gif"}
      quick_color White
      rotate 90*x
      scale <320.0, 1.0, 200.0>
      translate <0.0, .0, 0>
   }

   scale <300, 256, 200>
   scale <.4, .06, .3> 
   translate <-100, -9, 0.0>
    rotate -20*y
   translate <0, 0.0, 29.0>
}

fog {
  color Gray70
  distance 60
}

plane {z,0
  pigment {
   gradient y
   color_map {
    [.01 color rgb<.33, 0, .28>]
    [.099 color rgb<.94, .56, .33>]
   }
  }
   scale <120, 90, 120>
   translate <0, 0, 45>
 }

plane {y,0  //ball yard
 texture {Stone9
  scale <.15, .15, .15>
  }
}

union {
 object {
  pyramid
 }
 object {
  ramp1
  }
 object {
   stair1 
 }
 object {
  ramp2
  }
 object {
  stair1
  rotate <0, -90, 0>
 }
}

light_source {<3, 4, -6> color White }

light_source {
    <50, .02, -70>
    color Orange
   spotlight
    point_at < 0, .6, 0>
    tightness 1
    radius 15
    falloff 17 
}

//  horizon
box { <-15, -1, -1>, <165, 1, 1>
  pigment {color VeryDarkBrown}
  scale <1.0, 1.5, .01> 
  translate <0.0, .5, -7.1>
}

// LIGHT_SOURCE
light_source {<4, 3, -4> color CoolCopper}
