// Persistence of Vision Raytracer
/* MOONSET.DAT - By Brian Malcolm --- This is a rather direct copy of
  the great file SUNSET.DAT included with the DKB package.  I've simply
  changed the sky color to Black, mapped a star field onto it, changed
  the water color to something darker, and mapped a lunar landscape onto
  the light source.

  CRADLE.POV: Many changes made to the original moonset. I am trying to
  illustrate a scene from the opening of the book 'Cradle' by Arthur C.
  Clarke.  Jay Sprenkle  July 1992
*/

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

camera {
   location  < 0.0       10.0   200.0 >
   direction < 0.0        0.0     1.0 >
   up        < 0.0        1.0     0.0 >
   right     < 1.333333   0.0     0.0 >
   look_at   < 0.0      130.0  -300.0 >
 }

//camera {
//   location  < 0.0       10.0   200.0 >
//   direction < 0.0        0.0    -1.0 >
//   up        < 0.0        1.0     0.0 >
//   right     < 1.333333   0.0     0.0 >
//   look_at   < 0.0      130.0  -300.0 >
// }

/* define the ocean surface */
object {
   plane { <0.0  1.0  0.0> -10.0  }

   texture {
//      colour SeaGreen  ++djs, changed to blue ocean
      color DarkSlateBlue
      waves 0.05
      frequency 5000.0
      scale <3000.0 3000.0 3000.0>
      reflection 1.0
      ambient 0.3
      diffuse 0.15
    }
 }

/* put a floor underneath to catch any errant waves from the ripples */
object {
   plane { <0.0  1.0  0.0> -11.0  }
   texture {
      0.05
//      colour SeaGreen
      color DarkSlateBlue
      ambient 1.0
      diffuse 0.0
    }
 }

object {
   height_field { gif "fract003.gif" water_level 101.0  }
   scale <320 256 200>
   texture
     {
       image_map { <1.0 0.0 -1.0> gif "fract003.gif"  }
       scale <320.0 1.0 200.0>
       translate <0.0 0.0 -1.0>
     }

   scale <2.0 0.5 2.0>
   translate <-160.0 -63.5 -100.0>
   rotate <0.0 10.0 0.0>
   translate <-80.0 0.0 -30.0>

   colour White
}

/* now draw the sky */
object {
   sphere { <0.0  0.0  0.0> 300.0
    }
   texture {
      gradient <0.0  1.0  0.0>
      color Black
      image_map { <1.0 -1.0 0.0> gif "morestrs.gif"  }  /*320x200*/
      scale <50.0 50.0 50.0>
      ambient 0.3
      diffuse 0.7   /* we don't want clouds casting shadows on the sky */
    }
 }

///* put in a few clouds */
//object {
//   sphere { <0.0  0.0  0.0> 259.0  }
//   texture {
//      bozo
//      turbulence 0.5
//      colour_map {
//          [0.0 0.6  colour red 1.0 green 1.0 blue 1.0 alpha 1.0
//                    colour red 1.0 green 1.0 blue 1.0 alpha 1.0]
//          [0.6 0.8 colour red 1.0 green 1.0 blue 1.0 alpha 1.0
//                    colour red 1.0 green 1.0 blue 1.0]
//          [0.8 1.001 colour red 1.0 green 1.0 blue 1.0
//                     colour red 0.8 green 0.8 blue 0.8]
//       }
//      scale <100.0  20.0  100.0>
//      ambient 0.5
//      diffuse 0.0
//    }
//   colour red 0.7 green 0.7 blue 1.0
// }

object
  {
    light_source { < 0.0 200.0 0.0 > color White }
  }

// The moon, a light source within a sphere
// with an image of the moon pasted over the top
object
  {
    union
      {
        light_source { < 0.0  0.0  0.0> color White }
        sphere       { < 0.0  0.0  0.0> 40.0  }
      }
    texture
      {
        colour White
        image_map { <1.0 -1.0 0.0> gif "moon1.gif"  }
        scale  < 140.0 140.0 140.0 >
        rotate <   0.0  30.0   0.0 >
        /* so the moon doesn't appear symmetrical, rotate it */
        ambient 1.0
        diffuse 0.0
      }
    no_shadow  // light escapes sphere and it casts no shadow on scene
    translate < 0.0  60.0  -300.0 >
  }
