/* Data file for two dolphins leaping over the water in the moonlight.
   Render at 800X600 with +a0.1 for good results. Robert A. Mickelsen

  changes by Jay Sprenkle for an animation:
    changes to dolphin colors to make them look more like bottle noses
    changed ocean to blue
    changed tilt on ocean so it is flat (wierd!)
  */
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "dolphin.inc"

#include "dolf.inc"   // include animation variables

camera
  {
    location  <2     4.0  -9  >
    direction <0     0.0   1.5>
    up        <0     1.0   0  >
    right     <1.33  0.0   0  >
    look_at   <2     2.0   2  >
  }

object {
  light_source { 
    <-6 7.5 10> 
    color Gray  
    spotlight
    point_at <0 1.75 1>
    tightness 80
    radius 10 
    falloff 18
  }
}

object
  {
    light_source
      {
        <0 5.06 23>
        color Gray
        spotlight
        point_at <6 -5 12>
        tightness 80 
        radius 10
        falloff 18
      }
  }

composite
  {
    Dolphin
    rotate      <    0.000    0.000   ANGLE1 >
    rotate      <    0.000 -150.000    0.000 >  // front view
    translate   <    0.000    1.750    1.000 >
  }

composite
  {
    Dolphin
    rotate      <    0.000    0.000   ANGLE2 >
    rotate      <    0.000 -150.000    0.000 >  // front view
    translate   <    6.000    2.000   12.000 >
  }

object {
  sphere {<0 0 0> 1000}
  texture {
    image_map
      {
        gif "morestrs.gif"
        map_type 0
        interpolate 2
      }
    translate <-0.5 -0.65 0>
    scale       <  350.000  350.000  350.000 >
  }
}

object { 
  union {
    sphere {<-80 -115 250> 15
      texture {
        color White alpha .35
        ambient 1.0
        diffuse 0.0
      }
    }
    light_source {<-80 -115 250> color White}
    light_source {<-80 -115 275> color White}
  }
}

object
  {
    plane
      {
        <0 1 0> -.25
      }
    texture
      {
        color Aquamarine
        ripples .35
        frequency 100
        turbulence .5
        ambient .1
        diffuse .1
        reflection .7
        specular .5
        scale <40 40 40>
        roughness .03
        phase  RIPPLE
      }
  }

