
// Include file for Strange Suburbs c. Jack Gritton, 1995

#declare JClouds =                       // Modified from Bright_Blue_Sky
 pigment {
   bozo
   turbulence 0.56
   color_map 
    {[0.0, 0.5  colour Clear
		colour Clear]
     [0.5, 0.6  colour Clear
		color red 1.0 green 1.0 blue 1.0]
     [0.6, 1.01 color red 1.0 green 1.0 blue 1.0
		color red 0.5 green 0.5 blue 0.5]
    }
  }

#declare Gyramid = intersection {
   plane { < 1, 0,  0>, 1  rotate <  0, 0,  40>}
   plane { <-1, 0,  0>, 1  rotate <  0, 0, -40>}
   plane { < 0, 0,  1>, 1  rotate <-40, 0,   0>}
   plane { < 0, 0, -1>, 1  rotate < 40, 0,   0>}
   plane { <0, -1, 0>, 0.1 }
   scale 6
   texture { Glass3 }
}


#declare Balls = union {
	sphere { <8,0.95,8>,1.0 }
	sphere { <-8,0.95,8>,1.0 }
	sphere { <-8,0.95,-8>,1.0 }
	sphere { <8,0.95,-8>,1.0 }
	sphere { <6,3.2,6>,0.8 }
	sphere { <6,3.2,-6>,0.8 }
	sphere { <-6,3.2,-6>,0.8 }
	sphere { <-6,3.2,6>,0.8 }          
	sphere { <4,5.39,4>,0.6 }
	sphere { <-4,5.39,4>,0.6 }
	sphere { <-4,5.39,-4>,0.6 }
	sphere { <4,5.39,-4>,0.6 }
	sphere { <2,7.5,2>,0.4 }
	sphere { <2,7.5,-2>,0.4 }
	sphere { <-2,7.5,-2>,0.4 }
	sphere { <-2,7.5,2>,0.4 }
	sphere { <0,9.5,0>,0.2 }
	sphere { <0,9.8,0>,0.1 }
	sphere { <0,9.95,0>,0.05 }
	texture { Polished_Chrome }
	}

#declare Rods = union {
	cylinder { <-8,0.95,8>,<8,0.95,8>,0.4 }
	cylinder { <-8,0.95,8>,<-8,0.95,-8>,0.4 }
	cylinder { <-8,0.95,-8>,<8,0.95,-8>,0.4 }
	cylinder { <8,0.95,-8>,<8,0.95,8>,0.4 }
	cylinder { <-6,3.2,6>,<6,3.2,6>,0.3 }
	cylinder { <-6,3.2,6>,<-6,3.2,-6>,0.3 }
	cylinder { <-6,3.2,-6>,<6,3.2,-6>,0.3 }
	cylinder { <6,3.2,-6>,<6,3.2,6>,0.3 }
	cylinder { <-4,5.39,4>,<4,5.39,4>,0.2 }
	cylinder { <-4,5.39,4>,<-4,5.39,-4>,0.2 }
	cylinder { <-4,5.39,-4>,<4,5.39,-4>,0.2 }
	cylinder { <4,5.39,-4>,<4,5.39,4>,0.2 }
	cylinder { <-2,7.5,2>,<2,7.5,2>,0.1 }
	cylinder { <-2,7.5,2>,<-2,7.5,-2>,0.1 }
	cylinder { <-2,7.5,-2>,<2,7.5,-2>,0.1 }
	cylinder { <2,7.5,-2>,<2,7.5,2>,0.1 }
	texture { DMFLightOak
			finish { reflection 0.2 phong 0.5 }
			scale 0.5
			rotate <20,20,20>
			}
		}

#declare Pipes = union {
	cone { <0,7.5,-2>,0.09,<0,1,-8>,0.34 }
	cone { <0,7.5,2>,0.09,<0,1,8>,0.34 }
	cone { <-2,7.5,0>,0.09,<-8,1,0>,0.34 }
	cone { <2,7.5,0>,0.09,<8,1,0>,0.34 }
	texture { New_Brass }
		}
	     
#declare cut_grid = union {
		object { Gyramid scale 0.95 }
		box { <-15,0,-0.2>,<15,15,0.2> rotate y*45 }
		box { <-15,0,-0.2>,<15,15,0.2> rotate y*-45 }
		box { <-15,0,-15>,<15,1.2,15> }
		box { <-15,2.95,-15>,<15,3.45,15> }  
		box { <-15,5.14,-15>,<15,5.64,15> }  
		box { <-15,7.25,-15>,<15,7.75,15> }  
		texture { Glass3 }
		}

#declare Panes = difference {
		object { Gyramid }
		object { cut_grid }
		}

#declare City_Line = union {
        box { <-1000,0,-2300>,<-800,1000,-2200> pigment { 
					image_map { gif "city.gif" }
					scale 90 } }
        box { <-800,0,-2300>,<-700,900,-2250> pigment { Gray40 } }
        box { <-700,0,-2300>,<-600,950,-2200> pigment { Gray60 } }
        box { <-600,0,-2300>,<-500,900,-2260> pigment { Gray50 } }
        box { <-500,0,-2300>,<-350,1100,-2200> pigment {
					image_map { gif "city.gif" }
					rotate z*90
					scale 50 } } 
        box { <-350,0,-2300>,<-250,800,-2200> pigment { Gray60 } }
        box { <-250,0,-2300>,<-130,850,-2200> pigment {
					image_map { gif "city.gif" }
					scale 30 } }
        box { <-130,0,-2300>,<10,950,-2250> pigment { Gray80 } }
        box { <10,0,-2300>,<210,760,-2200> pigment {
					image_map { gif "city.gif" }
					scale 100 } }
        box { <210,0,-2300>,<390,1150,-2200> pigment { Gray50 } }
        box { <390,0,-2300>,<610,1500,-2200> pigment {
					image_map { gif "city.gif" }
					rotate z*180 } }
        box { <610,0,-2300>,<760,1050,-2270> pigment { Gray70 } }
        box { <760,0,-2300>,<1000,950,-2200> pigment { Gray50 } }
           }

#declare Crack2 =			//Put in here rather than
texture {				//including the whole stones.inc
pigment
 {granite
  turbulence 0.8
  color_map
   {[0.0, 0.5   color Clear color Clear]
    [0.5, 0.54   color Clear color Black]
    [0.54, 1.0 color Clear color Clear]
   }
 }
 }

