// Jack Gritton, 1995   
// Strange Suburbs
		 
#include "colors.inc"   //The include files contain
#include "shapes.inc"   //predefined scene elements
#include "textures.inc"
#include "ssuburbs.inc"  // Object Include file

camera {
	location <-150,550,-2100>
        direction <0,0,1>
	look_at <-150,350,0>
	}

light_source { <1000,2000,-700>  // Main scene light
		colour White    
		}

light_source { <0,40,-5000>   //Provides sharper relief for city skyline
                color Orange  //and a nice sunset effect
		}

light_source { <0,30,-4500>
		colour Red
		}

sphere { <0,-40120,0>, 44110      // Clouds
	texture { JClouds 
		scale 1750
			}
	finish { ambient 0.28 }
	}

sphere { <0,0,0>,1     // Gradient sphere to assist with distance illusion
	pigment {
		gradient y
		color_map {
			    [0.91 colour White]
                            [0.94 colour rgb <0.6,0.6,1.0> ]
                            [0.97 colour rgb <0.5,0.5,0.9> ]
                            [1.0 colour rgb <0.4,0.4,0.8> ]
			    }
                turbulence 0.05
		}
	no_shadow
	scale 44000
	translate <0,-40000,0>
	}

plane { y,0
	pigment { colour red 0.9 blue 0.9 green 1.0 }
	normal 	{
		bump_map {
		gif "cracks.gif"
                bump_size 300 }
                rotate x*90
                scale 900
		}
	 }

#declare Archi = union {

	object { Rods }
	object { Balls }
	object { Panes }
	object { Pipes }
	}                                      

object { City_Line scale <1.5,1.5,1> translate <-4000,0,0> } // City skyline
object { City_Line scale <1.5,1.5,1> translate <-2000,0,0> }        
object { City_Line scale <1.5,1.5,1> }  
object { City_Line scale <1.5,1.5,1> translate <2000,0,0> }  
object { City_Line scale <1.5,1.5,1> translate <4000,0,0> }

object { Archi
	rotate y*30        
	scale 100
	}
  
