/*** Balustrade object *****************************************/

#declare BalusterTex = texture { Stone3 scale 1/2 }

#declare BalusRailingTex = texture { Stone7 scale 1/2 }

#declare Baluster =
  union {
    box { <-0.35, 0.00, -0.35>, <0.35, 0.25, 0.35> }

    difference {
      cylinder { (y * 0.25), (y * 0.75), 0.25 }
      torus { 0.5125, 0.3625 translate (y * 0.50) }

      bounded_by { cylinder { (y * 0.25), (y * 0.75), 0.25 } }
    } // difference

    union {
      cylinder { (y * 0.75), (y * 0.95), 0.25 }
      torus { 0.25, 0.10 translate (y * 0.85) }

      bounded_by { cylinder { (y * 0.75), (y * 0.95), 0.35 } }
    } // union

    difference {
      cylinder { (y * 0.95), (y * 1.3768), 0.3276 }
      torus { 1.4625, 1.2125 translate (y * 0.95) }

      bounded_by { cylinder { (y * 0.94), (y * 1.40), 0.33 } }
    } // difference

    sphere { (y * 1.50), 0.35 }

    difference {
      cylinder { (y * 1.56930693), (y * 2.50), 0.34306931 }
      torus { 4.95, 4.70 translate (y * 2.50) }

      bounded_by { cylinder { (y * 1.56), (y * 2.51), 0.35 } }
    } // difference

    difference {
      cylinder { (y * 2.50), (y * 2.80), 0.25 }
      torus { 0.25, 0.05 translate (y * 2.55) }

      bounded_by { cylinder { (y * 2.50), (y * 2.80), 0.25 } }
    } // difference

    torus {
      0.25, 0.10

      bounded_by { cylinder { (y * -0.10), (y * 0.10), 0.35 } }

      translate (y * 2.70)
    } // torus

    bounded_by { box { <-0.35, 0.00, -0.35>, <0.35, 2.80, 0.35> } }
  } // union

#declare BalusRailing =
  union {
    cylinder { <-4.00, 2.825, -0.35>, <4.00, 2.825, -0.35>, 0.025 }
    cylinder { <-4.00, 2.825,  0.35>, <4.00, 2.825,  0.35>, 0.025 }

    difference {
      box { <-4.00, 2.80, -0.35>, <4.00, 3.00, 0.35> }

      cylinder { <-4.10, 2.90, -0.35>, <4.10, 2.90, -0.35>, 0.05 }
      cylinder { <-4.10, 2.90,  0.35>, <4.10, 2.90,  0.35>, 0.05 }
    } // difference

    cylinder { <-4.00, 2.975, -0.35>, <4.00, 2.975, -0.35>, 0.025 }
    cylinder { <-4.00, 2.975,  0.35>, <4.00, 2.975,  0.35>, 0.025 }

    texture { BalusRailingTex }

    bounded_by { box { <-4.00, 2.80, -0.40>, <4.00, 3.00, 0.40> } }
  } // union

#declare Balustrade =
  union {
    object { BalusRailing }

    union {
      object { Baluster translate (x *  0.00) }
      object { Baluster translate (x * -1.35) }
      object { Baluster translate (x *  1.35) }
      object { Baluster translate (x * -2.70) }
      object { Baluster translate (x *  2.70) }

      texture { BalusterTex }
    } // union

    bounded_by { box { <-4.00, 0.00, -0.40>, <4.00, 3.00, 0.40> } }
  } // union

/*** BalustradeWall object *************************************/

#declare BalustradeWall =
  union {
    object { Balustrade translate (x * -8) }
    object { Balustrade translate (x *  0) }
    object { Balustrade translate (x *  8) }

    bounded_by { box { <-12, 0, -0.4>, <12, 3, 0.4> } }
  } // union
