/*** Wall object ***********************************************/

#declare WallTex = texture { Stone2 scale 2 }

#declare Wall = plane { -x, -20 texture { WallTex } }

/*** Ceiling object ********************************************/

#declare CeilingTex = texture { Stone2 scale 3 }

#declare CeilingDecorTex = texture { Stone10 scale 1/2 }

#declare CeilingDecorBlock =
  union {
    cylinder { <-10, 19.8, 11>, <10, 19.8, 11>, 0.05 }

    intersection {
      torus { 1, 0.05 }
      plane { -x, 0 }
      plane {  z, 0 }

      bounded_by { box { <0, -0.05, -1.05>, <1.05, 0.05, 0> } }

      translate <-11, 19.8, 11>
    } // intersection

    sphere { <-11, 19.8, 10>, 0.05 }
    sphere { <-10, 19.8, 11>, 0.05 }

    bounded_by { box { <-11.05, 19.75, 9.95>, <10.00, 19.85, 11.05> } }
  } // union

#declare Ceiling =
  union {
    plane { -y, -19.8 texture { CeilingTex } }

    union {
      object { CeilingDecorBlock rotate (y *   0) }
      object { CeilingDecorBlock rotate (y *  90) }
      object { CeilingDecorBlock rotate (y * 180) }
      object { CeilingDecorBlock rotate (y * 270) }

      texture { CeilingDecorTex }

      bounded_by { box { <-11.05, -19.75, -11.05>, <11.05, 19.85, 11.05> } }
    } // union
  } // union

/*** Floor object **********************************************/

#declare FloorTex = texture { Stone20 scale 10 }

#declare Floor = plane { y, 0 texture { FloorTex } }

/*** FirstFloor object *****************************************/

#declare FirstFloorTex = texture { Stone23 scale 3 }

#declare FirstFloorBlock =
  union {
    box { <-20.00, 9.80, -0.65>, <12.00, 10.00, 8.00> }
    cylinder { <-12.00, 9.90, -0.65>, <12.00, 9.90, -0.65>, 0.10 }

    bounded_by { box { <-20.00, 9.80, -0.75>, <12.00, 10.00, 8.00> } }
  } // union

#declare FirstFloor =
  union {
    object { FirstFloorBlock translate (z * 12) rotate (y *   0) }
    object { FirstFloorBlock translate (z * 12) rotate (y *  90) }
    object { FirstFloorBlock translate (z * 12) rotate (y * 180) }
    object { FirstFloorBlock translate (z * 12) rotate (y * 270) }

    texture { FirstFloorTex }
  } // union
