#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "room.inc"
#include "ionic.inc"
#include "columns.inc"
#include "arches.inc"
#include "balustra.inc"
#include "stair.inc"

camera {
  location  (z * -30)
  direction (z * 30)
  up        (y * 27)      // These *are* 4:3 proportions!
  right     (x * 36)
  look_at   <0, 0, 0>

  rotate (y * -40)
  translate <-12, 10, 12>
} // camera

object { Floor }
object { FirstFloor }
object { Ceiling }

object { Wall rotate (y *   0) }
object { Wall rotate (y *  90) }
object { Wall rotate (y * 180) }
object { Wall rotate (y * 270) }

object { Columns }

object { Arches translate <0,  0, 12> rotate (y *   0) }
object { Arches translate <0,  0, 12> rotate (y *  90) }
object { Arches translate <0,  0, 12> rotate (y * 180) }
object { Arches translate <0,  0, 12> rotate (y * 270) }

object { Arches translate <0, 10, 12> rotate (y *   0) }
object { Arches translate <0, 10, 12> rotate (y *  90) }
object { Arches translate <0, 10, 12> rotate (y * 180) }
object { Arches translate <0, 10, 12> rotate (y * 270) }

object { BalustradeWall translate <0, 10, 12> rotate (y *   0) }
object { BalustradeWall translate <0, 10, 12> rotate (y *  90) }
object { BalustradeWall translate <0, 10, 12> rotate (y * 180) }

union {
  object { Balustrade translate <-8, 10, 12> }
  object { Balustrade translate < 8, 10, 12> }

  rotate (y * 270)
} // union

object { StairSupport translate <-12, 10, -3> }
object { StairSupport translate <-12, 10,  3> }

object { StairSupport translate <3, 5, -3> }
object { StairSupport translate <3, 5,  3> }

object { StairBlock rotate (y * 270) translate < 0, 0, -12> }
object { StairBlock rotate (y * 180) translate <12, 0,   0> }
object { StairBlock rotate (y *  90) translate < 0, 0,  12> }
object { StairBlock rotate (y * 180) translate <-3, 5,   0> }

object { StairFloor }
