// file top_cabinets.pov

// ============================================================
// Top cabinets
//
// ============================================================
//
//         +----------+
//         |    2     |
//         |----+-----+
//         | 1  |           
//         +----+
//
//
//         +----+
//         | 3  |           
//         |    |           
//
// ============================================================

#declare upper_cabinet_bottom = counter_height + 15
#declare upper_cabinet_top    = kitchen_height - 15

// ============================================================
// cabinet 1
// ============================================================

box      { <  1,          upper_cabinet_bottom, 0 >
           < (1*FEET)+11, upper_cabinet_top,    1 >
           texture { WhiteEnamelOnWood } }

box      { < (1*FEET)+11, upper_cabinet_bottom, 0        >
           < (2*FEET),    upper_cabinet_top,    (1*FEET) >
           texture { WhiteEnamelOnWood } }

box      { < (1*FEET),   upper_cabinet_bottom + 1,    11 >
           < (1*FEET)+1, upper_cabinet_bottom + 11.5, 12 >
           texture { WhiteEnamelOnWood } }

box      { < (1*FEET),   upper_cabinet_bottom + 12.5, 11 >
           < (1*FEET)+1, upper_cabinet_top    - 12.5, 12 >
           texture { WhiteEnamelOnWood } }

box      { < (1*FEET),   upper_cabinet_top    - 12.5, 11 >
           < (1*FEET)+1, upper_cabinet_top    - 1   , 12 >
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// cabinet 1 bottom shelf
// ------------------------------------------------------------

box      { < (1*FEET),    upper_cabinet_bottom,     1  >
           < (1*FEET)+11, upper_cabinet_bottom + 1, 12 >
           texture { WhiteEnamelOnWood } }

#declare four_inch_plate = cylinder {
    < (1*FEET)+3, 0.25, 5 > < (1*FEET)+3, 0.50, 5 > 4.0
    texture { ChinaPlate }
}

object { four_inch_plate translate < 0, upper_cabinet_bottom + 1.0, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 1.5, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 2.0, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 2.5, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 3.0, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 3.5, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 4.0, 0 > }
object { four_inch_plate translate < 0, upper_cabinet_bottom + 4.5, 0 > }

#declare three_inch_bowl = difference {
    cone { < (1*FEET)+3, 0, 5 > 1.50 < (1*FEET)+3, 3, 5 > 3.50 }
    cone { < (1*FEET)+3, 0, 5 > 1.25 < (1*FEET)+3, 6, 5 > 6.50 }
    texture { ChinaPlate }
}

object { three_inch_bowl translate < 0, upper_cabinet_bottom + 5.0, 0 > }

// ------------------------------------------------------------
// cabinet 1 second shelf
// ------------------------------------------------------------

box      { < (1*FEET),    upper_cabinet_bottom + 11.5, 1  >
           < (1*FEET)+11, upper_cabinet_bottom + 12.5, 12 >
           texture { WhiteEnamelOnWood } }

#declare drinking_glass = cone {
    < 0, 0,   0 > 1.25
    < 0, 6,   0 > 1.50
    texture { GreenPlastic }
}

object { drinking_glass
         translate < (1*FEET)+1.7, upper_cabinet_bottom + 11.5, 9   > }
object { drinking_glass
         translate < (1*FEET)+3.5, upper_cabinet_bottom + 11.5, 9.2 > }
object { drinking_glass
         translate < (1*FEET)+5.5, upper_cabinet_bottom + 11.5, 8.1 > }
object { drinking_glass
         translate < (1*FEET)+7.2, upper_cabinet_bottom + 11.5, 9.1 > }
object { drinking_glass
         translate < (1*FEET)+9.3, upper_cabinet_bottom + 11.5, 9.3 > }

// pitcher

cone { < (1*FEET)+4, upper_cabinet_bottom + 11.5, 4 > 2
       < (1*FEET)+4, upper_cabinet_bottom + 19.5, 4 > 3
       texture { WhitePlastic } }

// ------------------------------------------------------------
// cabinet 1 top shelf
// ------------------------------------------------------------

box      { < (1*FEET),    upper_cabinet_top    - 12.5, 1  >
           < (1*FEET)+11, upper_cabinet_top    - 11.5, 12 >
           texture { WhiteEnamelOnWood } }

// sauce pot

cylinder { < (1*FEET)+2, upper_cabinet_top - 11.5, 5 >
           < (1*FEET)+2, upper_cabinet_top -  7.5, 5 > 4 
           texture { StainlessSteel } }

sphere { < (1*FEET)+2, 0, 5 > 4 scale < 1, 0.25, 1 >
         translate < 0, upper_cabinet_top - 6.9, 0 >
           texture { StainlessSteel } }

torus { 4 0.5 translate < (1*FEET)+2, upper_cabinet_top - 7.25, 5 >
        texture { StainlessSteel } }

// ------------------------------------------------------------
// cabinet 1 top
// ------------------------------------------------------------

box      { < (1*FEET),    upper_cabinet_top - 1, 1  >
           < (1*FEET)+11, upper_cabinet_top,     12 >
           texture { WhiteEnamelOnWood } }

// ============================================================
// cabinet 2
// ============================================================

box      { < 0,  upper_cabinet_bottom, 0                           >
           < 12, upper_cabinet_top,    north_doorway_left_edge - 4 >
           texture { WhiteEnamelOnWood } }

// ============================================================
// cabinet 3
// ============================================================

box      { < (6*FEET)+6, upper_cabinet_bottom,  0  >
           < (6*FEET)+7, upper_cabinet_top,     12 >
           texture { WhiteEnamelOnWood } }

box      { < (6*FEET)+7,     upper_cabinet_bottom,  0 >
           < kitchen_length, upper_cabinet_top,     1 >
           texture { WhiteEnamelOnWood } }

box      { < (6*FEET)+7,     upper_cabinet_bottom,     1  >
           < kitchen_length, upper_cabinet_bottom + 1, 12 >
           texture { WhiteEnamelOnWood } }

box      { < (6*FEET)+7,     upper_cabinet_bottom + 11.5, 1  >
           < kitchen_length, upper_cabinet_bottom + 12.5, 12 >
           texture { WhiteEnamelOnWood } }

box      { < (6*FEET)+7,     upper_cabinet_top    - 12.5, 1  >
           < kitchen_length, upper_cabinet_top    - 11.5, 12 >
           texture { WhiteEnamelOnWood } }

box      { < (6*FEET)+7,     upper_cabinet_top    - 1,    1  >
           < kitchen_length, upper_cabinet_top,           12 >
           texture { WhiteEnamelOnWood } }

// ============================================================
// End of file
// ============================================================
