
// File: window.pov

// ============================================================
// Window over kitchen sink
// ============================================================

// ------------------------------------------------------------
// Bottom Window Molding
// ------------------------------------------------------------

box      { < west_window_right_edge,  west_window_bottom,     -6 >,
           < west_window_left_edge,   west_window_bottom - 1,  0 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge,  west_window_bottom,     0 >,
           < west_window_left_edge,   west_window_bottom - 2, 1 >
           texture { WhiteEnamelOnWood } }

cylinder { < west_window_right_edge,  west_window_bottom, 0 >,
           < west_window_left_edge,   west_window_bottom, 0 >, 0.5
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Left Window Side Molding
// ------------------------------------------------------------

box      { < west_window_left_edge,     west_window_top    - 1, -6 >,
           < west_window_left_edge - 1, west_window_bottom + 1,  0 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_left_edge,     west_window_top    + 2, 0 >,
           < west_window_left_edge + 2, west_window_bottom - 2, 1 >
           texture { WhiteEnamelOnWood } }

cylinder { < west_window_left_edge, west_window_top,    0 >,
           < west_window_left_edge, west_window_bottom, 0 >, 0.5
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Right Window Side Molding
// ------------------------------------------------------------

box      { < west_window_right_edge,     west_window_top    - 1, -6 >,
           < west_window_right_edge + 1, west_window_bottom + 1,  0 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge,     west_window_top    + 2, 0 >,
           < west_window_right_edge - 2, west_window_bottom - 2, 1 >
           texture { WhiteEnamelOnWood } }

cylinder { < west_window_right_edge, west_window_top,    0 >,
           < west_window_right_edge, west_window_bottom, 0 >, 0.5
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Left Window Frame
// ------------------------------------------------------------

box      { < west_window_left_edge - 1, west_window_top    - 1, -4 >,
           < west_window_left_edge - 2.75, west_window_bottom + 1, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_left_edge - 2.75, west_window_top    - 1, -4 >,
           < west_window_center    + 1.75, west_window_top    - 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_left_edge - 2.75, west_window_bottom + 1, -4 >,
           < west_window_center    + 1.75, west_window_bottom + 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_center,        west_window_top    - 1, -4 >,
           < west_window_center + 1.75, west_window_bottom + 1, -3 >
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Right Window Frame
// ------------------------------------------------------------

box      { < west_window_right_edge + 1, west_window_top    - 1, -4 >,
           < west_window_right_edge + 2.75, west_window_bottom + 1, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge + 2.75, west_window_top    - 1, -4 >,
           < west_window_center     - 1.75, west_window_top    - 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge + 2.75, west_window_bottom + 1, -4 >,
           < west_window_center     - 1.75, west_window_bottom + 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_center - 0.1,  west_window_top    - 1, -4 >,
           < west_window_center - 1.75, west_window_bottom + 1, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_center - 0.25, west_window_bottom + 14, -2.9  >,
           < west_window_center - 1.25, west_window_top    - 14, -3    >
           texture { DarkMetal } }

cylinder { < west_window_center, west_window_bottom + 15.5, -2.5  >,
           < west_window_center, west_window_bottom + 15.5, -2.9  > 1
           texture { DarkMetal } }

cylinder { < west_window_center, west_window_bottom + 15.5, -2.25  >,
           < west_window_center, west_window_bottom + 15.5, -2.5   > 0.5
           texture { DarkMetal } }

// ------------------------------------------------------------
// Left Window Pane Dividers
// ------------------------------------------------------------

box      { < west_window_center + 10.25, west_window_top    - 3, -4 >,
           < west_window_center + 9.75,  west_window_bottom + 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_left_edge - 2.75, west_window_bottom + 11,   -4 >,
           < west_window_center    + 1.75, west_window_bottom + 11.5, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_left_edge - 2.75, west_window_top - 11,   -4 >,
           < west_window_center    + 1.75, west_window_top - 11.5, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_center + 0.25, west_window_bottom + 14, -2.9  >,
           < west_window_center + 1.25, west_window_top    - 14, -3    >
           texture { DarkMetal } }

// ------------------------------------------------------------
// Left Window Panes
// ------------------------------------------------------------

box      { < west_window_center + 1.75, west_window_top - 3,  -3.25 >,
           < west_window_center + 9.75, west_window_top - 11, -3.50 >
           texture { WindowGlass } }

box      { < west_window_left_edge -  2.75, west_window_top - 3,  -3.25 >,
           < west_window_left_edge - 10.75, west_window_top - 11, -3.50 >
           texture { WindowGlass } }

box      { < west_window_center + 1.75, west_window_top    - 11.5, -3.25 >,
           < west_window_center + 9.75, west_window_bottom + 11.5, -3.50 >
           texture { WindowGlass } }

box      { < west_window_left_edge -  2.75, west_window_top    - 11.5, -3.25 >,
           < west_window_left_edge - 10.75, west_window_bottom + 11.5, -3.50 >
           texture { WindowGlass } }

box      { < west_window_center + 1.75, west_window_bottom + 11, -3.25 >,
           < west_window_center + 9.75, west_window_bottom + 3,  -3.50 >
           texture { WindowGlass } }

box      { < west_window_left_edge -  2.75, west_window_bottom + 11, -3.25 >,
           < west_window_left_edge - 10.75, west_window_bottom + 3,  -3.50 >
           texture { WindowGlass } }

// ------------------------------------------------------------
// Right Window Pane Dividers
// ------------------------------------------------------------

box      { < west_window_center - 10.25, west_window_top    - 3, -4 >,
           < west_window_center -  9.75, west_window_bottom + 3, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge + 2.75, west_window_bottom + 11,   -4 >,
           < west_window_center     - 1.75, west_window_bottom + 11.5, -3 >
           texture { WhiteEnamelOnWood } }

box      { < west_window_right_edge + 2.75, west_window_top - 11,   -4 >,
           < west_window_center     - 1.75, west_window_top - 11.5, -3 >
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Right Window Panes
// ------------------------------------------------------------

box    { < west_window_center - 1.75, west_window_top - 3,  -3.25 >,
         < west_window_center - 9.75, west_window_top - 11, -3.50 >
         texture { WindowGlass } }

box    { < west_window_right_edge +  2.75, west_window_top - 3,  -3.25 >,
         < west_window_right_edge + 10.75, west_window_top - 11, -3.50 >
         texture { WindowGlass } }

box    { < west_window_center - 1.75, west_window_top    - 11.5, -3.25 >,
         < west_window_center - 9.75, west_window_bottom + 11.5, -3.50 >
         texture { WindowGlass } }

box    { < west_window_right_edge +  2.75, west_window_top    - 11.5, -3.25 >,
         < west_window_right_edge + 10.75, west_window_bottom + 11.5, -3.50 >
         texture { WindowGlass } }

box    { < west_window_center - 1.75, west_window_bottom + 11, -3.25 >,
         < west_window_center - 9.75, west_window_bottom + 3,  -3.50 >
         texture { WindowGlass } }

box    { < west_window_right_edge +  2.75, west_window_bottom + 11, -3.25 >,
         < west_window_right_edge + 10.75, west_window_bottom + 3,  -3.50 >
         texture { WindowGlass } }

// ============================================================
// End of file
// ============================================================
