#include "flower4.inc"		// purple-white
#include "flower6.inc"		// purple-white star
#include "flower8.inc"		// lemon
#include "flower9.inc"		// dark red

#declare Vase_color = texture {
	pigment {color rgb <1, 0.95, 0.8>}
	finish {ambient 0.3 diffuse 0.6 phong 1 phong_size 80 reflection 0.2}
}

#declare Vase = merge {
	sphere {<0, 0, 0>, 0.30
		texture {Vase_color}
		texture {
			pigment {
				image_map {
					gif "ornam.gif"
					filter 255, 1
					map_type 0
					interpolate 2
					once
				}
				scale <0.18, 0.12, 0.12>
				translate <-0.09, -0.06, 0>
			}
		}
	}
	cylinder {<0, 0, 0>, <0, 0.5, 0>, 0.1
		texture {Vase_color}
	}
	translate y*0.25
	scale <1.2, 0.8, 1.2>
}

#declare Half_1 = union {
	// 1 raw
	object {
		Flower9
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*0
	}
	object {
		Flower4
		scale 1.1
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*45
	}
	object {
		Flower9
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*90
	}
	object {
		Flower8
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*135
	}
	// 2 raw
	object {
		Flower8
		rotate -z*110
		translate <0.62, 0.28, 0>
		rotate y*20
	}
	object {
		Flower6
		scale 1.2
		rotate -z*110
		translate <0.62, 0.28, 0>
		rotate y*65
	}
	object {
		Flower4
		scale 1.1
		rotate -z*110
		translate <0.65, 0.28, 0>
		rotate y*105
	}
	object {
		Flower9
		rotate -z*110
		translate <0.62, 0.28, 0>
		rotate y*155
	}
	// 3 raw
	object {
		Flower9
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*0
	}
	object {
		Flower8
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*45
	}
	object {
		Flower9
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*90
	}
	object {
		Flower6
		scale 1.1
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*135
	}
}

#declare Half_2 = union {
	// 1 raw
	object {
		Flower9
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*0
	}
	object {
		Flower8
		rotate -z*150
		translate <0.5, 0.05, 0>
		rotate y*135
	}
	// 2 raw
	object {
		Flower8
		rotate -z*110
		translate <0.62, 0.28, 0>
		rotate y*20
	}
	object {
		Flower9
		rotate -z*110
		translate <0.62, 0.28, 0>
		rotate y*155
	}
	// 3 raw
	object {
		Flower9
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*0
	}
	object {
		Flower8
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*45
	}
	object {
		Flower9
		rotate -z*45
		translate <0.5, 0.45, 0>
		rotate y*90
	}
	object {
		Flower6
		scale 1.1
		rotate -z*45
		translate <0.5, 0.6, 0>
		rotate y*135
	}
}

#declare Bunch = union {
	object {Vase rotate -y*10}
	union {
		object {Half_1 translate x*0.05}
		object {Half_2 rotate y*180 translate -x*0.04}
		rotate -x*2
		translate y*0.56
	}
}
