#include "bee.inc"

#declare Liquid_honey = texture {
	pigment {color rgbf <0.65, 0.4, 0, 0.5>}
	finish {
		ambient 0.24
		phong 1 phong_size 20
		reflection 0.16
		refraction 1
		ior 1.8
	}
}

#declare Piece = difference {
	height_field { gif "honey.gif"
		smooth
		scale <4/3, 3, 1>
		translate <0, -2.55, -0.5>
		scale <0.2, 0.15, 0.2>
	}
	plane {y, 0}

	pigment {color rgbf <0.6, 0.42, 0, 0.15>}
	finish {ambient 0.22 diffuse 0.7 phong 1 phong_size 70}
}

#declare Honey_spoiled = difference {
	blob {
		threshold 0.600000
		component 1.000000, 0.468200, <0.007630, 0.000000, 0.366412>
		component 1.000000, 0.468200, <-0.251796, 0.000000, 0.183206>
		component 1.000000, 0.468200, <0.068672, 0.000000, 0.045802>
		component 1.000000, 0.468200, <0.358618, 0.000000, 0.229008>
		component 1.000000, 0.468200, <0.587523, 0.000000, 0.045802>
		component 1.000000, 0.468200, <0.785907, 0.000000, -0.183206>
		component 1.000000, 0.468200, <0.343358, 0.000000, -0.198473>
		component 1.000000, 0.468200, <-0.083932, 0.000000, -0.213740>
		component 1.000000, 0.468200, <-0.511221, 0.000000, -0.137405>
		component 1.000000, 0.468200, <-0.328097, 0.000000, -0.442748>
		component 1.000000, 0.468200, <0.114453, 0.000000, -0.564885>
		component 1.000000, 0.468200, <0.541742, 0.000000, -0.549618>
		component 1.000000, 0.468200, <-0.129713, 0.000000, -0.793893>
		component 1.000000, 0.468200, <0.282316, 0.000000, -0.809160>
		component 1.000000, 0.195602, <0.801168, 0.000000, -1.022901>
		component 1.000000, 0.195602, <0.740126, 0.000000, -0.946565>
		component 1.000000, 0.195602, <0.526482, 0.000000, -1.282443>

		translate y*0.18
		scale <0.3, 0.015, 0.2>
		rotate y*90
	}
	plane {y, 0}

	texture {Liquid_honey}
	translate <0.25, 0.01001, 0>
}

#declare Drops = blob {
	threshold 0.600000
	component 1.000000, 0.647094, <-0.007630, 0.000000, 0.198473>
	component 1.000000, 0.265063, <0.038151, 0.000000, -0.183206>
	component 1.000000, 0.192943, <-0.190754, 0.000000, -0.427481>
	texture {Liquid_honey}

	translate y*0.16
	scale <0.3, 0.01, 0.2>
	translate <0.45, 0, -0.45>
}

#declare Honey = union {
	object {Drops}
	object {Bee rotate y*50 translate <0.49, 0, -0.63>}
	union {
		object {Piece}
		object {
			Piece
			rotate y*90
			translate <0.2, 0, 0>
			rotate -x*20
			translate y*0.1
		}
		scale 1.1
		translate y*0.01
	}
	object {Honey_spoiled}
	merge {
		cylinder {<0, 0, 0>, <0, 0.01, 0>, 0.34}
		difference {
			cylinder {<0, 0, 0>, <0, 0.03, 0>, 0.32}
			cylinder {<0, -0.1, 0>, <0, 0.1, 0>, 0.30}
		}
		translate <0.2, 0, -0.05>
		texture {My_glass}
	}
	rotate -y*45
}














