#declare Pad = union {
	box {<-0.5, 0, -0.4>, <0.5, 0.02, 0.4>}
	sphere {<-0.5, 0.01, -0.4>, 0.01}
	sphere {<0.5, 0.01, -0.4>, 0.01}
	sphere {<-0.5, 0.01, 0.4>, 0.01}
	sphere {<0.5, 0.01, 0.4>, 0.01}
	cylinder {<-0.5, 0.01, -0.4>, <0.5, 0.01, -0.4>, 0.01}
	cylinder {<-0.5, 0.01, 0.4>, <0.5, 0.01, 0.4>, 0.01}
	cylinder {<-0.5, 0.01, -0.4>, <-0.5, 0.01, 0.4>, 0.01}
	cylinder {<0.5, 0.01, -0.4>, <0.5, 0.01, 0.4>, 0.01}

	translate <0.05, -0.01, 0.1>
	scale <1.4, 0.4, 1.4>

	pigment {
		image_map {
			gif "pad.gif"
			map_type 0
			interpolate 2
		}
		rotate x*90
		scale 0.35
	}
	finish {ambient 0.16 diffuse 0.6 phong 0.4}
	normal {
		bump_map {
			gif "pad_b.gif"
			bump_size 1.3
		}
		rotate x*90
		scale 0.35
	}
	rotate -y*30
	translate z*0.05
}

#declare Empty_glass = union {
	difference {
		merge {
			difference {
				sphere {
					<0, 0.5, 0>, 0.5
					scale <1, 0.4, 1>
					translate -y*0.1
				}
				plane {y, 0}
			}
			cylinder {<0, 0.1, 0>, <0, 1.4, 0>, 0.5}
		}
		difference {
			cylinder {<0, 0.08, 0>, <0, 1.5, 0>, 0.48}
			sphere {<0, 0, 0>, 0.48 scale <1, 0.2, 1> translate y*0.1}
		}
		texture {My_glass}

		rotate -z*90 rotate y*40
		translate y*0.501
		scale 0.35
	}
	union {
		object {Black_currant}
		object {Red_currant translate x*0.1}
		object {Red_currant translate x*0.24}
		translate <0.18, 0.02, 0>
		rotate y*40
	}
}
