#include "cable.inc"

#declare kettle_body = union {
	difference {
		object { sphere { <0, 0, 0> 3 }
			scale <3, 1, 3> translate <0, 1.5, 0>
		}
		plane { <0, 1, 0> 0 }
	}
	intersection {
		object { sphere { <0, 0, 0> 9.5 }
			scale <1, 1.2, 1>
			translate <0, 5.006026558, 0>
		}
		box { <-10, 1.206853967, -10> <10, 11.40606836, 10> }
	}
	intersection {
		
		object { sphere { <0, 0, 0> 8 }
			scale <1, 1/3, 1> translate <0, 10.91223798, 0>
		}
		plane { <0, 1, 0> 12.6 }
	}
	texture { pigment { colour rgb <0.9, 0.9, 0.7> }
		  finish { specular 1 roughness 0.001 metallic }
	}
	texture { pigment { image_map { gif "kettpat.gif"
					interpolate 2
					once
					filter 255, 1
			    }
			    scale <14, 5, 1>
			    translate <-7, 3, 0>
		}
	}
}

#declare kettle_spout = object {
	cone {
		<-8, 7, 0>, 2
		<-14, 15, 0>, 1
	}
	clipped_by { plane { <0, 1, 0> 14 } }
	texture { pigment { colour rgb <0.9, 0.9, 0.7> }
		  finish { specular 1 roughness 0.001 metallic }
	}
}

#declare kettle_top = union {
	cylinder {
		<0, 12.6, 0>
		<0, 12.8, 0>
		6
	}
	cone {
		<0, 12.8, 0>, 6
		<0, 13, 0>, 4.5
	}
	object {
		box { <-2, -1, -0.2> <2, 1, 0.2> }
		rotate <0, 0, 30>
		translate <2, 12.8, 0>
	}
	texture {
		pigment { rgb <0.2, 0.2, 0.2> }
		finish { specular 0.5 roughness 0.05 }
		normal { wrinkles 0.3 scale <0.01, 0.01, 0.01> }
	}

}

#declare kettle_attach = union {
	box { <6, 1.206853967, -2.8> <11, 11.40606836, 2.8> }
	box { <6, 1.406853967, -3> <11, 11.20606836, 3> }
	cylinder { <6, 1.406853967, -2.8> <11, 1.406853967, -2.8> 0.2 }
	cylinder { <6, 1.406853967, 2.8> <11, 1.406853967, 2.8> 0.2 }
	cylinder { <6, 11.20606836, -2.8> <11, 11.20606836, -2.8> 0.2 }
	cylinder { <6, 11.20606836, 2.8> <11, 11.20606836, 2.8> 0.2 }
	cylinder { <11, 1.406853967, -2.8> <11, 11.20606836, -2.8> 0.2 }
	cylinder { <11, 1.406853967, 2.8> <11, 11.20606836, 2.8> 0.2 }
	cylinder { <11, 1.406853967, -2.8> <11, 1.406853967, 2.8> 0.2 }
	cylinder { <11, 11.20606836, -2.8> <11, 11.20606836, 2.8> 0.2 }
	sphere { <11, 1.406853967, -2.8> 0.2 }
	sphere { <11, 1.406853967, 2.8> 0.2 }
	sphere { <11, 11.20606836, -2.8> 0.2 }
	sphere { <11, 11.20606836, 2.8> 0.2 }
	object {
		box { <-1, -2, -1> <1, 2, 1> }
		rotate <0, 0, 10>
		translate <10.5, 8, 0>
		texture { pigment { colour rgb <0.9, 0.4, 0> }
			  finish { specular 1 roughness 0.001 }
		}
	}
	texture {
		pigment { rgb <0.2, 0.2, 0.2> }
		finish { specular 0.5 roughness 0.05 }
		normal { wrinkles 0.3 scale <0.01, 0.01, 0.01> }
	}
	bounded_by { box { <6, 1.1, -3> <12, 11.5, 3> } }
}

#declare kettle_handle = intersection {
	union {
		cylinder {
			<-10.5, 10, 0>
			<-9.5, 23, 0>
			4
		}
		cylinder {
			<-9.5, 23, 0>
			<14, 23, 0>
			4
		}
		cylinder {
			<14, 23, 0>
			<14, 11, 0>
			4
		}
	}
	object {
		plane { <-1, 0, 0> 0 }
		rotate <0, 0, -4.398705355>
		translate <-7, 15.5, 0>
	}
	plane { <0, 1, 0> 20 }
	plane { <1, 0, 0> 11 }
	texture {
		pigment { rgb <0.2, 0.2, 0.2> }
		finish { specular 0.5 roughness 0.05 }
		normal { wrinkles 0.3 scale <0.01, 0.01, 0.01>  }
	}
}
		
#declare kettle_main = union {
	object { kettle_body }
	object { kettle_spout }
	object { kettle_top }
	object { kettle_attach }
	object { kettle_handle }
	texture { pigment { colour rgb <1, 0, 0> }
		  finish { specular 1 roughness 0.005 }
	}
	bounded_by { box { <-15, 0, -9.5> <11.5, 20, 9.5> } }
}

#declare kettle_cord = union {
	box { <11, 3, -1> <14, 4.5, 1> }
	cylinder { <14, 3.75, 0> <14.4, 3.75, 0> 0.4 }
	object { cable }
	texture { pigment { colour rgb <1, 1, 1> } }
}

#declare kettle = union {
	object { kettle_main }
	object { kettle_cord }
}
