#include "shapes.inc"
#include "colors.inc"
#include "mytex.inc"

#include "tree.inc"
#include "mug.inc"
#include "mugtree.inc"
#include "bench.inc"
#include "wall.inc"
#include "kettle.inc"
#include "coffee.inc"

#max_intersections 200
#max_trace_level 3
/*
camera {
	location <63, 150, -150>
	direction <0, 0, -5.5>
	look_at <-200, 150, -150>
	up <0, 1, 0>
	right <1.333, 0, 0>
} 
*/
camera { 
  location  <-12.065, 65, -149.043>
  direction <0, 0, 3>
  up        <0, 1,  0>  
  right     <1.3333,  0,  0>
  look_at   <19.556, 4, 10.327> //10.327
}

light_source {<1000, 1500, -500> colour rgb <0.6, 0.6, 0.6> }
light_source {<-100, 300, -150> colour rgb <0.8, 0.8, 0.7>}
light_source {<-50 300, -150> colour rgb <0.8, 0.8, 0.7>}
// light_source {<20, 100, 30> colour rgb <0.5, 0.5, 0.4>}

object {
	box { <-200, -60, -300> <73.5, 320, 30> }
	texture {
		pigment {
			onion
			colour_map {
				[0 colour rgb <0.9, 0.9, 0.9>]
				[1 colour rgb <0.2, 0.2, 0.2>]
			}
		}
		scale <500, 500, 500>
	}
	no_shadow
}
		

object { wall }

object { mugtree rotate <0, 40, 0> translate <2, 0, 11>}

object { surface }

object { fullmug
	texture { mug_tex pigment { image_map { gif "mugim1.gif"
						map_type 2
						interpolate 2
						once }
				    scale <1, 7, 1> } }
	rotate <0, -30, 0> translate <10, 0, -23> }

object { kettle rotate <0, -10, 0> translate <35, 0, -7> }

object { coffee_jar translate <-8, 0, -20> }
