/* -*-Text-*-
*******************************************************************************
*
* File:		kitchen.pov
* Rev:		$Revision$
* Description:	POV Source for the Internet Raytracing Competition for
*		September '95
* Author:	Marvin L. Taylor
* Language:	POVRay Script
*
* (C) Copyright 1995, Marvin L. Taylor, Distribute Freely.
*
* Notes:	Requires several include files and GIF's, some of which are
*		*NOT* freely distributable (or at least not now).  See
*		"kitchen.txt" for a description.
*
******************************************************************************* */
#include "colors.inc"
#include "textures.inc"
#include "chars.inc"


#declare BRoom    = box { <-1,0,-200>, <130,96,14> }

#declare TFHandle  = texture { Silver_Metal }
#declare TCCounter = texture { pigment { color Gray80 } }
#declare TCDoors   = texture { DMFWood4 rotate 90*x }
#declare TCCabinet = texture { DMFWood4 rotate 90*x }
#declare TCTrim1   = texture { pigment { color Black } }
#declare TCTrim2   = texture { DMFWood1 rotate 90*x }
#declare TCHandle  = texture { Brass_Metal }
#declare TWPaper1  = pigment { image_map { gif "wallppr1.gif" interpolate 2.0 }
			       quick_color Brown }
#declare TWPaper2  = pigment { image_map { gif "wallppr2.gif" interpolate 2.0 }
			       quick_color Magenta }
#declare TCRail    = texture { TCTrim2 scale 1/2 }
#declare TWalls	   = texture { pigment { color red 244 green 247 blue 224 }
			      finish { crand 0.05 ambient 0.2 diffuse 0.8 } }
#declare TFloor    = texture {
		       pigment { checker color Gray25 color Black filter 1.0
				 scale <8,1,8> quick_color Coral }
		       finish { ambient 0.1 diffuse 0.9 } // rotate 45*y
		     }
#declare TCeiling  = texture { Dull  pigment { White quick_color Orange }}
#declare TOutlet1  = texture { Shiny pigment { Gray75 quick_color Red }}
#declare TOutlet2  = texture { Shiny pigment { Gray90 quick_color Blue }}

//===========================================================================
//
// Here, we light up our "life"...
// 
light_source { <30,95,-120> color White }	// Left side, high
light_source { <98,95,-120> color White }	// Right side, high
light_source { <82,52,-150> color Gray50 }	// Eye level, center

camera {
  location <97.0,62,-150.0>
  look_at <82.0,32, 0.0>
}

//===========================================================================
//
// Declare my name as a plaque (for the fridge or whatever). Uses "chars.inc"
//
#declare Marvelous = union {
   box { <0,0,-0.5>,<38,7,0>  texture { pigment { Black quick_color Blue }}}
   union {
      object { char_M     translate   3*x }
      object { char_A     translate   8*x }
      object { char_R     translate  13*x }
      object { char_V     translate  18*x }
      object { char_I     translate  23*x }
      object { char_N     translate  28*x }
      object { char_T     translate  35*x }
      texture { Polished_Chrome pigment{quick_color Red} finish {ambient 0.5}}
      translate <0,1,-1.5>
   }
   // This is the overall size...
   bounded_by { box { <0,0,-1.5>, <38,7,0> }}
}

//========================= BEGIN OUTLET SECTION =========================
#declare TOutlet1 = texture { Shiny pigment { Gray75 }}
#declare TOutlet2 = texture { Shiny pigment { Gray90 }}

#declare Outlet1 = union {
   cylinder { <0,0,-0.2>,<0,0,0.2>,1   texture { TOutlet1 }}
   box { <-0.35,-0.5,-0.21>,<-0.2,0.5,0.21> texture { Dull pigment { Black }}}
   box { <0.2,-0.45,-0.21>,<0.35,0.45,0.21> texture { Dull pigment { Black }}}
   scale <.9,.5,1>
}

#declare Outlet = union {
   box { <-1.5,-2,-0.1>,<1.5,2,0.1> texture { TOutlet2 }}
   object { Outlet1   translate -0.75*y }
   object { Outlet1   translate  0.75*y }
}
//========================= BEGIN OUTLET SECTION =========================

#declare Outlet1 = difference {
   // Scale here is in 1/16ths of an inch...
   intersection {
      cylinder { <0,0,-5>,<0,0,-1>,11.5  }
      box      { <-12,-9,-6>,<12,9,0> }
   }
   box { <-3,1,-6>, <-2,6,0> }
   box { <2,1.5,-6>, <3,5.5,0> }
   cylinder { <0,-5,-6>,<0,-5,0>,2 }
   texture { TOutlet1 }
}

#declare Outlet = union {
   // Again, the scale is 1/16ths of an inch...
   object { Outlet1   translate -12*y }
   object { Outlet1   translate  12*y }

   difference { 
      box { <-22,-36,-4.5>,<22,36,-2.0> }
      cylinder { <0,0,-6>,<0,0,0>,1 }
      box { <-3,-5.5,-6>, <3,6.5,0> }
      box { <-3,-5.5,-6>, <3,6.5,0> }
      texture {  TOutlet2 }
   }
   // This is the middle screw:
   cylinder { <0,0,-6>,<0,0,0>,1 texture { Brass_Metal }}
   // ... This is what we see through the holes...
   box { <-21,-35,-2.0>,<21,35,-1.5> texture { Brass_Metal }}

   // Now scale it to inches...
   scale 1/16
}
//========================= END OUTLET SECTION =========================

//========================= BEGIN ART SECTION =========================
//
// These "pictures" are oriented on the X-Y plane, with the lower,
// left (back) corner in their center.  Rotate/translate accordingly...
//
#declare Art1_Size = <3.0,4.0,0.1>
#declare Art1 = box {
   <0,0,0>,<1,1,1>	// Start with a unit square...
   pigment {image_map {gif "art1.gif" once interpolate 2.0 } quick_color Tan }
   scale Art1_Size
   translate -0.5*Art1_Size
}

#declare Art2_Size = <3.0,4.0,0.1>
#declare Art2 = box {
   <0,0,0>,<1,1,1>	// Start with a unit square...
   pigment {image_map {gif "art2.gif" once interpolate 2.0 } quick_color Blue }
   scale Art2_Size
   translate -0.5*Art2_Size
}
//
// ART3 is a calendar, with a boat/harbor scene over Sept-95.
//
#declare Art3_Size = <12.0,30.0,0.1>
#declare Art3 = box {
   <0,0,0>,<1,1,1>	// Start with a unit square...
   pigment {image_map {gif "art3.gif" once interpolate 2.0 } quick_color Green}
   scale Art3_Size
   translate -0.5*Art3_Size
}

//
// "Art4" is used as a large poster on the wall, so it has a frame as
// well.   If you replace it with a different aspect (it's 4x3), then
// change or swap (ie: 3x4) the declarations of 'Art4_{X/Y}' below.
//
#declare Art4_X		 = 4.0
#declare Art4_Y		 = 3.0
#declare Art4_Z		 = 0.1
#declare AFS		 = 0.25
#declare Art4_Size	 = <Art4_X,Art4_Y,Art4_Z>
#declare Art4 = union {
  box {
    <0,0,0>,<1,1,1.0>	// Start with a unit square...
    pigment {image_map {gif "art4.gif" once interpolate 2.0 } quick_color Cyan }
    scale Art4_Size
  }
  union { // A frame...
    box { <-AFS,-AFS,-AFS>,<AFS,Art4_Y+AFS,AFS> }
    box { <0,-AFS,-AFS>,<Art4_X+AFS,0,AFS> }
    box { <0,Art4_Y,-AFS>,<Art4_X+AFS,Art4_Y+AFS,AFS> }
    box { <Art4_X,0,-AFS>,<Art4_X+AFS,Art4_Y,AFS>  }
    texture { pigment { color Blue } finish { Shiny }} 
  }
  translate -0.5*Art4_Size
}

//========================= END ART SECTION =========================

//========================= BEGIN GLASS SECTION =========================
//
// Glass Height, Outside radius, Inside radius at base and top of
// "cone" part.
//
#declare GH1	= 0.5
#declare GH2	= 7.0
#declare GI1	= 1.25
#declare GO1	= 1.45
#declare GI2	= 1.55
#declare GO2	= 1.625

//
// Straw radius, height and X-pos at top and bottom...
//
#declare SRad	= 0.125
#declare SH1	= GH1+SRad
#declare SH2	= GH1+(GH2-GH1)*1.5
#declare SP1	= -(GI1+SRad)
#declare SP2	= (GI1*2-SRad*3)

//
// Liquid height/radius at top/bottom ...
//
#declare LH1	= GH1
#declare LR1	= GI1
#declare LH2	= (GH1+GH2)/2
#declare LR2	= (GI1+GI2)/2

//
// The (crystal) glass itself is a just a base with a cone on top:
//
#declare GL_Glass =  union {
   cylinder { <0,0,0>,<0,GH1,0>,1.25 }			// base of glass.
   intersection {
      cone { <0,GH1,0>,GO1, <0,GH2,0>,GO2 }		// Outside of body.
      cone { <0,GH1-1,0>,GI1, <0,GH2+1,0>,GI2 inverse }	// Inside of body.
   }
   bounded_by { cylinder { <0,0,0>, <0,GH2,0>, GO2 } }
   texture { Glass3 }
}

//
//  Add a red "straw" at an angle
//
#declare GL_Straw = cylinder {
   <SP1,SH1,0>, <SP2,SH2,0>, SRad
   texture { pigment { color Red }}
}

//
// Some liquid (Pop?) in the glass...
//
#declare GL_Liquid1 = object {
   cone { <0,LH1,0>,LR1, <0,LH2,0>, LR2 }
   texture { 
      pigment { color  filter 0.80 }
      finish { reflection 0.05 refraction 1.0 ior 1.5 }
   }
}
#declare GL_Liquid2 = object {
   cone { <0,LH1,0>,LR1, <0,LH2,0>, LR2 }
   texture { 
      pigment { color Tan filter 0.50 }
      finish { reflection 0.05 refraction 1.0 ior 1.5 }
   }
}

//
// A set of 3 glasses, two with liquid, one empty...
//
union {
   object { GL_Glass  } object { GL_Straw } object { GL_Liquid1 }
   rotate 50*y
   translate <75.0,42, 5.0 >
}
union {
   object { GL_Glass  } object { GL_Straw }
   rotate -80*y
   translate <87.0,42, 2.0 >
}
union {
   object { GL_Glass  } object { GL_Liquid2 }
   rotate 200*y
   translate <82.0,42, -3.0 >
}
//========================= END WINE GLASS SECTION =========================


//========================= BEGIN TABLE/STOOL SECTION =========================
//
//  Now declare a single table and a couple of stools
//
#include "mltstool.inc" 
#include "mlttable.inc" 
#include "mltsalt.inc"

union { 
   object { KitchenTable }
   object { PepperMill rotate 20*y translate <15,KTable_Height,18> }
   object { GL_Glass translate <-12,KTable_Height,20> }
   translate <KTable_Width/2+1,0,-95>
}

object { BarStool  rotate y*38  translate <30,0,-37>  }

//========================= END TABLE SECTION =========================


//========================= BEGIN CABINET SECTION =========================

/*
 * Counter Top has rounded front/top corners, with a slight lip
 * at the front (like real ones)...
 */
#declare Counter_Top = union {
   //
   // The "bottom" has a rounded edge on the front...
   //
   box	    { <0,0,13>,  <94,3,-10>	      texture { TCCounter } }
   box	    { <0,0,-10>, <94,2,-11>	      texture { TCCounter } }
   cylinder { <0,2,-10>, <94,2,-10>, 1.25 texture { TCCounter } }

   //
   // Similarly, the back does, too...
   //
   box	    { <0,3,13>,  <94,11,11>	 texture { TCCounter } }
   box	    { <0,11,13>, <94,12,12>	 texture { TCCounter } }
   cylinder { <0,11,12>, <94,11,12>, 1.0 texture { TCCounter } }

   //
   // W/o scaling, the counter is 60.0 wide, the back is 9.0 high x
   // 3.0 deep, and the work area is 3.0 high and 24.0 deep.
   // The origin is on the top of the work area, in its center.
   //
}

//
// Translate these with origins at lower/left corner...
//
#declare Cabinet_Door_Lower = union {
   box { <0,0,0>, <16,34,-0.75> texture { TCDoors } }
   union {
      box { <1,1,-0.75>, <2,33,-1.5> }
      box { <2,1,-0.75>, <15,2,-1.5> }
      box { <2,32,-0.75>, <15,33,-1.5> }
      box { <14,2,-0.75>, <15,32,-1.5> }
      texture { TCTrim1 }
   }
   union {
      box { <0.5,0.5,-0.75>, <2.5,33.5,-1.125> }
      box { <2.5,0.5,-0.75>, <15.5,2.5,-1.125> }
      box { <2.5,31.5,-0.75>, <15.5,33.5,-1.125> }
      box { <14.5,2.5,-0.75>, <15.5,31.5,-1.125> }
      texture { TCTrim2 }
   }
}
#declare Cabinet_Door_Upper = union {
   box { <0,0,0>, <16,28,-0.75> texture { TCDoors } }
   union {
      box { <1,1,-0.75>, <2,29,-1.5> }
      box { <2,1,-0.75>, <15,2,-1.5> }
      box { <2,28,-0.75>, <15,29,-1.5> }
      box { <14,2,-0.75>, <15,28,-1.5> }
      texture { TCTrim1 }
   }
   union {
      box { <0.5,0.5,-0.75>, <2.5,29.5,-1.125> }
      box { <2.5,0.5,-0.75>, <15.5,2.5,-1.125> }
      box { <2.5,27.5,-0.75>, <15.5,29.5,-1.125> }
      box { <14.5,2.5,-0.75>, <15.5,27.5,-1.125> }
      texture { TCTrim2 }
   }
}
#declare Cabinet_Door_Half = union {
   box { <0,0,0>, <16,18,-0.75> texture { TCDoors } }
   union {
      box { <1,1,-0.75>, <2,17,-1.5> }
      box { <2,1,-0.75>, <15,2,-1.5> }
      box { <2,16,-0.75>, <15,17,-1.5> }
      box { <14,2,-0.75>, <15,16,-1.5> }
      texture { TCTrim1 }
   }
   union {
      box { <0.5,0.5,-0.75>, <2.5,17.5,-1.125> }
      box { <2.5,0.5,-0.75>, <15.5,2.5,-1.125> }
      box { <2.5,15.5,-0.75>, <15.5,17.5,-1.125> }
      box { <14.5,2.5,-0.75>, <15.5,15.5,-1.125> }
      texture { TCTrim2 }
   }
}
#declare Cabinet_Drawer = union {
   box { <0,0,0>, <16,10,-0.75> texture { TCDoors }}
   union {
      box { <1,1,-0.75>, <2,9,-1.5> }
      box { <2,1,-0.75>, <15,2,-1.5> }
      box { <2,8,-0.75>, <15,9,-1.5> }
      box { <14,2,-0.75>, <15,8,-1.5> }
      texture { TCTrim1 }
   }
   union {
      box { <0.5,0.5,-0.75>, <2.5,9.5,-1.125> }
      box { <2.5,0.5,-0.75>, <15,2.5,-1.125> }
      box { <2.5,7.5,-0.75>, <15,9.5,-1.125> }
      box { <14,2.5,-0.75>, <15,7.5,-1.125> }
      texture { TCTrim2 }
   }
}

//
// Translate this with origin at the back of the knob in the center...
//
#declare Cabinet_Handle = union {
   cylinder { <0,0,0.0>, <0,0,-2>, 0.375 }
   cylinder { <0,0,-2.0>, <0,0,-2.5>, 0.75 }
   texture { TCHandle }
}
      


//
// Lower cabinets...
//
union {
   box { <36,0,13>, <128,3,-6>	texture { TCTrim2 }}	// Kick board
   box { <36,3,13>, <128,39,-9>	texture { TCCabinet }}	// Cabinet body

   object { Counter_Top		translate <36,39,0> }

   object { Cabinet_Door_Lower	translate <38,3,-9> }
   object { Cabinet_Handle	translate <50,32,-9> }

   object { Cabinet_Door_Lower	translate <56,3,-9> }
   object { Cabinet_Handle	translate <60,32,-9> }

   object { Cabinet_Drawer	translate <74,3,-9> }
   object { Cabinet_Handle	translate <82,8,-9> }
   object { Cabinet_Drawer	translate <74,15,-9> }
   object { Cabinet_Handle	translate <82,20,-9> }
   object { Cabinet_Drawer	translate <74,27,-9> }
   object { Cabinet_Handle	translate <82,32,-9> }

   object { Cabinet_Door_Lower	translate <92,3,-9> }
   object { Cabinet_Handle	translate <104,32,-9> }

   object { Cabinet_Door_Lower	translate <110,3,-9> }
   object { Cabinet_Handle	translate <114,32,-9> }
}


// Upper cabinets are the same, but:
//  - the 'Drawer's are 'Door's,
//  - they touch the ceiling.
//  - they are a bit shorter (height is 30, not 36)
union {
   box { <36,66,13>,  <128,96,-9>  texture { TCCabinet } }

   object { Cabinet_Door_Upper	translate <38,66,-9> }
   object { Cabinet_Handle	translate <50,72,-9> }

   object { Cabinet_Door_Upper	translate <56,66,-9> }
   object { Cabinet_Handle	translate <60,72,-9> }

   object { Cabinet_Door_Upper	translate <74,66,-9> }
   object { Cabinet_Handle	translate <86,72,-9> }

   object { Cabinet_Door_Upper	translate <92,66,-9> }
   object { Cabinet_Handle	translate <104,72,-9> }

   object { Cabinet_Door_Upper	translate <110,66,-9> }
   object { Cabinet_Handle	translate <114,72,-9> }
}

//
// And finally, the little cabinet over the fridge:
//
union {
   box { <0,76,13>,  <36,96,-9>  texture { TCCabinet } }

   object { Cabinet_Door_Half	translate <2,77,-9> }
   object { Cabinet_Handle	translate <14,83,-9> }
   
   object { Cabinet_Door_Half	translate <20,77,-9> }
   object { Cabinet_Handle	translate <24,83,-9> }
}

//========================= END CABINET SECTION =========================

//
// Declare an Upright Kitchen Fridge (UKF)...
//
#include "mlt_ukf.inc"
union {
   object { UKFridge }
   //
   // Here we add my name on a chrome plaque, like the brandname...
   //
   object { Marvelous scale 0.25
	    translate <UKF_Width/10,UKF_Top-4,UKF_Front> }

   //
   // Here we add some GIF-Art onto the fridge...
   //
   object { Art1  scale 2.0 rotate 2*z
	    translate <UKF_Width/3.5,UKF_Top*0.78,UKF_Front> }
   object { Art2  scale 2.0 rotate -5*z
	    translate <-UKF_Width/4,UKF_Top*0.88,UKF_Front> }

   object { Art3 scale 0.75 rotate 90*y rotate 3*x
	    translate <+UKF_Width/2,UKF_Top*0.80,3> }

   translate <UKF_Width/2+2,0.25,12-UKF_Depth/2>
}


//========================= BEGIN ROOM SECTION =========================
//
// The Rear, Left and Right walls ... are all simply white...
//
plane { z,13
   bounded_by { BRoom }
   texture { TWPaper2 scale 3 }
}
// Two outlets on the rear wall...
object { Outlet  translate <57,56,13> }
object { Outlet  translate <107,56,13> }

//
// On the left wall, there is a strip of wall paper just above a chair
// rail on the left wall.
//
plane { x,0
   bounded_by { BRoom }
   texture { TWalls }
}

box { <0,47,-200>,<0.05,54,13>			// Left Wall
      texture { TWPaper1 scale 7 rotate -90*y translate y*47 }}
#include "mltcrail.inc"
object {
   ChairRail
   // First we rotate, then scale and move in Z...
   rotate -90*y scale <1,1,213/12> translate <0,43,13-213/2>
}

//
// Put a poster on the right wall...
//
plane { x,128
   bounded_by { BRoom }
   texture { TWalls }
}

object {
   Art4
   scale 6.0
   rotate -90*y
   translate <128,62,-36>
}


//
// The Floor is checked...
//
plane { y, 0
   bounded_by { BRoom }
   texture { TFloor }
}

//
// The Ceiling is not...
//
plane { y, 96 
   bounded_by { BRoom }
   texture { TCeiling }
}

//========================= END ROOM SECTION =========================


/*End of file */



