
// This is include file for sink.jpg by Timo Ettanen

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"

#declare Handle =
  union{
    difference{
      sphere{<0,0,0>,5.5 scale<0.5,1,0.5> translate<0,5,0>}
      sphere{<0,0,0>,5.5 inverse}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-60,0>}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-120,0>}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-180,0>}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-240,0>}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-300,0>}
      cylinder{<3.2,0,0><3.2,5,0>,1.2 rotate<0,-360,0>}
    }
    sphere{<0,0,0>,0.8
              scale<1,0.4,1>
              translate<0,5.45,0>
              pigment{Red}
              finish{Shiny}
    }
    bounded_by{box{<-2.751,0,-2.751><2.751,5.9,2.751>}}
  }

#declare Hana =
  union{
    difference{
      sphere{<0,0,0>,7 scale<1,0.8,0.5> }
      union{
        plane{x,0 rotate<0,0,35> translate<6.7,0,0>inverse}
        plane{x,0 rotate<0,0,-35> translate<-6.7,0,0> }
      }
    }
    cone{<0,2.5,0>,2.8<0,8.5,0>,1.8}
    sphere{<0,0,0>,1.8 scale<1,0.4,1> translate<0,8.5,0>}
    union{
      union{
        cylinder{<5,0,0><28,0,0>,1.3 }
        torus{2.5,1.3 rotate<90,0,0>
                clipped_by{plane {x,0 inverse} }
                translate <28,-2.5,0>
        }
        rotate<0,0,30>
        translate<0,6.2,0>
        clipped_by{box{<26,14,-5><30,18.2,5> inverse}}
      }
      cylinder{<27.95,16,0><27.95,18.2,0>,1.6}
      sphere{<0,0,0>,1.6 scale<1,0.3,1> translate<27.95,18.2,0>}
      translate<-5,-2.7,0>
      rotate<0,130,0>
    }
    object{Handle rotate<0,0,55> translate<-4.5,2.6,0>}
    object{Handle rotate<0,0,-55> translate<4.5,2.6,0>}

    texture{Polished_Chrome}
  }

#declare cutter =
  difference{
    union{
      sphere{< 11, -9, 10 >,5}
      sphere{< 11, -9, 33 >,5}
      sphere{< 34, -9, 10 >,5}
      sphere{< 34, -9, 33 >,5}
      box{<11, -14, 10 ><34, 1, 33 >}
      box{<6, -9, 10 ><39, 1, 33 >}
      box{<11, -9, 5 ><34, 1, 38 >}
      cylinder{<11, -9, 10><11, -9, 33>,5}
      cylinder{<34, -9, 10><34, -9, 33>,5}
      cylinder{<11, -9, 10><34, -9, 10>,5}
      cylinder{<11, -9, 33><34, -9, 33>,5}
      cylinder{<11, -9, 10><11, 1, 10>,5}
      cylinder{<34, -9, 10><34, 1, 10>,5}
      cylinder{<11, -9, 33><11, 1, 33>,5}
      cylinder{<34, -9, 33><34, 1, 33>,5}
      cylinder{<11, -1, 10><11, 1, 10>,6}
      cylinder{<34, -1, 10><34, 1, 10>,6}
      cylinder{<11, -1, 33><11, 1, 33>,6}
      cylinder{<34, -1, 33><34, 1, 33>,6}
      box{<5,-1,10><40,1,33>}
      box{<11,-1,4><34,1,39>}
    }
    union{
      torus{6,1 bounded_by{
                   box{<-7.001,-1.001,-7.001><0,1.001,0>}}
                   clipped_by{bounded_by }
          translate<11,-1,10>
      }
      torus{6,1 bounded_by{
                   box{<0,-1.001,-7.001><7.001,1.001,0>}}
                   clipped_by{bounded_by }
          translate<34,-1,10>
      }
      torus{6,1 bounded_by{
                   box{<0,-1.001,0><7.001,1.001,7.001>}}
                   clipped_by{bounded_by }
          translate<34,-1,33>
      }
      torus{6,1 bounded_by{
                   box{<-7.001,-1.001,0><0,1.001,7.001>}}
                   clipped_by{bounded_by }
          translate<11,-1,33>
      }
      cylinder{<11,-1,4><34,-1,4>,1}
      cylinder{<40,-1,10><40,-1,33>,1}
      cylinder{<34,-1,39><11,-1,39>,1}
      cylinder{<5,-1,33><5,-1,10>,1}
    }
  }  // end of diff."cutter"


#declare cutter2 =                        //this is the drain
  difference{
    union{
      torus{1.3,0.4}
      cylinder{<0,-0.4,0><0,1.2,0>,1.3}
      cylinder{<0,0,0><0,1.2,0>,2.4}
      cylinder{<0,0.7,0><0,1.2,0>,3.0}
      union{                                  //the drain holes
        cylinder{<0.9,-0.3,0><0.8,-1,0>,0.45 }
        cylinder{<0.9,-0.3,0><0.8,-1,0>,0.45 rotate<0,-72,0>}
        cylinder{<0.9,-0.3,0><0.8,-1,0>,0.45 rotate<0,-144,0>}
        cylinder{<0.9,-0.3,0><0.8,-1,0>,0.45 rotate<0,-216,0>}
        cylinder{<0.9,-0.3,0><0.8,-1,0>,0.45 rotate<0,-288,0>}
        pigment{Black}
      }
    }
    torus{2.4,0.7}
    sphere{<0,0,0>,0.3 scale<1,0.5,1> translate<0,-0.4,0>}
    texture{Polished_Chrome}
   bounded_by{sphere{<0,0.7,0>,3.01}}
   scale 1.15
  }


#declare Sink =
  union{
    difference{
      union{
        box{<0,-4,1><80,0,59>}
        box{<1,-4,0><79,0,60>}
        box{<2,-20,2><78,0,58>}
        cylinder{<1,-4,1><1,0,1>,1}
        cylinder{<79,-4,1><79,0,1>,1}
        cylinder{<1,-4,59><1,0,59>,1}
        cylinder{<79,-4,59><79,0,59>,1}
        sphere{<1,0,1>,1}
        sphere{<79,0,1>,1}
        sphere{<1,0,59>,1}
        sphere{<79,0,59>,1}
        cylinder{<1,0,1><79,0,1>,1}
        cylinder{<79,0,1><79,0,59>,1}
        cylinder{<79,0,59><1,0,59>,1}
        cylinder{<1,0,59><1,0,1>,1}
        sphere{<0,0,0>,0.5 scale<1,0.4,1> translate<40,0,32.5>}
        cone{<40,0,32.5>,0.3<40,0.5,32.5>,0.15}
      }
      object{cutter}
      object{cutter translate<35,0,0> }
      object{cutter2 translate<29,-14.9,28> }
      object{cutter2 translate<51,-14.9,28> }
    }
    object{Hana translate<40,0,45>}

    texture{Chrome_Metal}
  }

