#declare Bottle = object {
	union {
		difference {                       // body
			cylinder {<0, 0.05, 0>,<0, 0.3, 0>, 0.1 open}
			cylinder {<0, 0.04, 0>,<0, 0.35, 0>, 0.09 open}
		}
		difference {            			// bottom
			sphere {<0, 0.05, 0>, 0.1 }
			sphere {<0, 0.05, 0>, 0.09 }
			plane {y, 0}
			plane {-y, -0.05 pigment {color rgbf <1, 1, 1, 1>}}
		}
		intersection {						// bottomcap
			sphere {<0, 0.05, 0>, 0.09 pigment {color rgbf <1, 1, 1, 1>}}
			difference {
				sphere {<0, -0.2, 0>, 0.2 translate y*0.02}
				plane {y, 0}
			}
		}
		difference {      					// top
			sphere {<0, 0.3, 0>, 0.1}
			sphere {<0, 0.3, 0>, 0.09}
			plane {y, 0.3 pigment {color rgbf <1, 1, 1, 1>}}
			sphere {<0, 0, 0>, 0.045 scale <1, 2, 1> translate y*0.45
				pigment {color rgbf <1, 1, 1, 1>}
			}
		}
		difference {            			// neck
			sphere {<0, 0, 0>, 0.055 scale <1, 2, 1> translate y*0.45}
			sphere {<0, 0, 0>, 0.045 scale <1, 2, 1> translate y*0.45}
			sphere {<0, 0.3, 0>, 0.1 pigment {color rgbf <1, 1, 1, 1>}}
			sphere {<0, 0, 0>, 0.03 scale <1, 0.9, 1> translate y*0.56
				pigment {color rgbf <1, 1, 1, 1>}
			}
		}
		difference {						// necktop
			sphere {<0, 0, 0>, 0.04 scale <1, 0.9, 1> translate y*0.56}
			sphere {<0, 0, 0>, 0.03 scale <1, 0.9, 1> translate y*0.56}
			sphere {<0, 0, 0>, 0.055 scale <1, 2, 1> translate y*0.45
				pigment {color rgbf <1, 1, 1, 1>}
			}
			cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.015 translate y*0.55}
		}
		difference {						// top ring
			sphere {<0, 0, 0>, 0.035 scale <1, 0.4, 1> translate y*0.59}
			cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.015 translate y*0.59}
			sphere {<0, 0, 0>, 0.04 scale <1, 0.9, 1> translate y*0.56
				pigment {color rgbf <1, 1, 1, 1>}
			}
		}
	}
	texture {
		pigment { color rgbf <0.86, 0.9, 0.86, 0.8> }
		finish {
			ambient 0.15
			phong 1.0 phong_size 80
			specular 0.8
			roughness 0.01
			reflection 0.5
			refraction 1
			ior 1.5
		}
	}
	texture {
		pigment {
			image_map {
				gif "label.gif"
				once
				filter 0, 1
				map_type 2
				interpolate 2
			}
		}
		finish { ambient 0.2 }
		scale <0.2, 0.25, 0.2>
		rotate -y*110
		translate y*0.05
	}
	scale 1.5
}

#declare Wine_glass = object {
union {
	difference {
		union {
			difference {
				blob {
					threshold 0.5
					component 0.8, 2.0, <0.0, 0.7, 0.0>
					component 1.0, 0.3, <0.0, -0.2, 0.0>
					component 1.0, 0.15, <0.0, -0.5, 0.0>
					component 1.0, 0.15, <0.0, -0.6, 0.0>
					component 1.0, 0.15, <0.0, -0.7, 0.0>
					component 1.0, 0.15, <0.0, -0.8, 0.0>
					component 1.0, 0.3, <0.0, -0.9, 0.0>
				}
				plane {y, 1.1 inverse}
			}
			difference {
				object {
					Ellipsoid
					scale <2, 1, 2>
					translate <0, -1.99, 0>
				}
				plane {y, -1.06}
			}
		}
		object {
			Ellipsoid
			scale <0.87, 0.85, 0.87>
			translate <0, 0.78, 0>
		}
		texture {
			pigment { color rgbf <1, 0.95, 0.95, 0.8> }
			finish {
				ambient 0.15
				phong 1.0 phong_size 80
				specular 0.8
				roughness 0.01
				reflection 0.5
				refraction 1
				ior 1.5
			}
		}
	}
	difference { 		// Wine
		object {
			Ellipsoid
			scale <0.87, 0.85, 0.87>
			pigment { color rgbf <0.6, 0, 0, 0.6> }
			finish {
				ambient 0.2
				refraction 1
				ior 1.33
			}
		}
		object {
			plane {y, -0.3 inverse}
			pigment { color rgbf <0.6, 0, 0, 0.6> }
			finish {
				ambient 0.2
				reflection 0.4
				refraction 1
				ior 1.3
			}
			normal { ripples 0.2 scale <0.1, 0.1, 0.1> }
		}
		translate <0, 0.78, 0>
	}
}
translate <0, 1.06, 0>
}

#declare Plate = object {
	difference {
		cone { <0, 0, 0>, 1, <0, 0.1, 0>, 1.2 }
		cone { <0, 0, 0>, 1, <0, 0.1, 0>, 1.35 translate y*0.05}
	}
	pigment { color rgb <0.8, 0.95, 1> }
	finish {
		metallic
		ambient 0.25
		phong 1 phong_size 50
		reflection 0.3
	}
}

#declare Bowl = object {
	difference {
		sphere {<0, 0, 0>, 0.4}
		plane {y, -0.25 inverse}
		pigment { color rgb <0.8, 0.95, 1> }
		finish {
			metallic
			ambient 0.25
			phong 1 phong_size 50
			reflection 0.3
		}
		scale <1, 0.4, 1>
		translate <0, 0.5, 0>
	}
}







