#declare Left_support = difference {
	union {
		difference {
			box {<0.25, 0.05, 0>, <0.45, 1.6, 0.05>}
			box {<0.27, 0, -0.1>, <0.43, 1.7, 0.02>}
			cylinder {<0.35, 0.9, -0.1>, <0.35, 0.9, 0.1>, 0.05}
			cylinder {<0.35, 0.2, -0.1>, <0.35, 0.2, 0.1>, 0.05}
			box {<0.3, 0.2, -0.1>, <0.4, 0.9, 0.1>}
			cylinder {<0.35, 1.4, -0.1>, <0.35, 1.4, 0.1>, 0.05}
			cylinder {<0.35, 1.45, -0.1>, <0.35, 1.45, 0.1>, 0.05}
			box {<0.3, 1.4, -0.1>, <0.4, 1.45, 0.1>}
		}
		cylinder {<0.35, 1.15, -0.01>, <0.35, 1.15, 0.06>, 0.15}
		cylinder {<0.23, 1.6, 0.02>, <0.47, 1.6, 0.02>, 0.04}
	}
	cylinder {<0.35, 1.15, -0.1>, <0.35, 1.15, 0.1>, 0.1}
}

#declare Right_support = difference {
	union {
		difference {
			box {<0.25, 0.05, 0>, <0.45, 1.6, 0.05>}
			box {<0.27, 0, -0.1>, <0.43, 1.7, 0.02>}
			cylinder {<0.35, 0.9, -0.1>, <0.35, 0.9, 0.1>, 0.05}
			cylinder {<0.35, 0.7, -0.1>, <0.35, 0.7, 0.1>, 0.05}
			box {<0.3, 0.7, -0.1>, <0.4, 0.9, 0.1>}
			cylinder {<0.35, 1.4, -0.1>, <0.35, 1.4, 0.1>, 0.05}
			cylinder {<0.35, 1.45, -0.1>, <0.35, 1.45, 0.1>, 0.05}
			box {<0.3, 1.4, -0.1>, <0.4, 1.45, 0.1>}
		}
		cylinder {<0.35, 1.15, -0.01>, <0.35, 1.15, 0.06>, 0.15}
		cylinder {<0.35, 0.45, -0.01>, <0.35, 0.45, 0.06>, 0.15}
		cylinder {<0.23, 1.6, 0.02>, <0.47, 1.6, 0.02>, 0.04}
	}
	cylinder {<0.35, 0.45, -0.1>, <0.35, 0.45, 0.1>, 0.1}
	translate x*0.65
}

#declare Inbetween = difference {
	box {<0.35, 1.05, 0>, <1, 1.25, 0.05>}
	box {<0.3, 1.07, -0.1>, <1.1, 1.23, 0.02>}
	cylinder {<0.35, 1.15, -0.1>, <0.35, 1.15, 0.1>, 0.12}
	cylinder {<1, 1.15, -0.1>, <1, 1.15, 0.1>, 0.12}
	cylinder {<0.6, 1.15, -0.1>, <0.6, 1.15, 0.1>, 0.05}
	cylinder {<0.75, 1.15, -0.1>, <0.75, 1.15, 0.1>, 0.05}
	box {<0.6, 1.1, -0.1>, <0.75, 1.2, 0.1>}
}

#declare Roller = union {
	difference {
		cylinder {<0.35, 1.15, 0>, <0.35, 1.15, 0.05>, 0.098}
		cylinder {<0.35, 1.15, -0.1>, <0.35, 1.15, 0.1>, 0.09}
	}
	difference {
		cylinder {<0.35, 1.15, 0>, <0.35, 1.15, 0.05>, 0.05}
		cylinder {<0.35, 1.15, -0.1>, <0.35, 1.15, 0.1>, 0.042}
	}
	union {
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*0}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*40}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*80}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*120}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*160}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*200}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*240}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*280}
		sphere {<0, 0, 0>, 0.024 translate x*0.07 rotate z*320}
		translate <0.35, 1.15, 0.035>
	}
	texture {My_chrome}
}

#declare Base = difference {
	box {<0, 0, -0.17>, <1.35, 0.05, 2.74>}
	box {<0.2, -0.2, -0.3>, <1.15, 0.02, 2.9>}
	box {<-0.1, -0.1, -0.03>, <1.4, 0.021, 2.54>}
}

#declare Handle = union {
	cylinder {<0, 0, 0>, <0.1, 0, 0>, 0.05
		texture {Dark_metal}
	}
	cylinder {<0.1, 0, 0>, <0.7, 0, 0>, 0.03}
	sphere {
		<0.7, 0, 0>, 0.1
		pigment {color rgb <0.2, 0.2, 0.2>}
		finish {ambient 0.2 phong 0.8 phong_size 8}
	}
	translate x*0.08
	texture {My_chrome}
}

#declare Wheel = union {
	cone {<1, 1.15, -0.03>, 0.12, <1, 1.15, -0.18>, 0.08
		texture {Dark_metal}
	}
	object {
		Handle
		rotate y*20
		translate <1, 1.15, -0.075>
	}
	object {
		Handle
		rotate y*20
		rotate z*90
		translate <1, 1.15, -0.075>
	}
	object {
		Handle
		rotate y*20
		rotate z*180
		translate <1, 1.15, -0.075>
	}
	object {
		Handle
		rotate y*20
		rotate z*270
		translate <1, 1.15, -0.075>
	}
	torus {0.5, 0.02 rotate x*90 translate <1, 1.15, -0.075-0.181985>}

	translate <-1, -1.15, 0>
	rotate -z*60
	translate <1, 1.15, 0>

	texture {My_chrome}
}

#declare Top = union {
	cylinder {<0.03, 1.6, 0.025>, <1.32, 1.6, 0.025>, 0.02}
	cylinder {<0.03, 1.6, 0.025+2.5>, <1.32, 1.6, 0.025+2.5>, 0.02}
	cylinder {<0.03, 1.6, 0.025>, <0.03, 1.6, 2.525>, 0.02}
	cylinder {<0.03+1.29, 1.6, 0.025>, <0.03+1.29, 1.6, 2.525>, 0.02}
	sphere {<0.03, 1.6, 0.025>, 0.02}
	sphere {<0.03, 1.6, 0.025+2.5>, 0.02}
	sphere {<0.03+1.29, 1.6, 0.025>, 0.02}
	sphere {<0.03+1.29, 1.6, 0.025+2.5>, 0.02}
	texture {My_chrome}
}

#declare Shaft = object {
	cylinder {<0.35, 1.15, -0.01>, <0.35, 1.15, 2.56>, 0.041}
	texture {My_chrome}
}

#declare Spring = union {
	torus {0.03, 0.014 rotate z*15 translate <0.165, 0.07, -0.085>}
	torus {0.03, 0.014 rotate z*15 translate <0.165, 0.11, -0.085>}
	torus {0.03, 0.014 rotate z*15 translate <0.165, 0.15, -0.085>}
	torus {0.03, 0.014 rotate z*15 translate <0.165, 0.19, -0.085>}
	torus {0.03, 0.014 rotate z*15 translate <0.165, 0.23, -0.085>}
	texture {My_chrome}
}

#declare Detail = union {
	difference {
		cylinder {<0.35, 0.45, -0.01>, <0.35, 0.45, 0.06>, 0.15}
		cylinder {<0.35, 0.45, -0.1>, <0.35, 0.45, 0.1>, 0.1}
		translate -z*0.08
	}
	difference {
		box {<0.2, 0.27, 0.01>, <0.5, 0.45, 0.04>}
		cylinder {<0.35, 0.45, -0.1>, <0.35, 0.45, 0.1>, 0.12}
		translate -z*0.08
	}
	object {Roller translate <0, -0.7, -0.08>}
	box {<0.165, 0.27, -0.15>, <0.535, 0.3, -0.02>}
	difference {
		union {
			cylinder {<0.165, 0.05, -0.085>, <0.165, 0.3, -0.085>, 0.065}
			cylinder {<0.535, 0.05, -0.085>, <0.535, 0.3, -0.085>, 0.065}
		}
		box {<0, 0.08, -0.3>, <0.9, 0.24, 0.4>}
		cylinder {<0.165, -0.1, -0.085>, <0.165, 0.27, -0.085>, 0.045}
		cylinder {<0.535, -0.1, -0.085>, <0.535, 0.27, -0.085>, 0.045}
	}
	texture {Dark_metal}
}

#declare Press_high = difference {
	cylinder {<0.35, 1.15, 0.13>, <0.35, 1.15, 2.37>, 0.35}
	cone {<0.35, 1.15, -0.3>, 0.6, <0.35, 1.15, 0.18>, 0.25
		texture {My_chrome}
	}
	texture {
		My_chrome
		normal {
			bump_map {
				gif "bump100.gif"
				once
				map_type 2
				interpolate 2
				bump_size -6
			}
			translate <-0.5, -0.5, -0.5>
			rotate <90, 0, 160>
			scale <1.4, 0.32, 1.6>
			translate <0.5, 0.5, 0.5>
			translate <0.35, 1.15, 0.7>
		}
	}
}

#declare Press_low = object {
	difference {
		cylinder {<0.35, 0.45, 0.13>, <0.35, 0.45, 2.37>, 0.35}
		difference {
			cone {<0.35, 0.45, -0.3>, 0.6, <0.35, 0.45, 0.18>, 0.25}
			cylinder {<0.35, 0.45, -0.4>, <0.35, 0.45, 0.2>, 0.1}
			texture {My_chrome}
		}
	}
	texture {
		My_chrome
		normal {
			bump_map {
				gif "bump100b.gif"
				once
				map_type 2
				interpolate 2
				bump_size -6
			}
			translate <-0.5, -0.5, -0.5>
			rotate <90, 0, 210>
			scale <1.4, 0.32, 1.6>
			translate <0.5, 0.5, 0.5>
			translate <0.35, 0.45, 0.7>
		}
	}
}

#declare Paper = union {
	difference {
		cylinder {<1, 0.45, 0.1>, <1, 0.45, 2.32>, 0.25
			pigment {color rgb <0.85, 0.85, 0.85>}
			finish {ambient 0.3 phong 1}
		}
		plane {z, 0
			texture {
				pigment {
					onion
					color_map {
					[0 0.3 color rgb <0.7, 0.7, 0.7> color rgb <0.7, 0.7, 0.7>]
					[0.3 1 color rgb <0.85, 0.85, 0.85> color rgb <0.85, 0.85, 0.85>]
					}
					frequency 12
				}
				finish { ambient 0.3 phong 1 }
				scale 0.25
				translate <1, 0.45, 0>
			}
			translate z*0.18
		}
	}
	union {
		smooth_triangle {
		<0.35, 0.8, 0.18>, <0, 1, 0>,
		<0.35, 0.8, 2.32>, <0, 1, 0>,
		<1, 0.7, 0.18>, <0, 1, 0>
		}
		smooth_triangle {
		<0.35, 0.8, 2.32>, <0, 1, 0>,
		<1, 0.7, 2.32>, <0, 1, 0>,
		<1, 0.7, 0.18>, <0, 1, 0>
		}
		pigment {color rgb <0.85, 0.85, 0.85>}
		finish {ambient 0.3 phong 1}
	}
	object {
		cylinder {<0.35, 0, 0>, <0.35, 0, 2.5>, 0.8}
		clipped_by {plane {x, 0.35}}
		clipped_by {plane {-z, -0.18 }}
		clipped_by {plane {z, 2.32}}
		clipped_by {plane {-y, -0.2}}

		texture {
			pigment {color rgb <0.85, 0.85, 0.85>}
			finish {ambient 0.3 phong 1}
		}
		texture {
			pigment {
				image_map {
					gif "d100.gif"
					filter 255, 1
					once
					map_type 2
					interpolate 2
				}
			}
			finish {ambient 0.3 phong 1}

			translate <-0.5, -0.5, -0.5>
			rotate <90, 0, 95>
			scale <1.4, 0.32, 1.6>
			translate <0.5, 0.5, 0.5>
			translate <0.35, 0, 0.7>
		}
	}
}

#declare Tooth = difference {
	box {<-0.05, -0.05, -0.01>, <0.05, 0.1, 0.01>}
	cylinder {<0, -0.2, -0.1>, <0, -0.2, 0.1>, 0.2}
	cylinder {<0, -0.2, -0.1>, <0, -0.2, 0.1>, 0.25 inverse}
	cylinder {<-0.075, 0, -0.1>, <-0.075, 0, 0.1>, 0.1 inverse}
	cylinder {<0.075, 0, -0.1>, <0.075, 0, 0.1>, 0.1 inverse}
	translate <0, 0.2, 0.09>
	texture {My_chrome}
}

#declare Small = union {
	difference {
		cylinder {<0.35, 1.15, 0.08>, <0.35, 1.15, 0.1>, 0.2}
		cylinder {<0.35, 1.15, -0.1>, <0.35, 1.15, 0.09>, 0.18}
		texture {My_chrome}
	}
	union {
		object {Tooth rotate z*0}
		object {Tooth rotate z*22.5}
		object {Tooth rotate z*45}
		object {Tooth rotate z*67.5}
		object {Tooth rotate z*90}
		object {Tooth rotate z*112.5}
		object {Tooth rotate z*135}
		object {Tooth rotate z*157.5}
		object {Tooth rotate z*180}
		object {Tooth rotate z*202.5}
		object {Tooth rotate z*225}
		object {Tooth rotate z*247.5}
		object {Tooth rotate z*270}
		object {Tooth rotate z*292.5}
		object {Tooth rotate z*315}
		object {Tooth rotate z*337.5}
		translate <0.35, 1.15, 0>
	}
	texture {My_chrome}
}

#declare Large = union {
	difference {
		cylinder {<1, 1.15, 0.08>, <1, 1.15, 0.1>, 0.4}
		cylinder {<1, 1.15, -0.1>, <1, 1.15, 0.09>, 0.38}
		difference {
			cylinder {<1, 1.15, -0.2>, <1, 1.15, 0.2>, 0.36}
			cylinder {<1, 1.15, -0.3>, <1, 1.15, 0.3>, 0.15}
			box {<1-0.06, 0.6, -0.3>, <1+0.06, 1.7, 0.3>}
			box {<0.5, 1.15-0.06, -0.3>, <1.5, 1.15+0.06, 0.3>}
		}
		texture {My_chrome}
	}
	union {
		object {Tooth translate y*0.2 rotate z*0}
		object {Tooth translate y*0.2 rotate z*12}
		object {Tooth translate y*0.2 rotate z*24}
		object {Tooth translate y*0.2 rotate z*36}
		object {Tooth translate y*0.2 rotate z*48}
		object {Tooth translate y*0.2 rotate z*60}
		object {Tooth translate y*0.2 rotate z*72}
		object {Tooth translate y*0.2 rotate z*84}
		object {Tooth translate y*0.2 rotate z*96}
		object {Tooth translate y*0.2 rotate z*108}
		object {Tooth translate y*0.2 rotate z*120}
		object {Tooth translate y*0.2 rotate z*132}
		object {Tooth translate y*0.2 rotate z*144}
		object {Tooth translate y*0.2 rotate z*156}
		object {Tooth translate y*0.2 rotate z*168}
		object {Tooth translate y*0.2 rotate z*180}
		object {Tooth translate y*0.2 rotate z*192}
		object {Tooth translate y*0.2 rotate z*204}
		object {Tooth translate y*0.2 rotate z*216}
		object {Tooth translate y*0.2 rotate z*228}
		object {Tooth translate y*0.2 rotate z*240}
		object {Tooth translate y*0.2 rotate z*252}
		object {Tooth translate y*0.2 rotate z*264}
		object {Tooth translate y*0.2 rotate z*276}
		object {Tooth translate y*0.2 rotate z*288}
		object {Tooth translate y*0.2 rotate z*300}
		object {Tooth translate y*0.2 rotate z*312}
		object {Tooth translate y*0.2 rotate z*324}
		object {Tooth translate y*0.2 rotate z*336}
		object {Tooth translate y*0.2 rotate z*348}
		translate <1, 1.15, 0>
	}
	translate <-1, -1.15, 0>
	rotate -z*60
	translate <1, 1.15, 0>

	texture {My_chrome}
}

#declare Printer = union {
	object {Left_support}
	object {Right_support}
	object {Inbetween}
	object {
		Left_support
		translate <-0.35, 0, -0.025>
		rotate y*180
		translate <0.35, 0, 0.025+2.5>
	}
	object {
		Right_support
		translate <-1, 0, -0.025>
		rotate y*180
		translate <1, 0, 0.025+2.5>
	}
	object {
		Inbetween
		translate <0, -1.15, -0.025>
		rotate x*180
		translate <0, 1.15, 0.025+2.5>
	}
	object {Roller}
	object {Roller translate <0.65, -0.7, 0>}
	object {Base}
	object {Wheel}
	object {Top}
	object {Shaft}
	object {Shaft translate <0.65, 0, 0>}
	object {Shaft translate <0, -0.7, -0.08>}
	object {Shaft translate <0.65, -0.7, 0>}
	object {Detail}
	object {Spring}
	object {Spring translate x*0.37}
	object {Press_high}
	object {Press_low}
	object {Paper}
	object {Small}
	object {Large}
	texture {Dark_metal}
}
