// Persistence Of Vision Raytracer version 2.2 sample file.

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "sundial.inc"

#declare clouds1 = pigment {
	bozo
   	turbulence .875
   	color_map {
		[0.0, 0.2   color Gray80 filter .5 color Gray80 filter .75]
     		[0.2, 0.4   color Gray80 filter .75 color White filter .875]
		[0.4, 0.6   color White filter .875 color Clear]
     		[0.6, 1.001 color Clear color Clear]
    	}
}

#declare clouds2 = pigment {
	bozo
   	turbulence 1
   	color_map {
		[0.0, 0.2   color White color White ]
     		[0.2, 0.6   color White color Clear]
     		[0.6, 1.001 color Clear color Clear]
    	}
}

#declare haze = pigment {
	bozo
	turbulence .25
   	color_map {
		[0.0, 0.25 color White filter .7 color White filter .8]
		[0.25, 0.4 color White filter .8 color Clear]
	  	[0.4, 1.001 color Clear color Clear]
    	}
}

#declare rock = 
	texture{pigment{color Black}}
	texture{Grnt15a scale <1.2, 3, 1.5> rotate <70, 0, 30>
       		finish {crand 0.03}
	}
	texture{Grnt2a scale <3, 3, 4> rotate <0, 0, 40>}
	texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
      		finish {specular .1 roughness .01 diffuse 1}
	}

camera {
	location <3000, 650, 0>	
	direction <-1.09, 0,  0>
	look_at <0, -400, 0> 
}                      

light_source {<5000000, 10000000, 5000000> color red 1.5 green 1.5 blue 1.5
	area_light <-79523, 0, 79523>, <-150000, 37488, -150000>, 2, 2
	adaptive 0
	jitter
}

height_field {gif "canyon2.gif" 
	texture {rock scale .03 
		finish {crand .15 ambient .25}
	}
	translate <-.5, 0, -.5>
	rotate -90*y
	scale <5500, 625, -5000>
	translate <225, 0, 0>
}

height_field {gif "canpart.gif" 
	texture {rock scale .03 
		finish {crand .15 ambient .25}
	}
	translate <-.5, 0, -.5>
	rotate -90*y
	scale <666.67, 600, -5000>
	translate <-4000, 0, -1000>
}

object {sundial scale 25 rotate 45*y translate <2690, 422, 130>}

fog {color red .8 green .9 blue 1.1 distance 5000}

box {<-2500, 0, -2500>, <2750, 1, 2500> 
	texture {pigment {red .2 green .3 blue .5} 
		normal {bumps .05 scale .1}
		finish {
			reflection .5 
			specular 1 
			roughness .05 
			diffuse 0
			ambient 0
		}
	}  
	translate 225*x
} 

plane {y, 350 no_shadow texture {haze scale 750}}

sphere {<0, 0, 0>, 50800 texture {Luminous clouds1 scale 750}
	rotate 10*x translate -50000*y}

sphere {<0, -50000, 0>, 50875 no_shadow texture {Luminous clouds2 scale 500}}

sphere {<0, -500000, 0>, 501750 inverse no_shadow texture {Luminous pigment {NewMidnightBlue}}}

