/* File     : Planet.inc
 *
 * Purpose  : Green-blue planet definition
 * Author   : (C)1996 Matthew Hunter
 * Version  : 0.01 (26 June 1996)
 *            0.02 (27 June 1996)
 *              Release Version.
 *            0.03 (27 June 1996)
 *              Added clouds too.
 */

/* Input state
 *
 * planet_size contains the radius of the final planet. Note that the
 * final planet will be 1.1*planet_size including the atmosphere
 *
 * planet_rotation allows rotation of the planet about any of it's axis
 *
 * planet_position allows translation of the planet to the specified
 * location.
 *
 * Transformations are done in the order rotation, scale, translation.
 */

/* Output state
 *
 * Planet will be declared as the planet and atmosphere, including the
 * transformations given above.
 */

#ifndef (planet_rotation)
  #error "Rotation vector of planet must be specified.\n"
#end

#ifndef (planet_size)
  #error "Size of planet must be specified.\n"
#end

#ifndef (planet_position)
  #error "Location vector of planet must be specified.\n"
#end

#declare Atmos_Size = 1.1*planet_size
#declare Cloud_Size = 1.02*planet_size

#declare Planet = union {
object {
  sphere {
    <0,0,0>, 1
  }
  pigment {
    colour rgbt <1,1,1,1>
  }
  finish {
    phong 0.7
    phong_size 20
  }
  hollow
  halo {
    dust
    linear
    spherical_mapping
    turbulence 0.1
    max_value 1.0
    color_map {
      [0 color rgbt <0.6,0.8,1,0.5>]
      [0.909 color rgbt <0.6,0.8,1,0.5>]
      [1 color rgbt <1,1,1,1>]
    }
    samples 10
  }
  rotate planet_rotation
  scale <Atmos_Size,Atmos_Size,Atmos_Size>
  translate planet_position
}

object {
  sphere {
    <0,0,0>, 1
  }
  texture {  // very basic landmass texture
    pigment {
      bozo
      colour_map {
        [0.00 colour rgb <0.1,0.2,0.4>]
        [0.64 colour rgb <0.4,0.6,1.0>]
        [0.65 colour rgb <0.7,0.7,0.0>]
        [0.67 colour rgb <0.5,0.5,0.5>]
        [0.67 colour rgb <0.4,0.7,0.2>]
        [0.80 colour rgb <0.3,0.5,0.1>]
        [0.80 colour rgb <0.5,0.5,0.5>]
        [1.00 colour rgb <1.0,1.0,1.0>]
      }
      turbulence 0.3
    }
  }
  texture { // add some ice-caps
    pigment {
      gradient <0,1,0>
      colour_map {
        [0.00 colour rgbf <1,1,1,0>]
        [0.10 colour rgbf <1,1,1,0>]
        [0.15 colour rgbf <1,1,1,1>]
        [0.85 colour rgbf <1,1,1,1>]
        [0.90 colour rgbf <1,1,1,0>]
        [1.00 colour rgbf <1,1,1,0>]
      }
      turbulence 0.2
      scale <2,2,2>
      translate <0,-1,0>
    }
  }

  rotate planet_rotation
  scale <planet_size,planet_size,planet_size>
  translate planet_position
}

object {
  sphere {
    <0,0,0>, 1
  }
  hollow
  texture {  // very simple cloud texture
    pigment {
      bozo
      colour_map {
        [0.00 colour rgbf <1,1,1,1>]
        [0.70 colour rgbf <1,1,1,1>]
        [0.80 colour rgbf <1,1,1,0.5>]
        [1.00 colour rgbf <0.8,0.8,0.8,0>]
      }
      turbulence 0.5
    }
    finish {
      ambient 0.2
    }
    scale <0.5,0.5,0.5>
    translate <100,100,1000>
  }

  rotate planet_rotation
  scale <Cloud_Size,Cloud_Size,Cloud_Size>
  translate planet_position
}
}
